/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.client.v1.MNode;
import org.dataone.cn.batch.exceptions.NodeCommUnavailable;
import org.dataone.cn.batch.service.v2.IdentifierReservationQueryService;
import org.dataone.cn.batch.synchronization.NodeCommSyncObjectFactory;
import org.dataone.cn.batch.synchronization.tasks.SyncFailedTask;
import org.dataone.cn.batch.synchronization.type.NodeComm;
import org.dataone.cn.batch.synchronization.type.NodeCommState;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.synchronization.types.SyncObject;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.types.v2.TypeFactory;
import org.dataone.service.util.TypeMarshaller;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREParserException;

public class TransferObjectTask
implements Callable<Void> {
    private static final BigInteger CHECKSUM_VERIFICATION_SIZE_BYPASS_THRESHOLD = Settings.getConfiguration().getBigInteger("Synchronization.checksum.verify.size.bypass.threshold", BigInteger.valueOf(10000000L));
    static final Logger logger = Logger.getLogger(TransferObjectTask.class);
    private NodeComm nodeCommunications;
    private SyncObject task;
    private Session session = null;
    private HazelcastClient hzProcessingClient = HazelcastClientFactory.getProcessingClient();
    private HazelcastClient hzStorageClient = HazelcastClientFactory.getStorageClient();
    String cnIdentifier = Settings.getConfiguration().getString("cn.router.nodeId");
    String synchronizationObjectQueue = Settings.getConfiguration().getString("dataone.hazelcast.synchronizationObjectQueue");
    String hzSystemMetaMapString = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
    IMap<Identifier, SystemMetadata> hzSystemMetaMap;
    IdentifierReservationQueryService reserveIdentifierService;

    public TransferObjectTask(NodeComm nodeCommunications, SyncObject task) {
        this.nodeCommunications = nodeCommunications;
        this.task = task;
        this.hzSystemMetaMap = this.hzStorageClient.getMap(this.hzSystemMetaMapString);
        this.reserveIdentifierService = nodeCommunications.getReserveIdentifierService();
    }

    @Override
    public Void call() throws Exception {
        boolean isPidLocked;
        ILock hzPidLock;
        block13: {
            hzPidLock = null;
            String lockPid = this.task.getPid();
            isPidLocked = false;
            try {
                logger.info((Object)(this.task.taskLabel() + " Locking task of attempt " + this.task.getAttempt()));
                hzPidLock = this.hzProcessingClient.getLock((Object)lockPid);
                isPidLocked = hzPidLock.tryLock(1L, TimeUnit.SECONDS);
                if (isPidLocked) {
                    logger.info((Object)(this.task.taskLabel() + " Processing task"));
                    SystemMetadata systemMetadata = this.retrieveSystemMetadata();
                    if (systemMetadata == null) break block13;
                    logger.info((Object)(this.task.taskLabel() + " Writing task"));
                    try {
                        this.write(systemMetadata);
                    }
                    catch (VersionMismatch ex) {
                        logger.warn((Object)(this.task.taskLabel() + " Pid altered before processing complete! Placing back on hzSyncObjectQueue of attempt " + this.task.getAttempt()));
                        if (this.task.getAttempt() == 1) {
                            Identifier pid = new Identifier();
                            pid.setValue(this.task.getPid());
                            this.auditReplicaSystemMetadata(pid);
                        }
                        if (this.task.getAttempt() < 6) {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException iex) {
                                logger.error((Object)(this.task.taskLabel() + " " + iex.getMessage()));
                            }
                            this.hzProcessingClient.getQueue(this.synchronizationObjectQueue).put((Object)this.task);
                            this.task.setAttempt(Integer.valueOf(this.task.getAttempt() + 1));
                            break block13;
                        }
                        logger.error((Object)(this.task.taskLabel() + " Pid altered before processing complete! Unable to process"));
                    }
                    break block13;
                }
                if (this.task.getAttempt() < 100) {
                    logger.warn((Object)(this.task.taskLabel() + " Pid Locked! Placing back on hzSyncObjectQueue of attempt " + this.task.getAttempt()));
                    this.task.setAttempt(Integer.valueOf(this.task.getAttempt() + 1));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException iex) {
                        logger.error((Object)(this.task.taskLabel() + " " + iex.getMessage()));
                    }
                    this.hzProcessingClient.getQueue(this.synchronizationObjectQueue).put((Object)this.task);
                    break block13;
                }
                logger.error((Object)(this.task.taskLabel() + " Pid Locked! Unable to process pid " + this.task.getPid() + " from node " + this.task.getNodeId()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error((Object)(this.task.taskLabel() + "\n" + ex.getMessage()));
            }
        }
        if (isPidLocked) {
            hzPidLock.unlock();
            logger.debug((Object)(this.task.taskLabel() + " Unlocked task"));
        }
        return null;
    }

    private SystemMetadata retrieveSystemMetadata() {
        String memberNodeId = this.task.getNodeId();
        SystemMetadata systemMetadata = null;
        try {
            Identifier identifier = new Identifier();
            identifier.setValue(this.task.getPid());
            int tryAgain = 0;
            boolean needSystemMetadata = true;
            do {
                try {
                    Object mnRead = this.nodeCommunications.getMnRead();
                    if (mnRead instanceof MNRead) {
                        systemMetadata = ((MNRead)mnRead).getSystemMetadata(null, identifier);
                        needSystemMetadata = false;
                        continue;
                    }
                    if (!(mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead)) continue;
                    org.dataone.service.types.v1.SystemMetadata oldSystemMetadata = ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).getSystemMetadata(null, identifier);
                    systemMetadata = (SystemMetadata)TypeFactory.convertTypeFromType((Object)oldSystemMetadata, SystemMetadata.class);
                    needSystemMetadata = false;
                }
                catch (NotAuthorized ex) {
                    if (tryAgain < 2) {
                        ++tryAgain;
                        logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex1) {
                            logger.warn((Object)(this.task.taskLabel() + "\n" + (Object)((Object)ex)));
                        }
                        continue;
                    }
                    throw ex;
                }
                catch (ServiceFailure ex) {
                    if (tryAgain < 6) {
                        ++tryAgain;
                        logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex1) {
                            logger.warn((Object)(this.task.taskLabel() + "\n" + (Object)((Object)ex)));
                        }
                        continue;
                    }
                    throw ex;
                }
            } while (needSystemMetadata);
            if (!this.task.getPid().contentEquals(systemMetadata.getIdentifier().getValue())) {
                InvalidSystemMetadata invalidSystemMetadata = new InvalidSystemMetadata("567100", "Identifier " + this.task.getPid() + " retrieved from getObjectList is different from that contained in systemMetadata " + systemMetadata.getIdentifier().getValue());
                logger.error((Object)(this.task.taskLabel() + "\n" + invalidSystemMetadata.serialize(0)));
                this.submitSynchronizationFailed(this.task.getPid(), (BaseException)invalidSystemMetadata);
                return null;
            }
            logger.info((Object)(this.task.taskLabel() + " Retrieved SystemMetadata Identifier:" + systemMetadata.getIdentifier().getValue() + " from node " + memberNodeId + " for ObjectInfo Identifier " + identifier.getValue()));
        }
        catch (NotAuthorized ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (InvalidToken ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (ServiceFailure ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (NotFound ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (NotImplemented ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)(this.task.taskLabel() + "\n this didn't work"), (Throwable)ex);
            ServiceFailure serviceFailure = new ServiceFailure("-1", ex.getMessage());
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)serviceFailure);
            return null;
        }
        return systemMetadata;
    }

    private SystemMetadata processSystemMetadata(SystemMetadata systemMetadata) {
        try {
            logger.debug((Object)(this.task.taskLabel() + " Processing SystemMetadata"));
            boolean addOriginalReplica = true;
            ArrayList replicaList = new ArrayList();
            systemMetadata.setReplicaList(replicaList);
            Replica originalReplica = new Replica();
            NodeReference originalReplicaReference = new NodeReference();
            originalReplicaReference.setValue(this.task.getNodeId());
            originalReplica.setReplicaMemberNode(originalReplicaReference);
            originalReplica.setReplicationStatus(ReplicationStatus.COMPLETED);
            originalReplica.setReplicaVerified(new Date());
            systemMetadata.addReplica(originalReplica);
            logger.debug((Object)(this.task.taskLabel() + " Included replica for original MN"));
            logger.debug((Object)(this.task.taskLabel() + " Get Object Format"));
            ObjectFormat objectFormat = this.nodeCommunications.getCnCore().getFormat(systemMetadata.getFormatId());
            if (objectFormat != null && !objectFormat.getFormatType().equalsIgnoreCase("DATA")) {
                NodeReference cnReference = new NodeReference();
                cnReference.setValue(this.cnIdentifier);
                Replica cnReplica = new Replica();
                cnReplica.setReplicaMemberNode(cnReference);
                cnReplica.setReplicationStatus(ReplicationStatus.COMPLETED);
                cnReplica.setReplicaVerified(new Date());
                systemMetadata.addReplica(cnReplica);
                logger.debug((Object)(this.task.taskLabel() + " Added CN as replica because formatType " + objectFormat.getFormatType() + " is sciMetadata"));
            }
            if (systemMetadata.getOriginMemberNode() == null || systemMetadata.getOriginMemberNode().getValue().isEmpty()) {
                NodeReference originMemberNode = new NodeReference();
                originMemberNode.setValue(this.task.getNodeId());
                systemMetadata.setOriginMemberNode(originMemberNode);
            }
            if (systemMetadata.getAuthoritativeMemberNode() == null || systemMetadata.getAuthoritativeMemberNode().getValue().isEmpty()) {
                NodeReference authoritativeMemberNode = new NodeReference();
                authoritativeMemberNode.setValue(this.task.getNodeId());
                systemMetadata.setAuthoritativeMemberNode(authoritativeMemberNode);
            }
        }
        catch (ServiceFailure ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (NotFound ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (NotImplemented ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)ex);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)(this.task.taskLabel() + "\n this didn't work"), (Throwable)ex);
            ServiceFailure serviceFailure = new ServiceFailure("-1", ex.getMessage());
            this.submitSynchronizationFailed(this.task.getPid(), (BaseException)serviceFailure);
            return null;
        }
        return systemMetadata;
    }

    private void write(SystemMetadata systemMetadata) throws VersionMismatch {
        try {
            logger.info((Object)(this.task.taskLabel() + " Getting sysMeta from CN"));
            boolean doCreate = false;
            try {
                Session verifySubmitter = new Session();
                verifySubmitter.setSubject(systemMetadata.getSubmitter());
                doCreate = this.reserveIdentifierService.hasReservation(verifySubmitter, systemMetadata.getSubmitter(), systemMetadata.getIdentifier());
                logger.info((Object)(this.task.taskLabel() + " Create from reservation"));
            }
            catch (NotFound ex) {
                doCreate = true;
                logger.info((Object)(this.task.taskLabel() + " Create from Exception"));
            }
            if (doCreate) {
                if ((systemMetadata = this.processSystemMetadata(systemMetadata)) != null) {
                    this.createObject(systemMetadata);
                }
            } else {
                SystemMetadata cnSystemMetadata = (SystemMetadata)this.hzSystemMetaMap.get((Object)systemMetadata.getIdentifier());
                if (cnSystemMetadata != null && cnSystemMetadata.getChecksum() != null) {
                    Checksum existingChecksum = cnSystemMetadata.getChecksum();
                    Checksum newChecksum = systemMetadata.getChecksum();
                    if (!existingChecksum.getAlgorithm().equalsIgnoreCase(systemMetadata.getChecksum().getAlgorithm())) {
                        logger.info((Object)(this.task.taskLabel() + " Try to retrieve a checksum from membernode that matches the checksum of existing systemMetadata"));
                        Object mnRead = this.nodeCommunications.getMnRead();
                        if (mnRead instanceof MNRead) {
                            newChecksum = ((MNRead)mnRead).getChecksum(this.session, systemMetadata.getIdentifier(), existingChecksum.getAlgorithm());
                        } else if (mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead) {
                            newChecksum = ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).getChecksum(this.session, systemMetadata.getIdentifier(), existingChecksum.getAlgorithm());
                        }
                    }
                    if (newChecksum.getValue().contentEquals(existingChecksum.getValue())) {
                        logger.info((Object)(this.task.taskLabel() + " Update sysMeta because checksum is same"));
                        this.updateSystemMetadata(systemMetadata);
                    } else {
                        logger.info((Object)(this.task.taskLabel() + " Update sysMeta Not Unique! Checksum is different"));
                        IdentifierNotUnique notUnique = new IdentifierNotUnique("-1", "Checksum does not match existing object with same pid.");
                        this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)notUnique);
                    }
                } else if (cnSystemMetadata == null) {
                    logger.error((Object)(this.task.taskLabel() + " cn's systemMetadata is null when get called from Hazelcast " + this.hzSystemMetaMapString + " Map"));
                } else {
                    logger.error((Object)(this.task.taskLabel() + " cn's systemMetadata's checksum is null when get called from Hazelcast " + this.hzSystemMetaMapString + " Map"));
                }
            }
        }
        catch (VersionMismatch ex) {
            logger.warn((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            throw ex;
        }
        catch (InvalidSystemMetadata ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (InvalidToken ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (NotFound ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (NotAuthorized ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (InvalidRequest ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (ServiceFailure ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (InsufficientResources ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (NotImplemented ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (UnsupportedType ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (IdentifierNotUnique ex) {
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error((Object)(this.task.taskLabel() + "\n" + ex.getMessage()));
            ServiceFailure serviceFailure = new ServiceFailure("-1", ex.getMessage());
            this.submitSynchronizationFailed(systemMetadata.getIdentifier().getValue(), (BaseException)serviceFailure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createObject(SystemMetadata systemMetadata) throws InvalidRequest, ServiceFailure, NotFound, InsufficientResources, NotImplemented, InvalidToken, NotAuthorized, InvalidSystemMetadata, IdentifierNotUnique, UnsupportedType {
        block14: {
            Identifier d1Identifier;
            block13: {
                d1Identifier = new Identifier();
                d1Identifier.setValue(systemMetadata.getIdentifier().getValue());
                systemMetadata.setDateSysMetadataModified(new Date());
                ObjectFormat objectFormat = this.nodeCommunications.getCnCore().getFormat(systemMetadata.getFormatId());
                this.validateSystemMetadata(systemMetadata);
                this.validateChecksum(systemMetadata);
                if (objectFormat == null || objectFormat.getFormatType().equalsIgnoreCase("DATA")) break block13;
                InputStream sciMetaStream = null;
                try {
                    int tryAgain = 0;
                    boolean needSciMetadata = true;
                    do {
                        try {
                            logger.debug((Object)(this.task.taskLabel() + " getting ScienceMetadata "));
                            Object mnRead = this.nodeCommunications.getMnRead();
                            if (mnRead instanceof MNRead) {
                                sciMetaStream = ((MNRead)mnRead).get(null, systemMetadata.getIdentifier());
                                needSciMetadata = false;
                                continue;
                            }
                            if (!(mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead)) continue;
                            sciMetaStream = ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).get(null, systemMetadata.getIdentifier());
                            needSciMetadata = false;
                        }
                        catch (NotAuthorized ex) {
                            if (tryAgain < 2) {
                                ++tryAgain;
                                logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException ex1) {
                                    logger.warn((Object)(this.task.taskLabel() + "\n" + (Object)((Object)ex)));
                                }
                                continue;
                            }
                            throw ex;
                        }
                        catch (ServiceFailure ex) {
                            if (tryAgain < 6) {
                                ++tryAgain;
                                logger.error((Object)(this.task.taskLabel() + "\n" + ex.serialize(0)));
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (InterruptedException ex1) {
                                    logger.warn((Object)(this.task.taskLabel() + "\n" + (Object)((Object)ex)));
                                }
                                continue;
                            }
                            throw ex;
                        }
                    } while (needSciMetadata);
                    logger.info((Object)(this.task.taskLabel() + " Creating Object"));
                    d1Identifier = this.nodeCommunications.getCnCore().create(null, d1Identifier, sciMetaStream, systemMetadata);
                    logger.info((Object)(this.task.taskLabel() + " Created Object"));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(sciMetaStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)sciMetaStream);
                break block14;
            }
            logger.info((Object)(this.task.taskLabel() + " Registering SystemMetadata"));
            this.nodeCommunications.getCnCore().registerSystemMetadata(null, d1Identifier, systemMetadata);
            logger.info((Object)(this.task.taskLabel() + " Registered SystemMetadata"));
        }
    }

    private void validateChecksum(SystemMetadata systemMetadata) throws InvalidSystemMetadata {
        if (systemMetadata.getSize().compareTo(CHECKSUM_VERIFICATION_SIZE_BYPASS_THRESHOLD) < 0) {
            Throwable checksumException = null;
            Checksum expectedChecksum = systemMetadata.getChecksum();
            Checksum actualChecksum = null;
            try {
                Object mnRead = this.nodeCommunications.getMnRead();
                if (mnRead instanceof MNRead) {
                    actualChecksum = ((MNRead)mnRead).getChecksum(this.session, systemMetadata.getIdentifier(), expectedChecksum.getAlgorithm());
                } else if (mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead) {
                    actualChecksum = ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).getChecksum(this.session, systemMetadata.getIdentifier(), expectedChecksum.getAlgorithm());
                }
            }
            catch (InvalidRequest e) {
                checksumException = e;
            }
            catch (InvalidToken e) {
                checksumException = e;
            }
            catch (NotAuthorized e) {
                checksumException = e;
            }
            catch (NotImplemented e) {
                checksumException = e;
            }
            catch (ServiceFailure e) {
                checksumException = e;
            }
            catch (NotFound e) {
                checksumException = e;
            }
            if (!ChecksumUtil.areChecksumsEqual((Checksum)expectedChecksum, actualChecksum) || checksumException != null) {
                String pid = "null";
                if (systemMetadata != null && systemMetadata.getIdentifier() != null && systemMetadata.getIdentifier().getValue() != null) {
                    pid = systemMetadata.getIdentifier().getValue();
                }
                String errorMessage = "The checksum for pid: " + pid + " does not match the actual checksum supplied by the member node: " + systemMetadata.getOriginMemberNode().getValue() + ".  Actual checksum: " + actualChecksum.getValue() + ". System metadata checksum: " + expectedChecksum.getValue();
                InvalidSystemMetadata be = new InvalidSystemMetadata("000", errorMessage);
                if (checksumException != null) {
                    be.initCause(checksumException);
                }
                logger.error((Object)(this.task.taskLabel() + ": " + errorMessage));
                throw be;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateResource(byte[] resourceBytes) throws UnsupportedType {
        boolean valid = false;
        if (resourceBytes == null) return valid;
        ByteArrayInputStream resourceStream = null;
        try {
            resourceStream = new ByteArrayInputStream(resourceBytes);
            ResourceMapFactory.getInstance().parseResourceMap((InputStream)resourceStream);
            valid = true;
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e.getMessage());
                catch (OREException e2) {
                    throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e2.getMessage());
                }
                catch (URISyntaxException e3) {
                    throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e3.getMessage());
                }
                catch (OREParserException e4) {
                    throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e4.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)resourceStream);
        return valid;
    }

    private boolean isResource(ObjectFormat format) {
        boolean isResource = false;
        if (format != null && format.getFormatType().equalsIgnoreCase("RESOURCE")) {
            isResource = true;
        }
        return isResource;
    }

    private void validateSystemMetadata(SystemMetadata sysmeta) throws InvalidSystemMetadata {
        Throwable caught = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            TypeMarshaller.marshalTypeToOutputStream((Object)sysmeta, (OutputStream)os);
            os.close();
        }
        catch (MarshallingException e) {
            caught = e;
        }
        catch (IOException e) {
            caught = e;
        }
        if (caught != null) {
            String pid = "null";
            if (sysmeta != null && sysmeta.getIdentifier() != null && sysmeta.getIdentifier().getValue() != null) {
                pid = sysmeta.getIdentifier().getValue();
            }
            String errorMessage = "The SystemMetadata for pid: " + pid + " is not schema valid";
            InvalidSystemMetadata be = new InvalidSystemMetadata("000", errorMessage);
            be.initCause(caught);
            logger.error((Object)errorMessage, (Throwable)be);
            throw be;
        }
    }

    private void updateSystemMetadata(SystemMetadata newSystemMetadata) throws InvalidSystemMetadata, NotFound, NotImplemented, NotAuthorized, ServiceFailure, InvalidRequest, InvalidToken, VersionMismatch {
        Identifier pid = new Identifier();
        pid.setValue(newSystemMetadata.getIdentifier().getValue());
        SystemMetadata cnSystemMetadata = (SystemMetadata)this.hzSystemMetaMap.get((Object)pid);
        if (this.task.getNodeId().contentEquals(cnSystemMetadata.getAuthoritativeMemberNode().getValue())) {
            boolean foundValidMNChange = false;
            if (cnSystemMetadata.getObsoletedBy() == null && newSystemMetadata.getObsoletedBy() != null) {
                logger.info((Object)(this.task.taskLabel() + " Updating ObsoletedBy..."));
                this.nodeCommunications.getCnCore().setObsoletedBy(this.session, pid, newSystemMetadata.getObsoletedBy(), cnSystemMetadata.getSerialVersion().longValue());
                logger.info((Object)(this.task.taskLabel() + " Updated ObsoletedBy"));
                foundValidMNChange = true;
            }
            if (newSystemMetadata.getArchived() != null && newSystemMetadata.getArchived().booleanValue() && (cnSystemMetadata.getArchived() == null || !cnSystemMetadata.getArchived().booleanValue())) {
                logger.info((Object)(this.task.taskLabel() + " Updating Archived..."));
                this.nodeCommunications.getCnCore().archive(this.session, pid);
                logger.info((Object)(this.task.taskLabel() + " Updated Archived"));
                foundValidMNChange = true;
            }
            if (foundValidMNChange) {
                this.auditReplicaSystemMetadata(pid);
            } else if (newSystemMetadata.getDateSysMetadataModified().after(cnSystemMetadata.getDateSysMetadataModified())) {
                InvalidRequest invalidRequest = new InvalidRequest("567123", "Synchronization unable to process the update request. Only archived and obsoletedBy may be updated");
                logger.error((Object)(this.task.taskLabel() + "\n" + invalidRequest.serialize(0)));
                this.submitSynchronizationFailed(pid.getValue(), (BaseException)invalidRequest);
                logger.warn((Object)(this.task.taskLabel() + " Ignoring update from MN. Only archived and obsoletedBy may be updated"));
            }
        } else {
            boolean performUpdate = true;
            List prevReplicaList = cnSystemMetadata.getReplicaList();
            for (Replica replica : prevReplicaList) {
                if (!this.task.getNodeId().equals(replica.getReplicaMemberNode().getValue())) continue;
                performUpdate = false;
                break;
            }
            if (performUpdate) {
                logger.info((Object)(this.task.taskLabel() + " Update Replica"));
                Replica mnReplica = new Replica();
                NodeReference nodeReference = new NodeReference();
                nodeReference.setValue(this.task.getNodeId());
                mnReplica.setReplicaMemberNode(nodeReference);
                mnReplica.setReplicationStatus(ReplicationStatus.COMPLETED);
                mnReplica.setReplicaVerified(new Date());
                this.nodeCommunications.getCnReplication().updateReplicationMetadata(this.session, pid, mnReplica, cnSystemMetadata.getSerialVersion().longValue());
                this.auditReplicaSystemMetadata(pid);
                logger.info((Object)(this.task.taskLabel() + " Updated Replica"));
            } else {
                InvalidRequest invalidRequest = new InvalidRequest("567123", "Not Authorized Node to perform Updates. Synchronization unable to process the update request. Only archived and obsoletedBy may be updated from Authorized Node");
                logger.error((Object)(this.task.taskLabel() + "\n" + invalidRequest.serialize(0)));
                this.submitSynchronizationFailed(pid.getValue(), (BaseException)invalidRequest);
                logger.warn((Object)(this.task.taskLabel() + " Ignoring update from Replica MN"));
            }
        }
    }

    private void auditReplicaSystemMetadata(Identifier pid) throws InvalidToken, ServiceFailure, NotAuthorized, NotFound, InvalidRequest, NotImplemented {
        SystemMetadata cnSystemMetadata = (SystemMetadata)this.hzSystemMetaMap.get((Object)pid);
        if (cnSystemMetadata != null) {
            List prevReplicaList = cnSystemMetadata.getReplicaList();
            Session session = null;
            logger.info((Object)(this.task.taskLabel() + " auditReplicaSystemMetadata"));
            for (Replica replica : prevReplicaList) {
                Node node = this.nodeCommunications.getNodeRegistryService().getNode(replica.getReplicaMemberNode());
                if (!node.getType().equals((Object)NodeType.MN)) continue;
                boolean isTier3 = false;
                for (Service service : node.getServices().getServiceList()) {
                    if (!service.getName().equals("MNStorage") || !service.getAvailable().booleanValue()) continue;
                    isTier3 = true;
                    break;
                }
                if (!isTier3) continue;
                NodeComm nodeComm = null;
                try {
                    SystemMetadata mnSystemMetadata;
                    nodeComm = NodeCommSyncObjectFactory.getInstance().getNodeComm(node.getIdentifier());
                    Object mNode = nodeComm.getMnRead();
                    if (mNode instanceof MNRead) {
                        mnSystemMetadata = ((MNRead)mNode).getSystemMetadata(session, cnSystemMetadata.getIdentifier());
                        if (mnSystemMetadata.getSerialVersion() == cnSystemMetadata.getSerialVersion()) continue;
                        ((MNRead)mNode).systemMetadataChanged(session, cnSystemMetadata.getIdentifier(), cnSystemMetadata.getSerialVersion().longValue(), cnSystemMetadata.getDateSysMetadataModified());
                        continue;
                    }
                    if (!(mNode instanceof MNode) || (mnSystemMetadata = ((MNode)mNode).getSystemMetadata(session, cnSystemMetadata.getIdentifier())).getSerialVersion() == cnSystemMetadata.getSerialVersion()) continue;
                    ((MNode)mNode).systemMetadataChanged(session, cnSystemMetadata.getIdentifier(), cnSystemMetadata.getSerialVersion().longValue(), cnSystemMetadata.getDateSysMetadataModified());
                }
                catch (NodeCommUnavailable e) {
                    throw new ServiceFailure("0000", e.getMessage());
                }
                finally {
                    if (nodeComm == null) continue;
                    nodeComm.setState(NodeCommState.AVAILABLE);
                }
            }
        } else {
            logger.error((Object)(this.task.taskLabel() + " is null when get called from Hazelcast " + this.hzSystemMetaMapString + " Map"));
        }
    }

    private void submitSynchronizationFailed(String pid, BaseException exception) {
        SyncFailedTask syncFailedTask = new SyncFailedTask(this.nodeCommunications, this.task);
        syncFailedTask.submitSynchronizationFailed(pid, null, exception);
    }
}

