/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.log4j.Logger;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.v1.types.D1TypeBuilder;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.batch.exceptions.NodeCommUnavailable;
import org.dataone.cn.batch.exceptions.RetryableException;
import org.dataone.cn.batch.exceptions.UnrecoverableException;
import org.dataone.cn.batch.service.v2.IdentifierReservationQueryService;
import org.dataone.cn.batch.synchronization.D1TypeUtils;
import org.dataone.cn.batch.synchronization.NodeCommSyncObjectFactory;
import org.dataone.cn.batch.synchronization.tasks.SyncFailedTask;
import org.dataone.cn.batch.synchronization.type.NodeComm;
import org.dataone.cn.batch.synchronization.type.NodeCommState;
import org.dataone.cn.batch.synchronization.type.SyncObjectState;
import org.dataone.cn.batch.synchronization.type.SystemMetadataValidator;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.synchronization.types.SyncObject;
import org.dataone.configuration.Settings;
import org.dataone.ore.ResourceMapFactory;
import org.dataone.service.cn.v2.CNRead;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InsufficientResources;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.exceptions.SynchronizationFailed;
import org.dataone.service.exceptions.UnsupportedType;
import org.dataone.service.exceptions.VersionMismatch;
import org.dataone.service.mn.tier1.v2.MNRead;
import org.dataone.service.types.v1.Checksum;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectFormatIdentifier;
import org.dataone.service.types.v1.ObjectLocationList;
import org.dataone.service.types.v1.Permission;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v1.ReplicationStatus;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.util.ChecksumUtil;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.types.v2.TypeFactory;
import org.dataone.service.types.v2.util.AuthUtils;
import org.dspace.foresite.OREException;
import org.dspace.foresite.OREParserException;

public class V2TransferObjectTask
implements Callable<SyncObjectState> {
    private static final BigInteger CHECKSUM_VERIFICATION_SIZE_BYPASS_THRESHOLD = Settings.getConfiguration().getBigInteger("Synchronization.checksum.verify.size.bypass.threshold", BigInteger.valueOf(10000000L));
    private static final String[] VALIDATING_RESOURCE_FORMATS = new String[]{"http://www.openarchives.org/ore/terms"};
    static final Logger logger = Logger.getLogger(V2TransferObjectTask.class);
    private NodeComm nodeCommunications;
    private SyncObject task;
    private Session session = null;
    private HazelcastClient hzProcessingClient = HazelcastClientFactory.getProcessingClient();
    private HazelcastClient hzStorageClient = HazelcastClientFactory.getStorageClient();
    String cnIdentifier = Settings.getConfiguration().getString("cn.router.nodeId");
    String synchronizationObjectQueue = Settings.getConfiguration().getString("dataone.hazelcast.synchronizationObjectQueue");
    String hzSystemMetaMapString = Settings.getConfiguration().getString("dataone.hazelcast.systemMetadata");
    IMap<Identifier, SystemMetadata> hzSystemMetaMap;
    IdentifierReservationQueryService identifierReservationService;

    public V2TransferObjectTask(NodeComm nodeCommunications, SyncObject task) {
        this.nodeCommunications = nodeCommunications;
        this.task = task;
        this.hzSystemMetaMap = this.hzStorageClient.getMap(this.hzSystemMetaMapString);
        this.identifierReservationService = nodeCommunications.getReserveIdentifierService();
    }

    V2TransferObjectTask(NodeComm nodeCommunications, SyncObject task, Session clientSession) {
        this.nodeCommunications = nodeCommunications;
        this.task = task;
        this.hzSystemMetaMap = this.hzStorageClient.getMap(this.hzSystemMetaMapString);
        this.identifierReservationService = nodeCommunications.getReserveIdentifierService();
        this.session = clientSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncObjectState call() {
        SyncObjectState callState;
        block24: {
            callState = SyncObjectState.STARTED;
            long remainingSleep = this.task.getSleepUntil() - System.currentTimeMillis();
            if (remainingSleep > 0L) {
                try {
                    Thread.sleep(remainingSleep);
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)this.buildStandardLogMessage(null, " Interrupted task-remaining-sleep"));
                }
            }
            ILock hzPidLock = this.hzProcessingClient.getLock((Object)this.task.getPid());
            try {
                logger.info((Object)this.buildStandardLogMessage(null, " Locking task, attempt " + this.task.getLockAttempt()));
                if (hzPidLock.tryLock(1L, TimeUnit.SECONDS)) {
                    try {
                        logger.info((Object)this.buildStandardLogMessage(null, " Processing SyncObject"));
                        SystemMetadata mnSystemMetadata = this.retrieveMNSystemMetadata();
                        logger.debug((Object)(this.task.taskLabel() + " MN system metadata retrieved..."));
                        this.processTask(mnSystemMetadata);
                        callState = SyncObjectState.SUCCESS;
                        break block24;
                    }
                    catch (RetryableException ex) {
                        if (this.task.getAttempt() < 20) {
                            callState = SyncObjectState.RETRY;
                            logger.warn((Object)this.buildStandardLogMessage(ex, " RetryableException raised on attempt " + this.task.getAttempt() + " of 20.  Sleeping and requeueing."));
                            this.task.setAttempt(Integer.valueOf(this.task.getAttempt() + 1));
                            this.task.setSleepUntil(System.currentTimeMillis() + 5000L);
                            this.hzProcessingClient.getQueue(this.synchronizationObjectQueue).put((Object)this.task);
                            break block24;
                        }
                        logger.error((Object)this.buildStandardLogMessage(ex, " Exceeded retry limit. Unable to process the SyncObject. Converting to UnrecoverableException"), (Throwable)ex);
                        throw new UnrecoverableException(this.task.getPid() + ": retry limits reached without success.", ex.getCause());
                    }
                    finally {
                        hzPidLock.unlock();
                        logger.info((Object)this.buildStandardLogMessage(null, " Unlocked Pid."));
                    }
                }
                if (this.task.getLockAttempt() < 100) {
                    callState = SyncObjectState.RETRY;
                    logger.warn((Object)this.buildStandardLogMessage(null, " Cannot lock Pid! Requeueing the task. Attempt " + this.task.getLockAttempt()));
                    this.task.setLockAttempt(Integer.valueOf(this.task.getLockAttempt() + 1));
                    this.task.setSleepUntil(System.currentTimeMillis() + 1000L);
                    this.hzProcessingClient.getQueue(this.synchronizationObjectQueue).put((Object)this.task);
                    break block24;
                }
                callState = SyncObjectState.FAILED;
                String message = "Cannot lock Pid! Reached Max attempts (100), abandoning processing of this pid.";
                logger.error((Object)this.buildStandardLogMessage(null, message));
                throw new SynchronizationFailed("5000", message);
            }
            catch (SynchronizationFailed e) {
                callState = SyncObjectState.FAILED;
                logger.error((Object)this.buildStandardLogMessage(e.getCause(), "SynchronizationFailed: " + e.getMessage()), (Throwable)e);
                SyncFailedTask syncFailedTask = new SyncFailedTask(this.nodeCommunications, this.task);
                syncFailedTask.submitSynchronizationFailed(e);
            }
            catch (UnrecoverableException e) {
                callState = SyncObjectState.FAILED;
                logger.error((Object)this.buildStandardLogMessage(e.getCause(), "UnrecoverableException: " + e.getMessage()), (Throwable)e);
                SyncFailedTask syncFailedTask = new SyncFailedTask(this.nodeCommunications, this.task);
                if (e.getCause() instanceof BaseException) {
                    syncFailedTask.submitSynchronizationFailed(this.task.getPid(), null, (BaseException)e.getCause());
                } else {
                    syncFailedTask.submitSynchronizationFailed(this.task.getPid(), null, (BaseException)new ServiceFailure("5000", this.buildStandardLogMessage(e.getCause(), null)));
                }
            }
            catch (InterruptedException e) {
                callState = SyncObjectState.FAILED;
                logger.error((Object)this.buildStandardLogMessage(e, "Interrupted: " + e.getMessage()), (Throwable)e);
            }
            catch (Exception e) {
                callState = SyncObjectState.FAILED;
                logger.error((Object)this.buildStandardLogMessage(e, e.getMessage()), (Throwable)e);
            }
            finally {
                logger.info((Object)this.buildStandardLogMessage(null, " exiting with callState: " + (Object)((Object)callState)));
            }
        }
        return callState;
    }

    private SystemMetadata retrieveMNSystemMetadata() throws SynchronizationFailed, RetryableException {
        SystemMetadata systemMetadata = null;
        try {
            systemMetadata = this.getSystemMetadataHandleRetry(this.nodeCommunications.getMnRead(), D1TypeBuilder.buildIdentifier((String)this.task.getPid()));
            logger.info((Object)this.buildStandardLogMessage(null, " Retrieved SystemMetadata Identifier:" + systemMetadata.getIdentifier().getValue() + " from node " + this.task.getNodeId() + " for ObjectInfo Identifier " + this.task.getPid()));
            if (!systemMetadata.getIdentifier().getValue().contentEquals(this.task.getPid())) {
                throw new InvalidSystemMetadata("567100", String.format("Identifier in the retrieved SystemMetadata (%s) is different from the identifier used to retrieve the SystemMetadata (%s).)", this.task.getPid(), systemMetadata.getIdentifier().getValue()));
            }
        }
        catch (BaseException ex) {
            logger.error((Object)this.buildStandardLogMessage(ex, ex.getDescription()), (Throwable)ex);
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), null, (Exception)((Object)ex));
        }
        return systemMetadata;
    }

    private SystemMetadata getSystemMetadataHandleRetry(Object readImpl, Identifier id) throws ServiceFailure, InvalidToken, NotImplemented, NotFound, RetryableException {
        SystemMetadata retrievedSysMeta;
        block8: {
            retrievedSysMeta = null;
            try {
                if (readImpl instanceof MNRead) {
                    retrievedSysMeta = ((MNRead)readImpl).getSystemMetadata(this.session, id);
                    break block8;
                }
                if (readImpl instanceof CNRead) {
                    retrievedSysMeta = ((CNRead)readImpl).getSystemMetadata(this.session, id);
                    break block8;
                }
                if (!(readImpl instanceof org.dataone.service.mn.tier1.v1.MNRead)) break block8;
                org.dataone.service.types.v1.SystemMetadata oldSystemMetadata = ((org.dataone.service.mn.tier1.v1.MNRead)readImpl).getSystemMetadata(this.session, id);
                try {
                    retrievedSysMeta = (SystemMetadata)TypeFactory.convertTypeFromType((Object)oldSystemMetadata, SystemMetadata.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ServiceFailure("-1:conversionError", "Error converting v1.SystemMetadata to v2.SystemMetadata: " + e.getMessage());
                }
            }
            catch (NotAuthorized ex) {
                throw new RetryableException("in getSystemMetadata, got NotAuthorized: " + ex.getDescription(), ex);
            }
            catch (ServiceFailure ex) {
                if (ex.getDetail_code() != null && ex.getDetail_code().equals("-1:conversionError")) {
                    throw ex;
                }
                throw new RetryableException("in getSystemMetadata, got ServiceFailure: " + ex.getDescription(), ex);
            }
        }
        return retrievedSysMeta;
    }

    private void processTask(SystemMetadata mnSystemMetadata) throws SynchronizationFailed, UnrecoverableException, RetryableException {
        logger.debug((Object)(this.task.taskLabel() + " entering processTask..."));
        try {
            if (mnSystemMetadata == null) {
                throw new UnrecoverableException(this.task.getPid() + "the retrieved SystemMetadata passed into processTask was null!");
            }
            if (this.resolvable(mnSystemMetadata.getIdentifier(), "PID")) {
                this.processUpdates(mnSystemMetadata);
            } else {
                this.processNewObject(mnSystemMetadata);
            }
        }
        catch (RetryableException ex) {
            logger.warn((Object)this.buildStandardLogMessage(ex, "RetryableException "));
            throw ex;
        }
    }

    private void processNewObject(SystemMetadata mnSystemMetadata) throws SynchronizationFailed, RetryableException, UnrecoverableException {
        logger.debug((Object)(this.task.taskLabel() + " entering processNewObject..."));
        try {
            this.validateSeriesId(mnSystemMetadata, null);
        }
        catch (NotAuthorized e) {
            logger.error((Object)this.buildStandardLogMessage(e, "NotAuthorized to claim the seriesId"), (Throwable)e);
            throw SyncFailedTask.createSynchronizationFailed(mnSystemMetadata.getIdentifier().getValue(), "NotAuthorized to claim the seriesId", (Exception)((Object)e));
        }
        try {
            Session verifySubmitter = new Session();
            verifySubmitter.setSubject(mnSystemMetadata.getSubmitter());
            this.identifierReservationService.hasReservation(verifySubmitter, mnSystemMetadata.getSubmitter(), mnSystemMetadata.getIdentifier());
            logger.debug((Object)(this.task.taskLabel() + " Pid is reserved by this object's submitter."));
        }
        catch (NotFound e) {
            logger.debug((Object)(this.task.taskLabel() + " Pid is not reserved by anyone."));
        }
        catch (InvalidRequest | NotAuthorized e) {
            throw new UnrecoverableException(this.task.getPid() + " - from hasReservation", e);
        }
        catch (ServiceFailure e) {
            V2TransferObjectTask.extractRetryableException(e);
            throw new UnrecoverableException(this.task.getPid() + " - from hasReservation", e);
        }
        mnSystemMetadata = this.populateInitialReplicaList(mnSystemMetadata);
        mnSystemMetadata.setSerialVersion(BigInteger.ONE);
        try {
            SystemMetadataValidator.validateCNRequiredNonNullFields(mnSystemMetadata);
            this.createObject(mnSystemMetadata);
        }
        catch (InvalidSystemMetadata e) {
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), null, (Exception)((Object)e));
        }
    }

    private SystemMetadata populateInitialReplicaList(SystemMetadata systemMetadata) throws SynchronizationFailed, RetryableException, UnrecoverableException {
        try {
            logger.debug((Object)(this.task.taskLabel() + " entering populateInitialReplicaList"));
            ArrayList replicaList = new ArrayList();
            systemMetadata.setReplicaList(replicaList);
            Replica originalReplica = new Replica();
            NodeReference originalReplicaReference = new NodeReference();
            originalReplicaReference.setValue(this.task.getNodeId());
            originalReplica.setReplicaMemberNode(originalReplicaReference);
            originalReplica.setReplicationStatus(ReplicationStatus.COMPLETED);
            originalReplica.setReplicaVerified(new Date());
            systemMetadata.addReplica(originalReplica);
            logger.debug((Object)(this.task.taskLabel() + " Included replica for original MN"));
            logger.debug((Object)(this.task.taskLabel() + " Get Object Format"));
            ObjectFormat objectFormat = this.nodeCommunications.getCnCore().getFormat(systemMetadata.getFormatId());
            if (objectFormat != null && !objectFormat.getFormatType().equalsIgnoreCase("DATA")) {
                NodeReference cnReference = new NodeReference();
                cnReference.setValue(this.cnIdentifier);
                Replica cnReplica = new Replica();
                cnReplica.setReplicaMemberNode(cnReference);
                cnReplica.setReplicationStatus(ReplicationStatus.COMPLETED);
                cnReplica.setReplicaVerified(new Date());
                systemMetadata.addReplica(cnReplica);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.task.taskLabel() + " Added CN as replica because formatType " + objectFormat.getFormatType() + " is not DATA"));
                }
            }
        }
        catch (ServiceFailure ex) {
            logger.error((Object)this.buildStandardLogMessage(ex, "serviceFailure while finding format:" + ex.getDescription()), (Throwable)ex);
            V2TransferObjectTask.extractRetryableException(ex);
            throw new UnrecoverableException(this.task.getPid() + " - from cn.getFormat", ex);
        }
        catch (NotFound ex) {
            logger.error((Object)this.buildStandardLogMessage(ex, "format NotFound: " + ex.getDescription()), (Throwable)ex);
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "cn.Core could not find the format", (Exception)((Object)ex));
        }
        catch (NotImplemented ex) {
            logger.error((Object)this.buildStandardLogMessage(ex, ex.getDescription()), (Throwable)ex);
            throw new UnrecoverableException(this.task.getPid() + " - Unexpectedly, cn.getFormat returned NotImplemented!!", ex);
        }
        catch (Exception ex) {
            logger.error((Object)this.buildStandardLogMessage(ex, ex.getMessage()), (Throwable)ex);
            throw new UnrecoverableException(this.task.getPid() + " - from cn.getFormat", ex);
        }
        return systemMetadata;
    }

    private void validateSeriesId(SystemMetadata sysMeta, SystemMetadata previousSysMeta) throws NotAuthorized, UnrecoverableException, RetryableException {
        block19: {
            Identifier prevSid;
            logger.debug((Object)(this.task.taskLabel() + " entering validateSeriesId..."));
            Identifier sid = sysMeta.getSeriesId();
            Identifier identifier = prevSid = previousSysMeta == null ? null : previousSysMeta.getSeriesId();
            if (D1TypeUtils.emptyEquals(sid, prevSid)) {
                return;
            }
            if (D1TypeUtils.emptyEquals(sid, null)) {
                return;
            }
            try {
                Identifier headPid = this.resolve(sid, "SID");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.task.taskLabel() + " SeriesId is in use by " + headPid.getValue()));
                }
                SystemMetadata sidHeadSysMeta = (SystemMetadata)this.hzSystemMetaMap.get((Object)headPid);
                if (sysMeta == null || sidHeadSysMeta == null) break block19;
                if (sysMeta.getAuthoritativeMemberNode() != null && sidHeadSysMeta.getAuthoritativeMemberNode() != null && D1TypeUtils.equals(sysMeta.getAuthoritativeMemberNode(), sidHeadSysMeta.getAuthoritativeMemberNode())) {
                    return;
                }
                if (sysMeta.getRightsHolder() != null && sidHeadSysMeta.getRightsHolder() != null && D1TypeUtils.equals(sysMeta.getRightsHolder(), sidHeadSysMeta.getRightsHolder())) {
                    return;
                }
                if (sysMeta.getSubmitter() != null && sidHeadSysMeta.getSubmitter() != null && D1TypeUtils.equals(sysMeta.getSubmitter(), sidHeadSysMeta.getSubmitter())) {
                    return;
                }
                CNode cn = D1Client.getCN();
                SubjectInfo submitterInfo = cn.getSubjectInfo(null, sysMeta.getSubmitter());
                HashSet submitterAllSubjects = new HashSet();
                AuthUtils.findPersonsSubjects(submitterAllSubjects, (SubjectInfo)submitterInfo, (Subject)sysMeta.getSubmitter());
                if (AuthUtils.isAuthorized(submitterAllSubjects, (Permission)Permission.CHANGE_PERMISSION, (org.dataone.service.types.v1.SystemMetadata)sidHeadSysMeta)) break block19;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Submitter doesn't have the change permission on the pid " + headPid.getValue() + ". We will try if the rights holder has the permission."));
                }
                if (!sysMeta.getSubmitter().equals((Object)sysMeta.getRightsHolder())) {
                    SubjectInfo rightsHolderInfo = cn.getSubjectInfo(null, sysMeta.getRightsHolder());
                    Set<Subject> rightsHolderAllSubjects = V2TransferObjectTask.findEquivalentSubjects(rightsHolderInfo, sysMeta.getRightsHolder());
                    if (!AuthUtils.isAuthorized(rightsHolderAllSubjects, (Permission)Permission.CHANGE_PERMISSION, (org.dataone.service.types.v1.SystemMetadata)sidHeadSysMeta)) {
                        throw new NotAuthorized("0000", "Neither the submitter nor rightsHolder have CHANGE rights on the SeriesId as determined by the current head of the Sid collection, whose pid is: " + headPid.getValue());
                    }
                    break block19;
                }
                throw new NotAuthorized("0000", "Neither the submitter nor rightsHolder have CHANGE rights on the SeriesId as determined by the current head of the Sid collection, whose pid is: " + headPid.getValue());
            }
            catch (ServiceFailure e) {
                V2TransferObjectTask.extractRetryableException(e);
                String message = " couldn't access the CN /meta endpoint to check seriesId!! Reason: " + e.getDescription();
                logger.error((Object)this.buildStandardLogMessage(e, message), (Throwable)e);
                throw new UnrecoverableException(message, e);
            }
            catch (InvalidToken | NotImplemented e) {
                String message = " couldn't access the CN /meta endpoint to check seriesId!! Reason: " + e.getDescription();
                logger.error((Object)this.buildStandardLogMessage(e, message), e);
                throw new UnrecoverableException(message, e);
            }
            catch (NotFound e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this.task.taskLabel() + String.format(" SeriesId (%s) doesn't exist for any object on the CN, checking reservation service...", sid.getValue())));
                }
                try {
                    Session verifySubmitter = new Session();
                    verifySubmitter.setSubject(sysMeta.getSubmitter());
                    if (!this.identifierReservationService.hasReservation(verifySubmitter, sysMeta.getSubmitter(), sid)) {
                        throw new NotAuthorized("0000", "someone else (other than submitter) holds the reservation on the seriesId! " + sid.getValue());
                    }
                    logger.debug((Object)(this.task.taskLabel() + " OK. SeriesId is reserved by this object's submitter or equivalent ID"));
                    return;
                }
                catch (NotFound e1) {
                    logger.debug((Object)(this.task.taskLabel() + " OK. SeriesId is not reserved."));
                }
                catch (InvalidRequest e1) {
                    String message = " Identifier Reservation Service threw unexpected InvalidRequest!! Reason: " + e1.getDescription();
                    logger.error((Object)this.buildStandardLogMessage(e, message), (Throwable)e1);
                    throw new UnrecoverableException(message, e1);
                }
                catch (ServiceFailure e1) {
                    V2TransferObjectTask.extractRetryableException(e1);
                    String message = " Identifier Reservation Service threw unexpected ServiceFailure!! Reason: " + e1.getDescription();
                    logger.error((Object)this.buildStandardLogMessage(e, message), (Throwable)e1);
                    throw new UnrecoverableException(message, e1);
                }
            }
        }
    }

    private static Set<Subject> findEquivalentSubjects(SubjectInfo subjectInfo, Subject targetSubject) {
        HashSet<Subject> subjects = new HashSet<Subject>();
        AuthUtils.findPersonsSubjects(subjects, (SubjectInfo)subjectInfo, (Subject)targetSubject);
        if (subjects.isEmpty() || subjects.size() == 1) {
            V2TransferObjectTask.findEquivalentSubjectsForGroup(subjects, subjectInfo, targetSubject);
        }
        return subjects;
    }

    private static void findEquivalentSubjectsForGroup(Set<Subject> foundSubjects, SubjectInfo subjectInfo, Subject targetGroupSubject) {
        if (targetGroupSubject != null && targetGroupSubject.getValue() != null && !targetGroupSubject.getValue().trim().equals("")) {
            foundSubjects.add(targetGroupSubject);
            List groupList = null;
            if (subjectInfo != null && (groupList = subjectInfo.getGroupList()) != null) {
                for (Group group : groupList) {
                    if (group == null || group.getHasMemberList() == null || group.getSubject() == null) continue;
                    for (Subject subject : group.getHasMemberList()) {
                        if (subject.getValue() == null || !subject.getValue().equals(targetGroupSubject.getValue())) continue;
                        if (foundSubjects.contains(group.getSubject())) {
                            return;
                        }
                        foundSubjects.add(group.getSubject());
                        V2TransferObjectTask.findEquivalentSubjectsForGroup(foundSubjects, subjectInfo, group.getSubject());
                    }
                }
            }
        }
    }

    private boolean resolvable(Identifier id, String field) throws UnrecoverableException, RetryableException {
        try {
            this.resolve(id, field);
            return true;
        }
        catch (NotFound e) {
            return false;
        }
    }

    private Identifier resolve(Identifier id, String field) throws NotFound, UnrecoverableException, RetryableException {
        logger.debug((Object)(this.task.taskLabel() + " entering resolve..."));
        try {
            ObjectLocationList oll = ((CNRead)this.nodeCommunications.getCnRead()).resolve(this.session, id);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.task.taskLabel() + String.format(" %s %s exists on the CN.", field, id.getValue())));
            }
            return oll.getIdentifier();
        }
        catch (NotFound ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.task.taskLabel() + String.format(" %s %s does not exist on the CN.", field, id.getValue())));
            }
            throw ex;
        }
        catch (ServiceFailure e) {
            V2TransferObjectTask.extractRetryableException(e);
            throw new UnrecoverableException("Unexpected Exception from CN /resolve !" + e.getDescription(), e);
        }
        catch (InvalidToken | NotAuthorized | NotImplemented e) {
            throw new UnrecoverableException("Unexpected Exception from CN /resolve ! " + e.getDescription(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createObject(SystemMetadata systemMetadata) throws RetryableException, UnrecoverableException, SynchronizationFailed {
        logger.info((Object)this.buildStandardLogMessage(null, "Start CreateObject"));
        Identifier d1Identifier = new Identifier();
        d1Identifier.setValue(systemMetadata.getIdentifier().getValue());
        try {
            block13: {
                block12: {
                    ObjectFormat objectFormat = this.nodeCommunications.getCnCore().getFormat(systemMetadata.getFormatId());
                    SystemMetadataValidator.schemaValidateSystemMetadata(systemMetadata);
                    this.validateChecksum(systemMetadata);
                    if (objectFormat == null || objectFormat.getFormatType().equalsIgnoreCase("DATA")) break block12;
                    InputStream sciMetaStream = null;
                    try {
                        int tryAgain = 0;
                        boolean needSciMetadata = true;
                        do {
                            try {
                                logger.debug((Object)(this.task.taskLabel() + " getting ScienceMetadata "));
                                Object mnRead = this.nodeCommunications.getMnRead();
                                if (mnRead instanceof MNRead) {
                                    sciMetaStream = ((MNRead)mnRead).get(this.session, systemMetadata.getIdentifier());
                                    needSciMetadata = false;
                                    continue;
                                }
                                if (!(mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead)) continue;
                                sciMetaStream = ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).get(this.session, systemMetadata.getIdentifier());
                                needSciMetadata = false;
                            }
                            catch (NotAuthorized ex) {
                                if (tryAgain < 2) {
                                    ++tryAgain;
                                    logger.error((Object)this.buildStandardLogMessage(ex, " Got NotAuthorized on MNRead.get(), retrying..."));
                                    continue;
                                }
                                throw ex;
                            }
                            catch (ServiceFailure ex) {
                                if (tryAgain < 6) {
                                    ++tryAgain;
                                    logger.error((Object)this.buildStandardLogMessage(ex, "Got ServiceFailure on MNRead.get(), retrying..."));
                                    continue;
                                }
                                throw ex;
                            }
                        } while (needSciMetadata);
                        logger.debug((Object)(this.task.taskLabel() + " Calling CNCreate..."));
                        d1Identifier = this.nodeCommunications.getCnCore().create(this.session, d1Identifier, sciMetaStream, systemMetadata);
                        logger.debug((Object)(this.task.taskLabel() + " ... CNCreate finished"));
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(sciMetaStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)sciMetaStream);
                    break block13;
                }
                logger.debug((Object)(this.task.taskLabel() + " Registering SystemMetadata..."));
                this.nodeCommunications.getCnCore().registerSystemMetadata(this.session, d1Identifier, systemMetadata);
                logger.debug((Object)(this.task.taskLabel() + " ... Registered SystemMetadata"));
            }
            logger.info((Object)this.buildStandardLogMessage(null, "Completed CreateObject"));
        }
        catch (ServiceFailure e) {
            V2TransferObjectTask.extractRetryableException(e);
            throw new UnrecoverableException(this.task.getPid() + " cn.createObject failed", e);
        }
        catch (BaseException e) {
            throw new UnrecoverableException(this.task.getPid() + " cn.createObject failed: " + e.getDescription(), e);
        }
    }

    private void validateChecksum(SystemMetadata systemMetadata) throws InvalidSystemMetadata {
        logger.debug((Object)(this.task.taskLabel() + " entering validateChecksum..."));
        if (systemMetadata.getSize().compareTo(CHECKSUM_VERIFICATION_SIZE_BYPASS_THRESHOLD) > 0) {
            return;
        }
        Throwable checksumException = null;
        Checksum expectedChecksum = systemMetadata.getChecksum();
        Checksum actualChecksum = null;
        try {
            Object mnRead = this.nodeCommunications.getMnRead();
            if (mnRead instanceof MNRead) {
                actualChecksum = ((MNRead)mnRead).getChecksum(this.session, systemMetadata.getIdentifier(), expectedChecksum.getAlgorithm());
            } else if (mnRead instanceof org.dataone.service.mn.tier1.v1.MNRead) {
                actualChecksum = ((org.dataone.service.mn.tier1.v1.MNRead)mnRead).getChecksum(this.session, systemMetadata.getIdentifier(), expectedChecksum.getAlgorithm());
            }
        }
        catch (InvalidRequest e) {
            checksumException = e;
        }
        catch (InvalidToken e) {
            checksumException = e;
        }
        catch (NotAuthorized e) {
            checksumException = e;
        }
        catch (NotImplemented e) {
            checksumException = e;
        }
        catch (ServiceFailure e) {
            checksumException = e;
        }
        catch (NotFound e) {
            checksumException = e;
        }
        if (!ChecksumUtil.areChecksumsEqual((Checksum)expectedChecksum, actualChecksum) || checksumException != null) {
            String pid = "null";
            if (!D1TypeUtils.valueEquals(systemMetadata.getIdentifier(), null)) {
                pid = systemMetadata.getIdentifier().getValue();
            }
            String actualChecksumValue = actualChecksum != null ? actualChecksum.getValue() : null;
            String expectedChecksumValue = expectedChecksum != null ? expectedChecksum.getValue() : null;
            String errorMessage = "The checksum for pid: " + pid + " does not match the actual checksum supplied by the member node: " + this.task.getNodeId() + ".  Actual checksum: " + actualChecksumValue + ". System metadata checksum: " + expectedChecksumValue;
            InvalidSystemMetadata be = new InvalidSystemMetadata("000", errorMessage);
            if (checksumException != null) {
                be.initCause(checksumException);
            }
            logger.error((Object)this.buildStandardLogMessage(null, errorMessage));
            throw be;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateResourceMap(ObjectFormat format, InputStream sciMetaStream) throws UnsupportedType, InsufficientResources {
        logger.debug((Object)(this.task.taskLabel() + " entering validateResourceMap..."));
        boolean attemptValidation = false;
        if (format != null && format.getFormatType().equalsIgnoreCase("RESOURCE")) {
            for (int i = 0; i < VALIDATING_RESOURCE_FORMATS.length; ++i) {
                if (!format.getFormatId().getValue().contentEquals(VALIDATING_RESOURCE_FORMATS[i])) continue;
                attemptValidation = true;
            }
        }
        if (!attemptValidation) return;
        byte[] resourceBytes = null;
        try {
            resourceBytes = IOUtils.toByteArray((InputStream)sciMetaStream);
        }
        catch (IOException e) {
            throw new InsufficientResources("413", "Could not validate Resource Map: Unable to create ByteArrayInputStream for pid: " + this.task.getPid() + " with message: " + e.getMessage());
        }
        finally {
            IOUtils.closeQuietly((InputStream)sciMetaStream);
        }
        if (resourceBytes == null) {
            throw new UnsupportedType("Invalid Resource Map", "input byte[] was null");
        }
        sciMetaStream = new ByteArrayInputStream(resourceBytes);
        ByteArrayInputStream resourceStream = null;
        try {
            resourceStream = new ByteArrayInputStream(resourceBytes);
            ResourceMapFactory.getInstance().parseResourceMap((InputStream)resourceStream);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e.getMessage());
                catch (OREException e2) {
                    throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e2.getMessage());
                }
                catch (URISyntaxException e3) {
                    throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e3.getMessage());
                }
                catch (OREParserException e4) {
                    throw new UnsupportedType("Invalid Resource Map", "Unable to parse document as a resource map: " + e4.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resourceStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)resourceStream);
    }

    private void processUpdates(SystemMetadata newSystemMetadata) throws RetryableException, UnrecoverableException, SynchronizationFailed {
        logger.debug((Object)(this.task.taskLabel() + " entering processUpdates..."));
        Identifier pid = D1TypeBuilder.cloneIdentifier((Identifier)newSystemMetadata.getIdentifier());
        logger.info((Object)this.buildStandardLogMessage(null, "Start ProcessUpdate"));
        logger.debug((Object)(this.task.taskLabel() + " Getting sysMeta from HazelCast map"));
        SystemMetadata hzSystemMetadata = (SystemMetadata)this.hzSystemMetaMap.get((Object)pid);
        SystemMetadataValidator validator = null;
        String errorTracker = "";
        try {
            errorTracker = "validateSysMeta";
            validator = new SystemMetadataValidator(hzSystemMetadata);
            validator.validateEssentialProperties(newSystemMetadata, this.nodeCommunications.getMnRead());
            NodeList nl = this.nodeCommunications.getNodeRegistryService().listNodes();
            boolean isV1Object = AuthUtils.isCNAuthorityForSystemMetadataUpdate((NodeList)nl, (SystemMetadata)newSystemMetadata);
            errorTracker = "processUpdate";
            if (this.task.getNodeId().contentEquals(hzSystemMetadata.getAuthoritativeMemberNode().getValue())) {
                if (isV1Object) {
                    this.processV1AuthoritativeUpdate(newSystemMetadata, hzSystemMetadata);
                } else {
                    this.validateSeriesId(newSystemMetadata, hzSystemMetadata);
                    this.processV2AuthoritativeUpdate(newSystemMetadata, validator);
                }
            } else {
                this.processPossibleNewReplica(newSystemMetadata, hzSystemMetadata, isV1Object);
            }
            logger.info((Object)this.buildStandardLogMessage(null, " Completed ProcessUpdate"));
        }
        catch (InvalidSystemMetadata e) {
            if (validator == null) {
                throw new UnrecoverableException("In processUpdates, bad SystemMetadata from the HzMap", e);
            }
            throw new UnrecoverableException("In processUpdates, could not find authoritativeMN in the NodeList", e);
        }
        catch (NotAuthorized e) {
            if (errorTracker.equals("validateSysMeta")) {
                throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "In processUpdates, while validating the checksum", (Exception)((Object)e));
            }
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "NotAuthorized to use the seriesId. ", (Exception)((Object)e));
        }
        catch (IdentifierNotUnique | InvalidRequest | InvalidToken | NotFound e) {
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "In processUpdates, while validating the checksum", (Exception)e);
        }
        catch (ServiceFailure e) {
            V2TransferObjectTask.extractRetryableException(e);
            throw new UnrecoverableException("In processUpdates, while validating the checksum:, e");
        }
        catch (NotImplemented e) {
            throw new UnrecoverableException("In processUpdates, while validating the checksum:, e");
        }
    }

    private void processPossibleNewReplica(SystemMetadata newSystemMetadata, SystemMetadata hzSystemMetadata, boolean isV1Object) throws RetryableException, UnrecoverableException {
        logger.debug((Object)(this.task.taskLabel() + " entering processPossibleNewReplica..."));
        for (Replica replica : hzSystemMetadata.getReplicaList()) {
            if (!this.task.getNodeId().equals(replica.getReplicaMemberNode().getValue())) continue;
            logger.debug((Object)(this.task.taskLabel() + " Non-authoritative source, existing replica.  No action needed"));
            return;
        }
        Replica mnReplica = new Replica();
        mnReplica.setReplicaMemberNode(D1TypeBuilder.buildNodeReference((String)this.task.getNodeId()));
        mnReplica.setReplicationStatus(ReplicationStatus.COMPLETED);
        mnReplica.setReplicaVerified(new Date());
        logger.info((Object)this.buildStandardLogMessage(null, "Non-authoritative source, adding the node as a replica"));
        try {
            this.nodeCommunications.getCnReplication().updateReplicationMetadata(this.session, newSystemMetadata.getIdentifier(), mnReplica, hzSystemMetadata.getSerialVersion().longValue());
            this.notifyReplicaNodes(TypeFactory.buildIdentifier((String)this.task.getPid()), isV1Object);
        }
        catch (InvalidRequest | InvalidToken | NotAuthorized | NotImplemented e) {
            throw new UnrecoverableException("failed to add syncObject as discovered replica", e);
        }
        catch (ServiceFailure e) {
            V2TransferObjectTask.extractRetryableException(e);
            throw new UnrecoverableException("failed to add syncObject as discovered replica", e);
        }
        catch (NotFound | VersionMismatch e) {
            throw new UnrecoverableException("failed to add syncObject as discovered replica", e);
        }
    }

    private void processV1AuthoritativeUpdate(SystemMetadata mnSystemMetadata, SystemMetadata cnSystemMetadata) throws RetryableException, SynchronizationFailed, UnrecoverableException {
        logger.debug((Object)(this.task.taskLabel() + " entering processV1AuthoritativeUpdate..."));
        try {
            boolean foundValidMNChange = false;
            if (cnSystemMetadata.getObsoletedBy() == null && mnSystemMetadata.getObsoletedBy() != null) {
                logger.debug((Object)(this.task.taskLabel() + " Updating ObsoletedBy..."));
                this.nodeCommunications.getCnCore().setObsoletedBy(this.session, TypeFactory.buildIdentifier((String)this.task.getPid()), mnSystemMetadata.getObsoletedBy(), cnSystemMetadata.getSerialVersion().longValue());
                logger.debug((Object)(this.task.taskLabel() + " Updated ObsoletedBy"));
                foundValidMNChange = true;
            }
            if (mnSystemMetadata.getArchived() != null && mnSystemMetadata.getArchived().booleanValue() && (cnSystemMetadata.getArchived() == null || !cnSystemMetadata.getArchived().booleanValue())) {
                logger.debug((Object)(this.task.taskLabel() + " Updating Archived..."));
                this.nodeCommunications.getCnCore().archive(this.session, TypeFactory.buildIdentifier((String)this.task.getPid()));
                logger.debug((Object)(this.task.taskLabel() + " Updated Archived"));
                foundValidMNChange = true;
            }
            if (foundValidMNChange) {
                this.notifyReplicaNodes(TypeFactory.buildIdentifier((String)this.task.getPid()), true);
            } else if (mnSystemMetadata.getDateSysMetadataModified().after(cnSystemMetadata.getDateSysMetadataModified())) {
                InvalidRequest invalidRequest = new InvalidRequest("567123", "Synchronization unable to process the update request. Only archived and obsoletedBy may be updated");
                logger.error((Object)this.buildStandardLogMessage(invalidRequest, "Ignoring update from MN. Only archived and obsoletedBy may be updated"));
                throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), null, (Exception)((Object)invalidRequest));
            }
        }
        catch (ServiceFailure e) {
            V2TransferObjectTask.extractRetryableException(e);
            throw new UnrecoverableException("Failed to update cn with new SystemMetadata.", e);
        }
        catch (InvalidRequest e) {
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "From processV1AuthoritativeUpdate: Could not update cn with new valid SystemMetadata!", (Exception)((Object)e));
        }
        catch (VersionMismatch e) {
            if (this.task.getAttempt() == 1) {
                try {
                    this.notifyReplicaNode(cnSystemMetadata, TypeFactory.buildNodeReference((String)this.task.getNodeId()));
                }
                catch (InvalidRequest | InvalidToken | NotAuthorized | NotFound | NotImplemented | ServiceFailure e1) {
                    throw new UnrecoverableException("Could not notify the source MN to update their SystemMetadata in response to encountering a VersionMismatch during V1-style system metadata update", e1);
                }
            }
            throw new RetryableException("Cannot update systemMetadata due to VersionMismatch", e, 5000L);
        }
        catch (InvalidToken | NotAuthorized | NotFound | NotImplemented e) {
            throw new UnrecoverableException("Unexpected failure when trying to update v1-permitted fields (archived, obsoletedBy).", e);
        }
    }

    private void processV2AuthoritativeUpdate(SystemMetadata mnSystemMetadata, SystemMetadataValidator validator) throws RetryableException, UnrecoverableException, SynchronizationFailed {
        logger.debug((Object)(this.task.taskLabel() + " entering processV2AuthoritativeUpdate..."));
        boolean validated = false;
        try {
            if (validator.hasValidUpdates(mnSystemMetadata)) {
                Identifier pid = mnSystemMetadata.getIdentifier();
                validated = true;
                if (CollectionUtils.isNotEmpty((Collection)validator.getReferenceSystemMetadata().getReplicaList())) {
                    mnSystemMetadata.setReplicaList(validator.getReferenceSystemMetadata().getReplicaList());
                    logger.debug((Object)(this.task.taskLabel() + " Copied over existing Replica section from CN.."));
                } else {
                    mnSystemMetadata = this.populateInitialReplicaList(mnSystemMetadata);
                    logger.debug((Object)(this.task.taskLabel() + " replica section empty, so initialized new ReplicaList"));
                }
                BigInteger cnSerialVersion = validator.getReferenceSystemMetadata().getSerialVersion();
                if (cnSerialVersion == null) {
                    cnSerialVersion = BigInteger.ONE;
                    logger.debug((Object)(this.task.taskLabel() + " serialVersion empty, so initialized to 1."));
                }
                mnSystemMetadata.setSerialVersion(cnSerialVersion);
                this.logFormatTypeChanges(mnSystemMetadata.getFormatId(), validator.getReferenceSystemMetadata().getFormatId());
                this.nodeCommunications.getCnCore().updateSystemMetadata(this.session, pid, mnSystemMetadata);
                logger.debug((Object)(this.task.taskLabel() + " Updated CN with new SystemMetadata"));
                this.notifyReplicaNodes(pid, false);
            } else {
                logger.info((Object)this.buildStandardLogMessage(null, " No changes to update."));
            }
        }
        catch (ServiceFailure e) {
            if (validated) {
                V2TransferObjectTask.extractRetryableException(e);
                throw new UnrecoverableException("Failed to update CN with new valid SystemMetadata!", e);
            }
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "Problems validating the new SystemMetadata!", (Exception)((Object)e));
        }
        catch (InvalidRequest e) {
            if (validated) {
                throw new UnrecoverableException("Failed to update CN with new valid SystemMetadata!", e);
            }
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "The new SystemMetadata contains invalid changes.", (Exception)((Object)e));
        }
        catch (InvalidSystemMetadata e) {
            throw SyncFailedTask.createSynchronizationFailed(this.task.getPid(), "The new SystemMetadata was rejected as invalid by the CN.", (Exception)((Object)e));
        }
        catch (InvalidToken | NotAuthorized | NotImplemented e) {
            throw new UnrecoverableException("Failed to update CN with new valid SystemMetadata!", e);
        }
    }

    private void logFormatTypeChanges(ObjectFormatIdentifier mnFormatId, ObjectFormatIdentifier cnFormatId) {
        try {
            String cnType;
            if (mnFormatId.getValue().equals(cnFormatId.getValue())) {
                return;
            }
            String mnType = this.nodeCommunications.getCnCore().getFormat(mnFormatId).getFormatType();
            if (mnType.equals(cnType = this.nodeCommunications.getCnCore().getFormat(cnFormatId).getFormatType())) {
                return;
            }
            if (!mnType.equalsIgnoreCase(cnType)) {
                logger.warn((Object)this.buildStandardLogMessage(null, String.format("Format type for %s has changed from %s to %s", this.task.getPid(), cnFormatId.getValue().toUpperCase(), mnFormatId.getValue().toUpperCase())));
            }
        }
        catch (InvalidRequest | NotFound | NotImplemented | ServiceFailure e) {
            logger.error((Object)this.buildStandardLogMessage(e, String.format("Format type change for %s could not be determined while looking up the ObjectFormat.", this.task.getPid())), e);
        }
        catch (Exception e) {
            logger.error((Object)this.buildStandardLogMessage(e, String.format("Format type change for %s could not be determined.", this.task.getPid())), (Throwable)e);
        }
    }

    private void notifyReplicaNodes(Identifier pid, boolean notifyAuthNode) {
        logger.info((Object)this.buildStandardLogMessage(null, " Entering notifyReplicaNodes..."));
        SystemMetadata cnSystemMetadata = (SystemMetadata)this.hzSystemMetaMap.get((Object)pid);
        if (cnSystemMetadata != null) {
            List prevReplicaList = cnSystemMetadata.getReplicaList();
            for (Replica replica : prevReplicaList) {
                NodeReference replicaNodeId = replica.getReplicaMemberNode();
                try {
                    if (notifyAuthNode) {
                        this.notifyReplicaNode(cnSystemMetadata, replicaNodeId);
                        continue;
                    }
                    if (replicaNodeId.getValue().equals(this.task.getNodeId())) continue;
                    this.notifyReplicaNode(cnSystemMetadata, replicaNodeId);
                }
                catch (InvalidRequest | InvalidToken | NotAuthorized | NotFound | NotImplemented | ServiceFailure be) {
                    logger.error((Object)this.buildStandardLogMessage(be, "Failed to notify replica member node " + replicaNodeId.getValue()), be);
                }
            }
        } else {
            logger.error((Object)this.buildStandardLogMessage(null, "null returned from Hazelcast " + this.hzSystemMetaMapString + " Map"));
        }
    }

    private void notifyReplicaNode(SystemMetadata cnSystemMetadata, NodeReference nodeId) throws InvalidToken, NotAuthorized, NotImplemented, ServiceFailure, NotFound, InvalidRequest {
        Node replicaNode = this.nodeCommunications.getNodeRegistryService().getNode(nodeId);
        if (!replicaNode.getType().equals((Object)NodeType.MN)) {
            return;
        }
        boolean isV1Tier3 = false;
        boolean isV2Tier3 = false;
        boolean hasTier3 = false;
        for (Service service : replicaNode.getServices().getServiceList()) {
            if (service.getName() == null || !service.getName().equals("MNStorage") || !service.getAvailable().booleanValue()) continue;
            if (service.getVersion().equalsIgnoreCase("V1")) {
                isV1Tier3 = true;
                hasTier3 = true;
                continue;
            }
            if (!service.getVersion().equalsIgnoreCase("V2")) continue;
            isV2Tier3 = true;
            hasTier3 = true;
        }
        if (!hasTier3) {
            return;
        }
        NodeComm nodeComm = null;
        try {
            nodeComm = NodeCommSyncObjectFactory.getInstance().getNodeComm(nodeId);
            if (isV2Tier3) {
                D1Client.getMN((String)replicaNode.getBaseURL()).systemMetadataChanged(this.session, cnSystemMetadata.getIdentifier(), cnSystemMetadata.getSerialVersion().longValue(), cnSystemMetadata.getDateSysMetadataModified());
                logger.info((Object)this.buildStandardLogMessage(null, " Notified (v2) " + nodeId.getValue()));
            } else if (isV1Tier3) {
                org.dataone.client.v1.itk.D1Client.getMN((String)replicaNode.getBaseURL()).systemMetadataChanged(this.session, cnSystemMetadata.getIdentifier(), cnSystemMetadata.getSerialVersion().longValue(), cnSystemMetadata.getDateSysMetadataModified());
                logger.info((Object)this.buildStandardLogMessage(null, " Notified (v1) " + nodeId.getValue()));
            }
        }
        catch (NodeCommUnavailable e) {
            throw new ServiceFailure("0000", "In notifyReplicaNode: " + e.getMessage());
        }
        finally {
            if (nodeComm != null) {
                nodeComm.setState(NodeCommState.AVAILABLE);
            }
        }
    }

    protected static void extractRetryableException(ServiceFailure sf) throws RetryableException {
        Object cause = null;
        if (sf != null && sf.getCause() != null && sf.getCause() instanceof ClientSideException) {
            if (sf.getCause().getCause() instanceof ConnectTimeoutException) {
                throw new RetryableException("retryable exception discovered (ConnectTimeout)", sf.getCause());
            }
            if (sf.getCause().getCause() instanceof SocketTimeoutException) {
                throw new RetryableException("retryable exception discovered (SocketTimeout)", sf.getCause());
            }
        }
    }

    protected String buildStandardLogMessage(Throwable th, String introMessage) {
        if (th == null) {
            return String.format("%s - %s", this.task.taskLabel(), introMessage);
        }
        if (th instanceof BaseException) {
            return String.format("%s - %s - %s - %s", this.task.taskLabel(), introMessage, th.getClass().getSimpleName(), ((BaseException)th).getDescription());
        }
        return String.format("%s - %s - %s - %s", this.task.taskLabel(), introMessage, th.getClass().getSimpleName(), th.getMessage());
    }
}

