/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.batch.exceptions.ExecutionDisabledException;
import org.dataone.cn.batch.synchronization.HarvestSchedulingManager;
import org.dataone.cn.batch.synchronization.tasks.SyncObjectTask;
import org.dataone.configuration.Settings;
import org.quartz.SchedulerException;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

public class SyncObjectTaskManager
implements Runnable {
    static final Logger logger = Logger.getLogger(SyncObjectTaskManager.class);
    SyncObjectTask syncObjectTask;
    private SimpleAsyncTaskExecutor taskExecutor;
    Future syncObjectTaskManagerFuture = null;
    HarvestSchedulingManager harvestSchedulingManager;
    private static final String TIMEOUT_ERROR = "[CONCURRENT_MAP_CONTAINS_KEY] Operation Timeout";
    private static int hazelcastTimeoutWaitTime = Settings.getConfiguration().getInteger("Synchronization.SyncObjectTaskManager.hazelcastTimeoutWaitTime", Integer.valueOf(30)) * 1000;
    private static int hazelcastTimeoutTryTimes = Settings.getConfiguration().getInteger("Synchronization.SyncObjectTaskManager.hazelcastTimeoutTryTimes", Integer.valueOf(5));

    public void init() {
        this.syncObjectTaskManagerFuture = this.taskExecutor.submit((Runnable)this);
    }

    @Override
    public void run() {
        boolean shouldContinueRunning = true;
        do {
            if (ComponentActivationUtility.synchronizationIsActive()) {
                logger.info((Object)"SyncObjectTaskManager Start");
                FutureTask<String> futureTask = new FutureTask<String>(this.syncObjectTask);
                this.taskExecutor.execute(futureTask);
                boolean tryAgain = false;
                int count = 0;
                do {
                    if (tryAgain) {
                        tryAgain = false;
                        logger.info((Object)("SyncObjectTaskManager start to retry when it encounters the timeout exception of the hazelcast service. The time of trying is " + count + " and the maximum try times is " + hazelcastTimeoutTryTimes));
                    }
                    try {
                        futureTask.get();
                    }
                    catch (InterruptedException ex) {
                        logger.warn((Object)ex.getMessage());
                    }
                    catch (ExecutionException ex) {
                        if (ex.getCause() instanceof ExecutionDisabledException) {
                            logger.warn((Object)"Excecution Disabled continue polling until shutdown");
                            shouldContinueRunning = true;
                            continue;
                        }
                        logger.error((Object)ex, (Throwable)ex);
                        logger.info((Object)("Running the statement of futureTask.get() got an error " + ex.getMessage()));
                        if (ex.getMessage().contains(TIMEOUT_ERROR) && count <= hazelcastTimeoutTryTimes) {
                            logger.info((Object)("This is a hazelcast timeout exception and we will wait for " + hazelcastTimeoutWaitTime + " milliseconds and try again."));
                            tryAgain = true;
                            ++count;
                            try {
                                Thread.sleep(hazelcastTimeoutWaitTime);
                            }
                            catch (Exception ee) {
                                logger.warn((Object)("SyncObjectTaskManager can't be paused to wait the recovery of the hazelcast service the since " + ee.getMessage()));
                            }
                            continue;
                        }
                        logger.info((Object)("Running the statement of futureTask.get() still got an error even though it may be to try couple times :" + ex.getMessage()));
                        shouldContinueRunning = false;
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex, (Throwable)ex);
                        shouldContinueRunning = false;
                    }
                } while (tryAgain);
                if (futureTask.isCancelled()) {
                    logger.warn((Object)"SyncObjectTask was cancelled");
                    shouldContinueRunning = false;
                    continue;
                }
                futureTask.cancel(true);
                continue;
            }
            logger.debug((Object)"SyncObjectTaskManager is disabled");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex1) {
                logger.warn((Object)ex1.getMessage());
                shouldContinueRunning = false;
            }
        } while (shouldContinueRunning);
        logger.info((Object)"SyncObjectTaskManager Complete");
        this.syncObjectTaskManagerFuture.cancel(true);
        ComponentActivationUtility.disableSynchronization();
        try {
            this.harvestSchedulingManager.halt();
        }
        catch (SchedulerException ex) {
            logger.error((Object)("Unable to halt Scheduled Tasks after failure: " + (Object)((Object)ex)), (Throwable)ex);
        }
    }

    public SyncObjectTask getSyncObjectTask() {
        return this.syncObjectTask;
    }

    public void setSyncObjectTask(SyncObjectTask syncObjectTask) {
        this.syncObjectTask = syncObjectTask;
    }

    public SimpleAsyncTaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(SimpleAsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public HarvestSchedulingManager getHarvestSchedulingManager() {
        return this.harvestSchedulingManager;
    }

    public void setHarvestSchedulingManager(HarvestSchedulingManager harvestSchedulingManager) {
        this.harvestSchedulingManager = harvestSchedulingManager;
    }
}

