/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dataone.client.v1.MNode;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.batch.exceptions.NodeCommUnavailable;
import org.dataone.cn.batch.service.v2.IdentifierReservationQueryService;
import org.dataone.cn.batch.service.v2.NodeRegistrySyncService;
import org.dataone.cn.batch.synchronization.NodeCommFactory;
import org.dataone.cn.batch.synchronization.type.NodeComm;
import org.dataone.cn.batch.synchronization.type.NodeCommState;
import org.dataone.cn.ldap.NodeRegistrySyncFacade;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.impl.v2.ReserveIdentifierService;
import org.dataone.service.cn.v2.CNCore;
import org.dataone.service.cn.v2.CNReplication;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;

public class NodeCommSyncObjectFactory
implements NodeCommFactory {
    static final Logger logger = Logger.getLogger(NodeCommSyncObjectFactory.class);
    public static final int DEFAULT_MAX_NODE_COMM_PER_MN = 5;
    private Integer maxNumberOfClientsPerMemberNode = Settings.getConfiguration().getInteger("Synchronization.SyncObjectTask.maxMemberNodeCommThreads", Integer.valueOf(5));
    private static Map<NodeReference, List<NodeComm>> initializedMemberNodes = new HashMap<NodeReference, List<NodeComm>>();
    private static NodeCommFactory nodeCommFactory = null;

    private NodeCommSyncObjectFactory() {
    }

    public static NodeCommFactory getInstance() {
        if (nodeCommFactory == null) {
            nodeCommFactory = new NodeCommSyncObjectFactory();
        }
        return nodeCommFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NodeComm getNodeComm(NodeReference mnNodeId) throws ServiceFailure, NodeCommUnavailable {
        NodeComm nodeCommunications = null;
        if (initializedMemberNodes.containsKey(mnNodeId)) {
            List<NodeComm> nodeCommList = initializedMemberNodes.get(mnNodeId);
            for (NodeComm nodeComm : nodeCommList) {
                if (!nodeComm.getState().equals((Object)NodeCommState.AVAILABLE)) continue;
                nodeCommunications = nodeComm;
                nodeCommunications.setState(NodeCommState.RUNNING);
                nodeCommunications.setRunningStartDate(new Date());
                break;
            }
            if (nodeCommunications != null) return nodeCommunications;
            if (nodeCommList.size() >= this.maxNumberOfClientsPerMemberNode) throw new NodeCommUnavailable("No Comm Nodes Available: only allow maximum of " + this.maxNumberOfClientsPerMemberNode);
            nodeCommunications = this.createNodeComm(mnNodeId);
            nodeCommunications.setState(NodeCommState.RUNNING);
            nodeCommunications.setNumber(nodeCommList.size() + 1);
            nodeCommunications.setRunningStartDate(new Date());
            nodeCommList.add(nodeCommunications);
            return nodeCommunications;
        } else {
            ArrayList<NodeComm> nodeCommList = new ArrayList<NodeComm>();
            nodeCommunications = this.createNodeComm(mnNodeId);
            nodeCommunications.setState(NodeCommState.RUNNING);
            nodeCommunications.setNumber(nodeCommList.size() + 1);
            nodeCommunications.setRunningStartDate(new Date());
            nodeCommList.add(nodeCommunications);
            initializedMemberNodes.put(mnNodeId, nodeCommList);
        }
        return nodeCommunications;
    }

    private NodeComm createNodeComm(NodeReference mnNodeId) throws ServiceFailure {
        CNode cNode = null;
        try {
            cNode = D1Client.getCN();
        }
        catch (NotImplemented e) {
            throw new ServiceFailure("0000", e.getMessage());
        }
        IdentifierReservationQueryService reserveIdentifierService = new IdentifierReservationQueryService(){
            private ReserveIdentifierService serviceImpl = new ReserveIdentifierService();

            @Override
            public boolean hasReservation(Session session, Subject subject, Identifier pid) throws NotAuthorized, NotFound, InvalidRequest, ServiceFailure {
                return this.serviceImpl.hasReservation(session, subject, pid);
            }
        };
        NodeRegistrySyncService nodeRegistryService = new NodeRegistrySyncService(){
            private NodeRegistrySyncFacade serviceImpl = new NodeRegistrySyncFacade();

            @Override
            public NodeList listNodes() throws ServiceFailure, NotImplemented {
                return this.serviceImpl.getApprovedNodeList();
            }

            @Override
            public Node getNode(NodeReference nodeId) throws NotFound, ServiceFailure {
                return this.serviceImpl.getNode(nodeId);
            }

            @Override
            public void setDateLastHarvested(NodeReference nodeIdentifier, Date lastDateNodeHarvested) throws ServiceFailure {
                this.serviceImpl.setDateLastHarvested(nodeIdentifier, lastDateNodeHarvested);
            }

            @Override
            public Date getDateLastHarvested(NodeReference nodeIdentifier) throws ServiceFailure {
                return this.serviceImpl.getDateLastHarvested(nodeIdentifier);
            }
        };
        MNode mNode = null;
        try {
            Node node = nodeRegistryService.getNode(mnNodeId);
            for (Service service : node.getServices().getServiceList()) {
                if (!service.getVersion().equals("v2")) continue;
                mNode = D1Client.getMN((String)node.getBaseURL());
                break;
            }
            if (mNode == null) {
                mNode = org.dataone.client.v1.itk.D1Client.getMN((String)node.getBaseURL());
            }
        }
        catch (NotFound ex) {
            throw new ServiceFailure("0000", ex.getDescription());
        }
        NodeComm nodeComm = new NodeComm(mNode, cNode, nodeRegistryService, (CNCore)cNode, (CNReplication)cNode, reserveIdentifierService);
        return nodeComm;
    }
}

