/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.jobs;

import org.apache.log4j.Logger;
import org.dataone.cn.ComponentActivationUtility;
import org.dataone.cn.batch.synchronization.tasks.SyncMetricLogReport;
import org.dataone.cn.batch.synchronization.type.SyncQueueFacade;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class SyncMetricLogJob
implements Job {
    static final Logger logger = Logger.getLogger(SyncMetricLogJob.class);
    static final SyncMetricLogReport syncMetricLogReport = new SyncMetricLogReport();

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        JobExecutionException jex = null;
        try {
            logger.debug((Object)"start");
            if (ComponentActivationUtility.synchronizationIsActive()) {
                SyncQueueFacade hzSyncObjectQueue = new SyncQueueFacade();
                syncMetricLogReport.reportSyncMetrics(hzSyncObjectQueue);
            } else {
                logger.warn((Object)"SyncMetricLogJob Disabled");
            }
            logger.debug((Object)"end");
        }
        catch (Exception ex) {
            logger.error((Object)(jobContext.getJobDetail().getKey().getName() + " died: " + ex.getMessage()), (Throwable)ex);
            jex = new JobExecutionException();
            jex.unscheduleFiringTrigger();
            jex.setStackTrace(ex.getStackTrace());
        }
        if (jex != null) {
            throw jex;
        }
    }
}

