/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.type;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import java.util.Deque;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.batch.synchronization.type.AbstractListenableMapAdapter;
import org.dataone.cn.batch.synchronization.type.DistributedDataClient;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.synchronization.types.SyncObject;
import org.dataone.configuration.Settings;

public class SyncQueueFacade
implements EntryListener<String, String> {
    static final Logger __logger = Logger.getLogger(SyncQueueFacade.class);
    protected Deque<String> nodeIdRoundRobin = new ConcurrentLinkedDeque<String>();
    protected String synchronizationObjectQueue = Settings.getConfiguration().getString("dataone.hazelcast.synchronizationObjectQueue", "default");
    DistributedDataClient processingClient = null;
    Map<String, String> queueMap = null;
    Map<String, String> priorityQueueMap = null;

    public SyncQueueFacade() {
        this(new DistributedDataClient(){

            @Override
            public <K, V> Map<K, V> getMap(String mapName) {
                return new AbstractListenableMapAdapter<K, V>((Map)HazelcastClientFactory.getProcessingClient().getMap(mapName)){

                    @Override
                    public void notifyEntryListeners(String action, Object key, Object value) {
                    }

                    @Override
                    public void addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
                        ((IMap)this.map).addEntryListener(listener, includeValue);
                    }
                };
            }

            public <E> IQueue<E> getQueue(String queueName) {
                return HazelcastClientFactory.getProcessingClient().getQueue(queueName);
            }

            public <E> ISet<E> getSet(String setName) {
                return HazelcastClientFactory.getProcessingClient().getSet(setName);
            }

            @Override
            public ILock getLock(String lockName) {
                return HazelcastClientFactory.getProcessingClient().getLock((Object)lockName);
            }
        });
    }

    public SyncQueueFacade(DistributedDataClient client) {
        this.processingClient = client;
        this.queueMap = this.processingClient.getMap("dataone.synchronization.queueMap");
        if (this.queueMap instanceof DistributedDataClient.ListenableMap) {
            ((DistributedDataClient.ListenableMap)((Object)this.queueMap)).addEntryListener(this, false);
            __logger.info((Object)(this + " Added listener to 'dataone.synchronization.queueMap'"));
        }
        this.priorityQueueMap = this.processingClient.getMap("dataone.synchronization.priority.queueMap");
        if (this.priorityQueueMap instanceof DistributedDataClient.ListenableMap) {
            ((DistributedDataClient.ListenableMap)((Object)this.priorityQueueMap)).addEntryListener(this, false);
            __logger.info((Object)(this + " Added listener to 'dataone.synchronization.queueMap'"));
        }
        for (String nodeId : this.getQueueNames()) {
            this.nodeIdRoundRobin.add(nodeId);
            __logger.info((Object)(this + " added '" + nodeId + "' to its queue round-robin. size: " + this.size(nodeId)));
        }
        if (!this.queueMap.containsKey("legacy")) {
            this.queueMap.put("legacy", this.synchronizationObjectQueue);
            __logger.info((Object)(this + " added 'legacy' queue to its queue round-robin. size: " + this.size("legacy")));
        }
    }

    public void add(SyncObject syncObject) {
        String nodeId;
        String string = nodeId = syncObject.getNodeId() == null ? "generic" : syncObject.getNodeId();
        if (!this.queueMap.containsKey(nodeId)) {
            this.queueMap.put(nodeId, "dataone.synchronization.queue." + nodeId);
        }
        this.processingClient.getQueue(this.queueMap.get(nodeId)).add(syncObject);
    }

    public void addWithPriority(SyncObject syncObject) {
        String nodeId;
        String string = nodeId = syncObject.getNodeId() == null ? "generic" : syncObject.getNodeId();
        if (!this.priorityQueueMap.containsKey(nodeId)) {
            this.priorityQueueMap.put(nodeId, "dataone.synchronization.priority.queue." + nodeId);
        }
        this.processingClient.getQueue(this.priorityQueueMap.get(nodeId)).add(syncObject);
    }

    public SyncObject poll(long timeout, TimeUnit unit) throws InterruptedException {
        SyncObject item = null;
        if (__logger.isTraceEnabled()) {
            __logger.trace((Object)String.format("poll timeout = %d %s. nodeId RR size %d", new Object[]{timeout, unit, this.nodeIdRoundRobin.size()}));
        }
        long now = System.currentTimeMillis();
        long pollUntil = now + TimeUnit.MILLISECONDS.convert(timeout, unit);
        while (now < pollUntil) {
            String nextQueue = this.getNextNodeId();
            if (this.priorityQueueMap.containsKey(nextQueue)) {
                if (__logger.isTraceEnabled()) {
                    __logger.trace((Object)("...polling priority queue: " + nextQueue));
                }
                item = (SyncObject)this.processingClient.getQueue(this.priorityQueueMap.get(nextQueue)).poll(100L, TimeUnit.MICROSECONDS);
            }
            if (item == null && this.queueMap.containsKey(nextQueue)) {
                if (__logger.isTraceEnabled()) {
                    __logger.trace((Object)("...polling queue: " + nextQueue));
                }
                item = (SyncObject)this.processingClient.getQueue(this.queueMap.get(nextQueue)).poll(10L, TimeUnit.MILLISECONDS);
            }
            if (item != null) break;
            now = System.currentTimeMillis();
        }
        return item;
    }

    protected String getNextNodeId() {
        if (this.nodeIdRoundRobin.size() == 1) {
            return this.nodeIdRoundRobin.getLast();
        }
        if (this.nodeIdRoundRobin.size() == 0) {
            return null;
        }
        String nextNodeId = this.nodeIdRoundRobin.removeFirst();
        this.nodeIdRoundRobin.addLast(nextNodeId);
        return nextNodeId;
    }

    public int size() {
        int size = 0;
        for (String name : this.getQueueNames()) {
            size += this.size(name);
        }
        return size;
    }

    public int size(String nodeId) {
        int size = 0;
        if (this.priorityQueueMap.containsKey(nodeId)) {
            size += this.processingClient.getQueue(this.priorityQueueMap.get(nodeId)).size();
        }
        if (this.queueMap.containsKey(nodeId)) {
            size += this.processingClient.getQueue(this.queueMap.get(nodeId)).size();
        }
        return size;
    }

    public BlockingQueue<Object> getLegacyQueue() {
        return this.processingClient.getQueue(this.queueMap.get("legacy"));
    }

    public TreeSet<String> getQueueNames() {
        if (__logger.isTraceEnabled()) {
            __logger.trace((Object)("...queueMap keyset: " + StringUtils.join(this.queueMap.keySet(), (char)',')));
            __logger.trace((Object)("...priorityQueueMap keyset: " + StringUtils.join(this.priorityQueueMap.keySet(), (char)',')));
        }
        TreeSet<String> queueNames = new TreeSet<String>();
        queueNames.addAll(this.queueMap.keySet());
        if (__logger.isTraceEnabled()) {
            __logger.trace((Object)("...   size of queueNames set (1 of 2 addAlls)" + queueNames.size()));
        }
        queueNames.addAll(this.priorityQueueMap.keySet());
        if (__logger.isTraceEnabled()) {
            __logger.trace((Object)("...   size of queueNames set (2 of 2 addAlls)" + queueNames.size()));
        }
        return queueNames;
    }

    public synchronized void entryAdded(EntryEvent<String, String> event) {
        if (!this.nodeIdRoundRobin.contains(event.getKey())) {
            this.nodeIdRoundRobin.add((String)event.getKey());
            __logger.info((Object)(this + " added queue named '" + (String)event.getKey() + "' to the queue round robin"));
        } else {
            __logger.info((Object)(this + " the queue named '" + (String)event.getKey() + "' is already in the queue round robin"));
        }
    }

    public void entryRemoved(EntryEvent<String, String> event) {
        if (__logger.isDebugEnabled()) {
            __logger.debug((Object)(this + " received entryRemoved event for key '" + (String)event.getKey() + "'.  (no-op)"));
        }
    }

    public void entryUpdated(EntryEvent<String, String> event) {
        if (__logger.isDebugEnabled()) {
            __logger.debug((Object)(this + " received entryUpdated event for key '" + (String)event.getKey() + "'.  (no-op)"));
        }
    }

    public void entryEvicted(EntryEvent<String, String> event) {
        if (__logger.isDebugEnabled()) {
            __logger.debug((Object)(this + " received entryEvicted event for key '" + (String)event.getKey() + "'.  (no-op)"));
        }
    }
}

