/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.batch.synchronization.tasks;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.dataone.cn.batch.synchronization.type.SyncQueueFacade;
import org.dataone.cn.log.MetricEvent;
import org.dataone.cn.log.MetricLogClientFactory;
import org.dataone.cn.log.MetricLogEntry;
import org.dataone.cn.synchronization.types.SyncObject;
import org.dataone.service.types.v1.NodeReference;

public class SyncMetricLogReport {
    static final Logger logger = Logger.getLogger(SyncMetricLogReport.class);

    /*
     * WARNING - void declaration
     */
    public void reportSyncMetrics(SyncQueueFacade hzSyncObjectQueue) {
        logger.debug((Object)"start");
        Date metricLogReportDate = new Date(System.currentTimeMillis());
        HashMap<String, MutableCounter> legacySyncObjectPerNodeMap = new HashMap<String, MutableCounter>();
        MetricLogEntry metricLogEntry = new MetricLogEntry(MetricEvent.SYNCHRONIZATION_QUEUED);
        metricLogEntry.setMessage("Total Sync Objects Queued: " + hzSyncObjectQueue.size());
        metricLogEntry.setDateLogged(metricLogReportDate);
        MetricLogClientFactory.getMetricLogClient().logMetricEvent(metricLogEntry);
        SyncObject[] syncObjectArray = hzSyncObjectQueue.getLegacyQueue().toArray(new SyncObject[0]);
        for (int i = 0; i < syncObjectArray.length; ++i) {
            void var8_9;
            String nodeId = syncObjectArray[i].getNodeId();
            MutableCounter mutableCounter = (MutableCounter)legacySyncObjectPerNodeMap.get(nodeId);
            if (mutableCounter == null) {
                MutableCounter mutableCounter2 = new MutableCounter();
                legacySyncObjectPerNodeMap.put(nodeId, mutableCounter2);
            }
            var8_9.increment();
        }
        for (String qName : hzSyncObjectQueue.getQueueNames()) {
            hzSyncObjectQueue.size(qName);
            legacySyncObjectPerNodeMap.get(qName);
        }
        HashSet<Object> nodesToReport = new HashSet<Object>();
        nodesToReport.addAll(legacySyncObjectPerNodeMap.keySet());
        nodesToReport.addAll(hzSyncObjectQueue.getQueueNames());
        for (String string : nodesToReport) {
            NodeReference nodeReference = new NodeReference();
            nodeReference.setValue(string);
            metricLogEntry = new MetricLogEntry(MetricEvent.SYNCHRONIZATION_QUEUED, nodeReference);
            int sum = hzSyncObjectQueue.size(string) + (legacySyncObjectPerNodeMap.get(string) == null ? 0 : ((MutableCounter)legacySyncObjectPerNodeMap.get(string)).getInt());
            metricLogEntry.setMessage("Sync Objects Queued: " + sum);
            metricLogEntry.setDateLogged(metricLogReportDate);
            MetricLogClientFactory.getMetricLogClient().logMetricEvent(metricLogEntry);
        }
        logger.debug((Object)"end");
    }

    private class MutableCounter {
        private int value = 0;

        private MutableCounter() {
        }

        public void increment() {
            ++this.value;
        }

        public int getInt() {
            return this.value;
        }
    }
}

