/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.okay;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dataone.client.CNode;
import org.dataone.client.D1Client;
import org.dataone.client.auth.CertificateManager;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.impl.v1.NodeRegistryService;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.Node;
import org.dataone.service.types.v1.NodeList;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.ObjectInfo;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.util.NodelistUtil;
import org.dataone.tidy.okay.metacat.MetacatDAO;
import org.dataone.tidy.okay.metacat.MetacatProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);
    static Properties metacatProperties = null;
    static final String localNodeId = Settings.getConfiguration().getString("cn.nodeId");
    private static int start = 0;
    private static int total = 0;
    static Integer batchSize = new Integer(10000);

    public static void main(String[] args) {
        try {
            metacatProperties = MetacatProperties.getMetacatProperties();
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusPrinter.print((Context)lc);
        NodeRegistryService nodeRegistry = new NodeRegistryService();
        NodeList nodeList = new NodeList();
        try {
            nodeList = nodeRegistry.listNodes();
        }
        catch (NotImplemented ex) {
            logger.error(ex.getLocalizedMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (ServiceFailure ex) {
            logger.error(ex.getLocalizedMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        Map baseUrlMap = NodelistUtil.mapNodeList((NodeList)nodeList);
        String localBaseURL = (String)baseUrlMap.get(localNodeId);
        Settings.getConfiguration().setProperty("D1Client.CN_URL", (Object)localBaseURL);
        D1Client d1Client = new D1Client();
        CNode cnNode = null;
        try {
            cnNode = d1Client.getCN();
        }
        catch (ServiceFailure ex) {
            logger.error(ex.getLocalizedMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        MetacatDAO metacatDao = new MetacatDAO();
        boolean okay = true;
        Set metacatIdentifierSet = null;
        try {
            metacatIdentifierSet = metacatDao.getMetacatIdentifiers();
        }
        catch (SQLException ex) {
            okay = false;
            logger.error(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        catch (IOException ex) {
            okay = false;
            logger.error(ex.getLocalizedMessage());
            ex.printStackTrace();
        }
        if (okay) {
            List<String> idlist = null;
            try {
                idlist = Main.listIdentifiers(cnNode);
            }
            catch (InvalidRequest ex) {
                okay = false;
                logger.error(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            catch (InvalidToken ex) {
                okay = false;
                logger.error(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            catch (NotAuthorized ex) {
                okay = false;
                logger.error(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            catch (NotImplemented ex) {
                okay = false;
                logger.error(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            catch (ServiceFailure ex) {
                okay = false;
                logger.error(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            if (okay) {
                for (String pid : idlist) {
                    if (metacatIdentifierSet.contains(pid)) continue;
                    okay = false;
                    logger.warn(pid + " was found in database but not in list objects");
                }
            }
            if (okay) {
                logger.info("listObjects appears okay with " + idlist.size() + " # of objects from a count of " + total);
            } else {
                logger.warn("listOjects failed");
            }
        }
        okay = true;
        for (Node mnNode : nodeList.getNodeList()) {
            if (!mnNode.getType().equals((Object)NodeType.MN)) continue;
            try {
                metacatIdentifierSet = metacatDao.getMetacatIdentifiersByAuthNode(mnNode.getIdentifier().getValue());
            }
            catch (SQLException ex) {
                okay = false;
                logger.error(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            catch (IOException ex) {
                okay = false;
                logger.error(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            if (!okay) continue;
            for (String pidStr : metacatIdentifierSet) {
                Identifier pid = new Identifier();
                pid.setValue(pidStr);
                try {
                    cnNode.getSystemMetadata(pid);
                }
                catch (InvalidToken ex) {
                    okay = false;
                    logger.error(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
                catch (ServiceFailure ex) {
                    okay = false;
                    logger.error(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
                catch (NotAuthorized ex) {
                    okay = false;
                    logger.error(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
                catch (NotFound ex) {
                    okay = false;
                    logger.error(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
                catch (NotImplemented ex) {
                    okay = false;
                    logger.error(ex.getLocalizedMessage());
                    ex.printStackTrace();
                }
            }
        }
        if (okay) {
            logger.info("getSystemMetadatas appear okay");
            logger.info("d1 tidy is okay");
        } else {
            logger.warn("getSystemMetadatas failed");
        }
        System.exit(0);
    }

    private static List<String> listIdentifiers(CNode cnNode) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        ArrayList<String> listIds = new ArrayList<String>();
        List<ObjectInfo> readQueue = null;
        do {
            if (start == 0 || start < total) {
                readQueue = Main.retrieve(cnNode);
                for (ObjectInfo objectInfo : readQueue) {
                    listIds.add(objectInfo.getIdentifier().getValue());
                }
            } else {
                readQueue = null;
            }
        } while (readQueue != null && !readQueue.isEmpty());
        return listIds;
    }

    private static List<ObjectInfo> retrieve(CNode cnNode) throws InvalidRequest, InvalidToken, NotAuthorized, NotImplemented, ServiceFailure {
        ArrayList<ObjectInfo> writeQueue = new ArrayList<ObjectInfo>();
        ObjectList objectList = null;
        Object replicationStatus = null;
        Session session = new Session();
        objectList = cnNode.listObjects(session, null, null, null, null, Integer.valueOf(start), batchSize);
        if (objectList != null && objectList.getCount() != 0 && !objectList.getObjectInfoList().isEmpty()) {
            start += objectList.getCount();
            writeQueue.addAll(objectList.getObjectInfoList());
            total = objectList.getTotal();
        }
        return writeQueue;
    }

    static {
        String clientCertLocation = Settings.getConfiguration().getString("D1Client.certificate.directory");
        String clientCertFilename = Settings.getConfiguration().getString("D1Client.certificate.filename");
        File d1CertFile = new File(clientCertLocation + File.separator + clientCertFilename);
        String clientCertificateLocation = d1CertFile.getAbsolutePath();
        CertificateManager.getInstance().setCertificateLocation(clientCertificateLocation);
    }
}

