/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.concurrent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.tidy.concurrent.TidyJob;
import org.dataone.tidy.dao.ChangeRecordRepository;
import org.dataone.tidy.dao.MergeResultRepository;
import org.dataone.tidy.dao.SystemMetadataTidyDao;
import org.dataone.tidy.merge.MNSystemMetadataDelegate;

public class TidyJobFactory {
    private static final Log logger = LogFactory.getLog((String)TidyJobFactory.class.getName());
    private static String tinyJobClassName = Settings.getConfiguration().getString("tidy.job.class.name", "org.dataone.tidy.merge.MergeJob");
    private SystemMetadataTidyDao systemMetadataTidyDao;
    private MergeResultRepository mergeResultRepo;
    private ChangeRecordRepository changeRecordRepo;
    private MNSystemMetadataDelegate mnReadClient;

    private TidyJobFactory() {
    }

    public TidyJobFactory(SystemMetadataTidyDao systemMetadataTidyDao, MergeResultRepository mergeResultRepo, ChangeRecordRepository changeRecordRepo, MNSystemMetadataDelegate readClient) {
        this.systemMetadataTidyDao = systemMetadataTidyDao;
        this.mergeResultRepo = mergeResultRepo;
        this.changeRecordRepo = changeRecordRepo;
        this.mnReadClient = readClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TidyJob getTidyJob(Identifier identifier) {
        TidyJob tidyJob;
        block9: {
            tidyJob = null;
            try {
                Class<?> tidyJobClass = Class.forName(TidyJobFactory.getTinyJobClassName());
                tidyJob = (TidyJob)tidyJobClass.newInstance();
                tidyJob.setPid(identifier);
                tidyJob.setSystemMetadataTidyDao(this.systemMetadataTidyDao);
                tidyJob.setMergeResultRepository(this.mergeResultRepo);
                tidyJob.setChangeRecordRepository(this.changeRecordRepo);
                tidyJob.setMnReadClient(this.mnReadClient);
            }
            catch (InstantiationException ex) {
                logger.error((Object)ex);
            }
            catch (IllegalAccessException ex) {
                logger.error((Object)ex);
            }
            catch (ClassNotFoundException ex) {
                logger.error((Object)ex);
            }
            finally {
                if (tidyJob != null) break block9;
                throw new NullPointerException(TidyJobFactory.getTinyJobClassName() + " could not be instantiated");
            }
        }
        return tidyJob;
    }

    public static String getTinyJobClassName() {
        return tinyJobClassName;
    }

    public static void setTinyJobClassName(String tinyJobClassName) {
        TidyJobFactory.tinyJobClassName = tinyJobClassName;
    }
}

