/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.dao;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;
import org.dataone.tidy.dao.ChangeRecordRepository;
import org.dataone.tidy.dao.MergeResultRepository;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(value={"org.dataone.tidy.dao"})
@ComponentScan(value={"org.dataone.tidy"})
public abstract class BaseJpaRepositoryConfiguration {
    private static final String show_sql_prop = "datasource.show.sql";
    private static final String generate_ddl_prop = "datasource.generate.ddl";
    protected static final boolean show_sql = Settings.getConfiguration().getBoolean("datasource.show.sql", false);
    protected static final boolean generate_ddl = Settings.getConfiguration().getBoolean("datasource.generate.ddl", false);
    private static final Log log = LogFactory.getLog(BaseJpaRepositoryConfiguration.class);
    protected AbstractApplicationContext context;

    public void initContext() {
        if (this.context == null) {
            this.context = new AnnotationConfigApplicationContext(new Class[]{this.getClass()});
        }
    }

    public void closeContext() {
        this.context.close();
        this.context = null;
    }

    public ChangeRecordRepository getChangeRecordRepository() {
        return (ChangeRecordRepository)this.context.getBean(ChangeRecordRepository.class);
    }

    public MergeResultRepository getMergeResultRepository() {
        return (MergeResultRepository)this.context.getBean(MergeResultRepository.class);
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource dataSource, JpaVendorAdapter jpaVendorAdapter) {
        LocalContainerEntityManagerFactoryBean lef = new LocalContainerEntityManagerFactoryBean();
        lef.setDataSource(dataSource);
        lef.setJpaVendorAdapter(jpaVendorAdapter);
        lef.setPackagesToScan(new String[]{"org.dataone.tidy.dao"});
        return lef;
    }

    @Bean
    public PlatformTransactionManager transactionManager() {
        return new JpaTransactionManager();
    }

    public abstract DataSource dataSource();

    public abstract JpaVendorAdapter jpaVendorAdapter();
}

