/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.annotation.SparqlField;
import org.dataone.cn.indexer.parser.utility.TemplateStringProcessor;
import org.dataone.cn.indexer.solrhttp.SolrElementField;

public class ElementCombiner {
    private String name;
    private String delimiter = " ";
    private String template;
    private LinkedHashMap<String, Object> elements = new LinkedHashMap();
    private TemplateStringProcessor templateProcessor = new TemplateStringProcessor();
    private static Log log = LogFactory.getLog(ElementCombiner.class);

    public List<String> getElementValues(Dataset dataset, boolean multipleValues) {
        String templateResult;
        String templateValue;
        ArrayList<String> resultValues = new ArrayList<String>();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.elements.entrySet()) {
            String elementName = entry.getKey();
            log.trace((Object)("Found element: " + elementName));
            SparqlField element = (SparqlField)entry.getValue();
            String q = null;
            q = element.getQuery();
            Query query = QueryFactory.create((String)q);
            QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Dataset)dataset);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution solution = results.next();
                if (!solution.contains(elementName)) continue;
                String value = solution.get(elementName).toString();
                if (element.getConverter() != null) {
                    value = element.getConverter().convert(value);
                }
                SolrElementField f = new SolrElementField(elementName, value);
                log.trace((Object)("JsonLdSubprocessor.process process the field " + elementName + "with value " + value));
                valueMap.put(elementName, value);
            }
            qexec.close();
        }
        if (!valueMap.isEmpty() && (templateValue = this.getTemplate()).compareTo(templateResult = this.templateProcessor.process(templateValue, valueMap)) != 0) {
            resultValues.add(templateResult);
        }
        return resultValues;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public LinkedHashMap<String, Object> getElements() {
        return this.elements;
    }

    public void setElements(LinkedHashMap<String, Object> elements) {
        this.elements = elements;
    }
}

