/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.MapSerializable;
import org.apache.solr.core.RequestParams;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;

public class ConfigOverlay
implements MapSerializable {
    private final int znodeVersion;
    private final Map<String, Object> data;
    private Map<String, Object> props;
    private Map<String, Object> userProps;
    public static final String NOT_EDITABLE = "''{0}'' is not an editable property";
    public static final String RESOURCE_NAME = "configoverlay.json";
    private static Map editable_prop_map;
    public static final String MAPPING = "{  updateHandler:{    autoCommit:{      maxDocs:20,      maxTime:20,      openSearcher:11},    autoSoftCommit:{      maxDocs:20,      maxTime:20},    commitWithin:{softCommit:11},    indexWriter:{closeWaitsForMerges:11}},  query:{    filterCache:{      class:0,      size:0,      initialSize:20,      autowarmCount:20,      maxRamMB:20,      regenerator:0},    queryResultCache:{      class:0,      size:20,      initialSize:20,      autowarmCount:20,      maxRamMB:20,      regenerator:0},    documentCache:{      class:0,      size:20,      initialSize:20,      autowarmCount:20,      regenerator:0},    fieldValueCache:{      class:0,      size:20,      initialSize:20,      autowarmCount:20,      regenerator:0},    useFilterForSortedQuery:1,    queryResultWindowSize:1,    queryResultMaxDocsCached:1,    enableLazyFieldLoading:1,    boolTofilterOptimizer:1,    maxBooleanClauses:1},  jmx:{    agentId:0,    serviceUrl:0,    rootName:0},  requestDispatcher:{    handleSelect:0,    requestParsers:{      multipartUploadLimitInKB:0,      formdataUploadLimitInKB:0,      enableRemoteStreaming:0,      addHttpRequestToContext:0}}}";
    static Class[] types;
    public static final String ZNODEVER = "znodeVersion";
    public static final String NAME = "overlay";

    public ConfigOverlay(Map<String, Object> jsonObj, int znodeVersion) {
        if (jsonObj == null) {
            jsonObj = Collections.EMPTY_MAP;
        }
        this.znodeVersion = znodeVersion;
        this.data = Collections.unmodifiableMap(jsonObj);
        this.props = (Map)this.data.get("props");
        if (this.props == null) {
            this.props = Collections.EMPTY_MAP;
        }
        this.userProps = (Map)this.data.get("userProps");
        if (this.userProps == null) {
            this.userProps = Collections.EMPTY_MAP;
        }
    }

    public Object getXPathProperty(String xpath) {
        return this.getXPathProperty(xpath, true);
    }

    public Object getXPathProperty(String xpath, boolean onlyPrimitive) {
        List<String> hierarchy = this.checkEditable(xpath, true, false);
        if (hierarchy == null) {
            return null;
        }
        return ConfigOverlay.getObjectByPath(this.props, onlyPrimitive, hierarchy);
    }

    public static Object getObjectByPath(Map root, boolean onlyPrimitive, List<String> hierarchy) {
        Map obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            String s = hierarchy.get(i);
            if (i < hierarchy.size() - 1) {
                if (!(obj.get(s) instanceof Map)) {
                    return null;
                }
                if ((obj = (Map)obj.get(s)) != null) continue;
                return null;
            }
            Object val = obj.get(s);
            if (onlyPrimitive && val instanceof Map) {
                return null;
            }
            return val;
        }
        return false;
    }

    public ConfigOverlay setUserProperty(String key, Object val) {
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.userProps);
        copy.put(key, val);
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("userProps", copy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    public ConfigOverlay unsetUserProperty(String key) {
        if (!this.userProps.containsKey(key)) {
            return this;
        }
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.userProps);
        copy.remove(key);
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("userProps", copy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    public ConfigOverlay setProperty(String name, Object val) {
        Map deepCopy;
        List<String> hierarchy = this.checkEditable(name, false, true);
        Map obj = deepCopy = this.getDeepCopy(this.props);
        for (int i = 0; i < hierarchy.size(); ++i) {
            String s = hierarchy.get(i);
            if (i < hierarchy.size() - 1) {
                if (obj.get(s) == null || !(obj.get(s) instanceof Map)) {
                    obj.put(s, new LinkedHashMap());
                }
                obj = (Map)obj.get(s);
                continue;
            }
            obj.put(s, val);
        }
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("props", deepCopy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    private Map getDeepCopy(Map map) {
        return (Map)ZkStateReader.fromJSON((byte[])ZkStateReader.toJSON((Object)map));
    }

    private List<String> checkEditable(String propName, boolean isXPath, boolean failOnError) {
        LinkedList<String> hierarchy = new LinkedList<String>();
        if (!ConfigOverlay.isEditableProp(propName, isXPath, hierarchy)) {
            if (failOnError) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, StrUtils.formatString((String)NOT_EDITABLE, (Object[])new Object[]{propName}));
            }
            return null;
        }
        return hierarchy;
    }

    public ConfigOverlay unsetProperty(String name) {
        Map deepCopy;
        List<String> hierarchy = this.checkEditable(name, false, true);
        Map obj = deepCopy = this.getDeepCopy(this.props);
        for (int i = 0; i < hierarchy.size(); ++i) {
            String s = hierarchy.get(i);
            if (i < hierarchy.size() - 1) {
                if (obj.get(s) == null || !(obj.get(s) instanceof Map)) {
                    return this;
                }
                obj = (Map)obj.get(s);
                continue;
            }
            obj.remove(s);
        }
        LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(this.data);
        jsonObj.put("props", deepCopy);
        return new ConfigOverlay(jsonObj, this.znodeVersion);
    }

    public byte[] toByteArray() {
        return ZkStateReader.toJSON(this.data);
    }

    public int getZnodeVersion() {
        return this.znodeVersion;
    }

    public String toString() {
        CharArr out = new CharArr();
        try {
            new JSONWriter(out, 2).write(this.data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out.toString();
    }

    public static boolean isEditableProp(String path, boolean isXpath, List<String> hierarchy) {
        return ConfigOverlay.checkEditable(path, isXpath, hierarchy) != null;
    }

    public static Class checkEditable(String path, boolean isXpath, List<String> hierarchy) {
        List parts = StrUtils.splitSmart((String)path, (char)(isXpath ? (char)'/' : '.'));
        Map obj = editable_prop_map;
        for (int i = 0; i < parts.size(); ++i) {
            boolean isAttr;
            String part = (String)parts.get(i);
            boolean bl = isAttr = isXpath && part.startsWith("@");
            if (isAttr) {
                part = part.substring(1);
            }
            if (hierarchy != null) {
                hierarchy.add(part);
            }
            if (obj == null) {
                return null;
            }
            if (i == parts.size() - 1) {
                if (obj instanceof Map) {
                    Map map = obj;
                    Object o = map.get(part);
                    return ConfigOverlay.checkType(o, isXpath, isAttr);
                }
                return null;
            }
            obj = obj.get(part);
        }
        return null;
    }

    private static Class checkType(Object o, boolean isXpath, boolean isAttr) {
        if (o instanceof Long) {
            Long aLong = (Long)o;
            int ten = aLong.intValue() / 10;
            int one = aLong.intValue() % 10;
            if (isXpath && isAttr && one != 0) {
                return null;
            }
            return types[ten];
        }
        return null;
    }

    public Map<String, String> getEditableSubProperties(String xpath) {
        Object o = ConfigOverlay.getObjectByPath(this.props, false, StrUtils.splitSmart((String)xpath, (char)'/'));
        if (o instanceof Map) {
            return (Map)o;
        }
        return null;
    }

    public Map<String, Object> getUserProps() {
        return this.userProps;
    }

    @Override
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(ZNODEVER, this.znodeVersion);
        result.putAll(this.data);
        return result;
    }

    public Map<String, Map> getNamedPlugins(String typ) {
        Map reqHandlers = (Map)this.data.get(typ);
        if (reqHandlers == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(reqHandlers);
    }

    public ConfigOverlay addNamedPlugin(Map<String, Object> info, String typ) {
        Map dataCopy = RequestParams.getDeepCopy(this.data, 4);
        LinkedHashMap<Object, Map<String, Object>> reqHandler = (LinkedHashMap<Object, Map<String, Object>>)dataCopy.get(typ);
        if (reqHandler == null) {
            reqHandler = new LinkedHashMap<Object, Map<String, Object>>();
            dataCopy.put(typ, reqHandler);
        }
        reqHandler.put(info.get("name"), info);
        return new ConfigOverlay(dataCopy, this.znodeVersion);
    }

    public ConfigOverlay deleteNamedPlugin(String name, String typ) {
        Map dataCopy = RequestParams.getDeepCopy(this.data, 4);
        Map reqHandler = (Map)dataCopy.get(typ);
        if (reqHandler == null) {
            return this;
        }
        reqHandler.remove(name);
        return new ConfigOverlay(dataCopy, this.znodeVersion);
    }

    public static void main(String[] args) {
    }

    static {
        try {
            editable_prop_map = (Map)new ObjectBuilder(new JSONParser((Reader)new StringReader(MAPPING))).getObject();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error parsing mapping ", (Throwable)e);
        }
        types = new Class[]{String.class, Boolean.class, Integer.class, Float.class};
    }
}

