/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.EphemeralDirectoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAMDirectoryFactory
extends EphemeralDirectoryFactory {
    public static Logger LOG = LoggerFactory.getLogger(RAMDirectoryFactory.class);

    @Override
    protected LockFactory createLockFactory(String rawLockType) throws IOException {
        if (rawLockType != null && !"single".equalsIgnoreCase(rawLockType.trim())) {
            throw new SolrException(SolrException.ErrorCode.FORBIDDEN, "RAMDirectory can only be used with the 'single' lock factory type.");
        }
        return new SingleInstanceLockFactory();
    }

    @Override
    protected Directory create(String path, LockFactory lockFactory, DirectoryFactory.DirContext dirContext) throws IOException {
        return new RAMDirectory(lockFactory);
    }
}

