/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetProcessor;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SortSlotAcc;

abstract class FacetFieldProcessor
extends FacetProcessor<FacetField> {
    SchemaField sf;
    SlotAcc sortAcc;
    SlotAcc indexOrderAcc;
    int effectiveMincount;

    FacetFieldProcessor(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq);
        this.sf = sf;
        this.effectiveMincount = (int)(fcontext.isShard() ? Math.min(1L, freq.mincount) : freq.mincount);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    void setSortAcc(int numSlots) {
        if (this.indexOrderAcc == null) {
            this.indexOrderAcc = new SortSlotAcc(this.fcontext);
        }
        String sortKey = ((FacetField)this.freq).sortVariable;
        this.sortAcc = (SlotAcc)this.accMap.get(sortKey);
        if (this.sortAcc == null) {
            if ("count".equals(sortKey)) {
                this.sortAcc = this.countAcc;
            } else if ("index".equals(sortKey)) {
                this.sortAcc = this.indexOrderAcc;
            }
        }
    }

    static class Slot {
        int slot;

        Slot() {
        }

        public int tiebreakCompare(int slotA, int slotB) {
            return slotB - slotA;
        }
    }
}

