/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetField;
import org.apache.solr.search.facet.FacetFieldProcessorFCBase;
import org.apache.solr.search.facet.FieldUtil;

class FacetFieldProcessorDV
extends FacetFieldProcessorFCBase {
    static boolean unwrap_singleValued_multiDv = true;
    boolean multiValuedField;
    SortedSetDocValues si;
    MultiDocValues.OrdinalMap ordinalMap = null;

    public FacetFieldProcessorDV(FacetContext fcontext, FacetField freq, SchemaField sf) {
        super(fcontext, freq, sf);
        this.multiValuedField = sf.multiValued() || sf.getType().multiValuedFieldCache();
    }

    @Override
    protected BytesRef lookupOrd(int ord) throws IOException {
        return this.si.lookupOrd((long)ord);
    }

    @Override
    protected void findStartAndEndOrds() throws IOException {
        if (this.multiValuedField) {
            this.si = FieldUtil.getSortedSetDocValues(this.fcontext.qcontext, this.sf, null);
            if (this.si instanceof MultiDocValues.MultiSortedSetDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedSetDocValues)this.si).mapping;
            }
        } else {
            SortedDocValues single = FieldUtil.getSortedDocValues(this.fcontext.qcontext, this.sf, null);
            this.si = DocValues.singleton((SortedDocValues)single);
            if (single instanceof MultiDocValues.MultiSortedDocValues) {
                this.ordinalMap = ((MultiDocValues.MultiSortedDocValues)single).mapping;
            }
        }
        if (this.si.getValueCount() >= Integer.MAX_VALUE) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field has too many unique values. field=" + this.sf + " nterms= " + this.si.getValueCount());
        }
        if (this.prefixRef != null) {
            this.startTermIndex = (int)this.si.lookupTerm(this.prefixRef.get());
            if (this.startTermIndex < 0) {
                this.startTermIndex = -this.startTermIndex - 1;
            }
            this.prefixRef.append(UnicodeUtil.BIG_TERM);
            this.endTermIndex = (int)this.si.lookupTerm(this.prefixRef.get());
            assert (this.endTermIndex < 0);
            this.endTermIndex = -this.endTermIndex - 1;
        } else {
            this.startTermIndex = 0;
            this.endTermIndex = (int)this.si.getValueCount();
        }
        this.startTermIndex = this.startTermIndex == 0 && ((FacetField)this.freq).missing ? -1 : this.startTermIndex;
        this.nTerms = this.endTermIndex - this.startTermIndex;
    }

    @Override
    protected void collectDocs() throws IOException {
        if (this.nTerms <= 0 || this.fcontext.base.size() < this.effectiveMincount) {
            return;
        }
        List leaves = this.fcontext.searcher.getIndexReader().leaves();
        Filter filter = this.fcontext.base.getTopFilter();
        for (int subIdx = 0; subIdx < leaves.size(); ++subIdx) {
            LongValues toGlobal;
            LeafReaderContext subCtx = (LeafReaderContext)leaves.get(subIdx);
            this.setNextReader(subCtx);
            DocIdSet dis = filter.getDocIdSet(subCtx, null);
            DocIdSetIterator disi = dis.iterator();
            SortedDocValues singleDv = null;
            SortedSetDocValues multiDv = null;
            if (this.multiValuedField) {
                multiDv = subCtx.reader().getSortedSetDocValues(this.sf.getName());
                if (multiDv == null) {
                    multiDv = DocValues.emptySortedSet();
                }
                if (unwrap_singleValued_multiDv) {
                    singleDv = DocValues.unwrapSingleton((SortedSetDocValues)multiDv);
                }
            } else {
                singleDv = subCtx.reader().getSortedDocValues(this.sf.getName());
                if (singleDv == null) {
                    singleDv = DocValues.emptySorted();
                }
            }
            LongValues longValues = toGlobal = this.ordinalMap == null ? null : this.ordinalMap.getGlobalOrds(subIdx);
            if (singleDv != null) {
                this.collectDocs(singleDv, disi, toGlobal);
                continue;
            }
            this.collectDocs(multiDv, disi, toGlobal);
        }
    }

    protected void collectDocs(SortedDocValues singleDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        int doc;
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            int segOrd = singleDv.getOrd(doc);
            this.collect(doc, segOrd, toGlobal);
        }
    }

    protected void collectDocs(SortedSetDocValues multiDv, DocIdSetIterator disi, LongValues toGlobal) throws IOException {
        int doc;
        while ((doc = disi.nextDoc()) != Integer.MAX_VALUE) {
            multiDv.setDocument(doc);
            int segOrd = (int)multiDv.nextOrd();
            this.collect(doc, segOrd, toGlobal);
            if (segOrd < 0) continue;
            while ((segOrd = (int)multiDv.nextOrd()) >= 0) {
                this.collect(doc, segOrd, toGlobal);
            }
        }
    }

    private void collect(int doc, int segOrd, LongValues toGlobal) throws IOException {
        int ord = toGlobal != null && segOrd >= 0 ? (int)toGlobal.get(segOrd) : segOrd;
        int arrIdx = ord - this.startTermIndex;
        if (arrIdx >= 0 && arrIdx < this.nTerms) {
            this.countAcc.incrementCount(arrIdx, 1);
            this.collect(doc, arrIdx);
            if (this.allBucketsSlot >= 0 && ord >= 0) {
                this.countAcc.incrementCount(this.allBucketsSlot, 1);
                this.collect(doc, this.allBucketsSlot);
            }
        }
    }
}

