/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetDoubleMerger;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.MaxSlotAcc;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;

public class MaxAgg
extends SimpleAggValueSource {
    public MaxAgg(ValueSource vs) {
        super("max", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, int numDocs, int numSlots) throws IOException {
        return new MaxSlotAcc(this.getArg(), fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new Merger();
    }

    private static class Merger
    extends FacetDoubleMerger {
        double val = Double.NaN;

        private Merger() {
        }

        @Override
        public void merge(Object facetResult, FacetMerger.Context mcontext) {
            double result = ((Number)facetResult).doubleValue();
            if (result > this.val || Double.isNaN(this.val)) {
                this.val = result;
            }
        }

        @Override
        protected double getDouble() {
            return this.val;
        }
    }
}

