/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.Krb5HttpClientConfigurer;
import org.apache.solr.common.SolrException;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.KerberosFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosPlugin
extends AuthenticationPlugin {
    static final Logger log = LoggerFactory.getLogger(KerberosPlugin.class);
    HttpClientConfigurer kerberosConfigurer = new Krb5HttpClientConfigurer();
    Filter kerberosFilter = new KerberosFilter();
    final String NAME_RULES_PARAM = "solr.kerberos.name.rules";
    final String COOKIE_DOMAIN_PARAM = "solr.kerberos.cookie.domain";
    final String COOKIE_PATH_PARAM = "solr.kerberos.cookie.path";
    final String PRINCIPAL_PARAM = "solr.kerberos.principal";
    final String KEYTAB_PARAM = "solr.kerberos.keytab";
    final String TOKEN_VALID_PARAM = "solr.kerberos.token.valid";
    protected static ServletContext noContext = new ServletContext(){

        public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        }

        public boolean setInitParameter(String name, String value) {
            return false;
        }

        public void setAttribute(String name, Object object) {
        }

        public void removeAttribute(String name) {
        }

        public void log(String message, Throwable throwable) {
        }

        public void log(Exception exception, String msg) {
        }

        public void log(String msg) {
        }

        public String getVirtualServerName() {
            return null;
        }

        public SessionCookieConfig getSessionCookieConfig() {
            return null;
        }

        public Enumeration<Servlet> getServlets() {
            return null;
        }

        public Map<String, ? extends ServletRegistration> getServletRegistrations() {
            return null;
        }

        public ServletRegistration getServletRegistration(String servletName) {
            return null;
        }

        public Enumeration<String> getServletNames() {
            return null;
        }

        public String getServletContextName() {
            return null;
        }

        public Servlet getServlet(String name) throws ServletException {
            return null;
        }

        public String getServerInfo() {
            return null;
        }

        public Set<String> getResourcePaths(String path) {
            return null;
        }

        public InputStream getResourceAsStream(String path) {
            return null;
        }

        public URL getResource(String path) throws MalformedURLException {
            return null;
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return null;
        }

        public String getRealPath(String path) {
            return null;
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return null;
        }

        public int getMinorVersion() {
            return 0;
        }

        public String getMimeType(String file) {
            return null;
        }

        public int getMajorVersion() {
            return 0;
        }

        public JspConfigDescriptor getJspConfigDescriptor() {
            return null;
        }

        public Enumeration<String> getInitParameterNames() {
            return null;
        }

        public String getInitParameter(String name) {
            return null;
        }

        public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
            return null;
        }

        public FilterRegistration getFilterRegistration(String filterName) {
            return null;
        }

        public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
            return null;
        }

        public int getEffectiveMinorVersion() {
            return 0;
        }

        public int getEffectiveMajorVersion() {
            return 0;
        }

        public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public ServletContext getContext(String uripath) {
            return null;
        }

        public ClassLoader getClassLoader() {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return null;
        }

        public Object getAttribute(String name) {
            return null;
        }

        public void declareRoles(String ... roleNames) {
        }

        public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
            return null;
        }

        public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
            return null;
        }

        public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
            return null;
        }

        public ServletRegistration.Dynamic addServlet(String servletName, String className) {
            return null;
        }

        public void addListener(Class<? extends EventListener> listenerClass) {
        }

        public <T extends EventListener> void addListener(T t) {
        }

        public void addListener(String className) {
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
            return null;
        }

        public FilterRegistration.Dynamic addFilter(String filterName, String className) {
            return null;
        }
    };

    @Override
    public void init(Map<String, Object> pluginConfig) {
        try {
            final HashMap<String, String> params = new HashMap<String, String>();
            params.put("type", "kerberos");
            this.putParam(params, "kerberos.name.rules", "solr.kerberos.name.rules", "DEFAULT");
            this.putParam(params, "token.valid", "solr.kerberos.token.valid", "30");
            this.putParam(params, "cookie.domain", "solr.kerberos.cookie.domain", null);
            this.putParam(params, "cookie.path", "solr.kerberos.cookie.path", "/");
            this.putParam(params, "kerberos.principal", "solr.kerberos.principal", null);
            this.putParam(params, "kerberos.keytab", "solr.kerberos.keytab", null);
            log.info("Params: " + params);
            FilterConfig conf = new FilterConfig(){

                public ServletContext getServletContext() {
                    return noContext;
                }

                public Enumeration<String> getInitParameterNames() {
                    return new IteratorEnumeration(params.keySet().iterator());
                }

                public String getInitParameter(String param) {
                    return (String)params.get(param);
                }

                public String getFilterName() {
                    return "KerberosFilter";
                }
            };
            this.kerberosFilter.init(conf);
        }
        catch (ServletException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing kerberos authentication plugin: " + (Object)((Object)e));
        }
    }

    private void putParam(Map<String, String> params, String internalParamName, String externalParamName, String defaultValue) {
        String value = System.getProperty(externalParamName, defaultValue);
        if (value == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter '" + externalParamName + "'.");
        }
        params.put(internalParamName, value);
    }

    @Override
    public void doAuthenticate(ServletRequest req, ServletResponse rsp, FilterChain chain) throws Exception {
        log.debug("Request to authenticate using kerberos: " + req);
        this.kerberosFilter.doFilter(req, rsp, chain);
    }

    @Override
    public HttpClientConfigurer getDefaultConfigurer() {
        return this.kerberosConfigurer;
    }

    @Override
    public void close() {
        this.kerberosFilter.destroy();
    }
}

