/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrFieldSource;
import org.apache.solr.search.QParser;

public class StrField
extends PrimitiveFieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value, float boost) {
        if (field.hasDocValues()) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            fields.add(this.createField(field, value, boost));
            BytesRef bytes = new BytesRef((CharSequence)value.toString());
            if (field.multiValued()) {
                fields.add((IndexableField)new SortedSetDocValuesField(field.getName(), bytes));
            } else {
                fields.add((IndexableField)new SortedDocValuesField(field.getName(), bytes));
            }
            return fields;
        }
        return Collections.singletonList(this.createField(field, value, boost));
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return UninvertingReader.Type.SORTED_SET_BINARY;
        }
        return UninvertingReader.Type.SORTED;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        writer.writeStr(name, f.stringValue(), true);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource(parser);
        return new StrFieldSource(field.getName());
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return term.utf8ToString();
    }

    @Override
    public void checkSchemaField(SchemaField field) {
    }

    @Override
    public Object marshalSortValue(Object value) {
        return StrField.marshalStringSortValue(value);
    }

    @Override
    public Object unmarshalSortValue(Object value) {
        return StrField.unmarshalStringSortValue(value);
    }
}

