/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Collection;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FieldValueMutatingUpdateProcessor
extends FieldMutatingUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(FieldValueMutatingUpdateProcessor.class);
    public static final Object DELETE_VALUE_SINGLETON = new Object(){

        public String toString() {
            return "!!Singleton Object Triggering Value Deletion!!";
        }
    };

    public FieldValueMutatingUpdateProcessor(FieldMutatingUpdateProcessor.FieldNameSelector selector, UpdateRequestProcessor next) {
        super(selector, next);
    }

    protected abstract Object mutateValue(Object var1);

    @Override
    protected final SolrInputField mutate(SolrInputField src) {
        Collection values = src.getValues();
        if (values == null) {
            return src;
        }
        SolrInputField result = new SolrInputField(src.getName());
        for (Object srcVal : values) {
            Object destVal = this.mutateValue(srcVal);
            if (DELETE_VALUE_SINGLETON == destVal) {
                log.debug("removing value from field '{}': {}", (Object)src.getName(), srcVal);
                continue;
            }
            if (destVal != srcVal) {
                log.debug("replace value from field '{}': {} with {}", new Object[]{src.getName(), srcVal, destVal});
            }
            result.addValue(destVal, 1.0f);
        }
        result.setBoost(src.getBoost());
        return 0 == result.getValueCount() ? null : result;
    }
}

