/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.Assign;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.ReplicaMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.RoutingRule;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceMutator {
    private static Logger log = LoggerFactory.getLogger(SliceMutator.class);
    public static final String PREFERRED_LEADER_PROP = "property.preferredleader";
    public static final Set<String> SLICE_UNIQUE_BOOLEAN_PROPERTIES = ImmutableSet.of((Object)"property.preferredleader");
    protected final ZkStateReader zkStateReader;

    public SliceMutator(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
    }

    public ZkWriteCommand addReplica(ClusterState clusterState, ZkNodeProps message) {
        log.info("createReplica() {} ", (Object)message);
        String coll = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String slice = message.getStr("shard");
        DocCollection collection = clusterState.getCollection(coll);
        Slice sl = collection.getSlice(slice);
        if (sl == null) {
            log.error("Invalid Collection/Slice {}/{} ", (Object)coll, (Object)slice);
            return ZkStateWriter.NO_OP;
        }
        String coreNodeName = Assign.assignNode(coll, clusterState);
        Replica replica = new Replica(coreNodeName, ZkNodeProps.makeMap((Object[])new Object[]{"core", message.getStr("core"), "base_url", message.getStr("base_url"), "state", message.getStr("state")}));
        return new ZkWriteCommand(coll, SliceMutator.updateReplica(collection, sl, replica.getName(), replica));
    }

    public ZkWriteCommand removeReplica(ClusterState clusterState, ZkNodeProps message) {
        String cnn = message.getStr("core_node_name");
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollectionOrNull(collection);
        if (coll == null) {
            return new ZkWriteCommand(collection, null);
        }
        LinkedHashMap<String, Slice> newSlices = new LinkedHashMap<String, Slice>();
        boolean lastSlice = false;
        for (Slice slice : coll.getSlices()) {
            Replica replica = slice.getReplica(cnn);
            if (replica != null) {
                Map newReplicas = slice.getReplicasCopy();
                newReplicas.remove(cnn);
                if (newReplicas.size() == 0) {
                    slice = null;
                    lastSlice = true;
                } else {
                    slice = new Slice(slice.getName(), newReplicas, slice.getProperties());
                }
            }
            if (slice == null) continue;
            newSlices.put(slice.getName(), slice);
        }
        if (lastSlice) {
            for (Slice slice : coll.getSlices()) {
                if (slice.getReplicas().size() != 0) continue;
                newSlices.remove(slice.getName());
            }
        }
        if (newSlices.size() == 0) {
            return new ClusterStateMutator(this.zkStateReader).deleteCollection(clusterState, new ZkNodeProps(ZkNodeProps.makeMap((Object[])new Object[]{"name", collection})));
        }
        return new ZkWriteCommand(collection, coll.copyWithSlices(newSlices));
    }

    public ZkWriteCommand setShardLeader(ClusterState clusterState, ZkNodeProps message) {
        StringBuilder sb = new StringBuilder();
        String baseUrl = message.getStr("base_url");
        String coreName = message.getStr("core");
        sb.append(baseUrl);
        if (baseUrl != null && !baseUrl.endsWith("/")) {
            sb.append("/");
        }
        sb.append(coreName == null ? "" : coreName);
        if (!sb.substring(sb.length() - 1).equals("/")) {
            sb.append("/");
        }
        String leaderUrl = sb.length() > 0 ? sb.toString() : null;
        String collectionName = message.getStr("collection");
        String sliceName = message.getStr("shard");
        DocCollection coll = clusterState.getCollectionOrNull(collectionName);
        if (coll == null) {
            log.error("Could not mark shard leader for non existing collection:" + collectionName);
            return ZkStateWriter.NO_OP;
        }
        Map slices = coll.getSlicesMap();
        Slice slice = (Slice)slices.get(sliceName);
        Replica oldLeader = slice.getLeader();
        LinkedHashMap<String, Replica> newReplicas = new LinkedHashMap<String, Replica>();
        for (Replica replica : slice.getReplicas()) {
            String coreURL = ZkCoreNodeProps.getCoreUrl((String)replica.getStr("base_url"), (String)replica.getStr("core"));
            if (replica == oldLeader && !coreURL.equals(leaderUrl)) {
                replica = new ReplicaMutator(this.zkStateReader).unsetLeader(replica);
            } else if (coreURL.equals(leaderUrl)) {
                replica = new ReplicaMutator(this.zkStateReader).setLeader(replica);
            }
            newReplicas.put(replica.getName(), replica);
        }
        Map newSliceProps = slice.shallowCopy();
        newSliceProps.put("replicas", newReplicas);
        slice = new Slice(slice.getName(), newReplicas, slice.getProperties());
        return new ZkWriteCommand(collectionName, CollectionMutator.updateSlice(collectionName, coll, slice));
    }

    public ZkWriteCommand updateShardState(ClusterState clusterState, ZkNodeProps message) {
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        log.info("Update shard state invoked for collection: " + collection + " with message: " + message);
        LinkedHashMap<String, Slice> slicesCopy = new LinkedHashMap<String, Slice>(clusterState.getSlicesMap(collection));
        for (String key : message.keySet()) {
            if ("collection".equals(key) || "operation".equals(key)) continue;
            Slice slice = clusterState.getSlice(collection, key);
            if (slice == null) {
                throw new RuntimeException("Overseer.updateShardState unknown collection: " + collection + " slice: " + key);
            }
            log.info("Update shard state " + key + " to " + message.getStr(key));
            Map props = slice.shallowCopy();
            if (Slice.State.getState((String)((String)props.get("state"))) == Slice.State.RECOVERY && Slice.State.getState((String)message.getStr(key)) == Slice.State.ACTIVE) {
                props.remove("parent");
            }
            props.put("state", message.getStr(key));
            Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
            slicesCopy.put(slice.getName(), newSlice);
        }
        return new ZkWriteCommand(collection, clusterState.getCollection(collection).copyWithSlices(slicesCopy));
    }

    public ZkWriteCommand addRoutingRule(ClusterState clusterState, ZkNodeProps message) {
        HashMap<String, String> map;
        RoutingRule r;
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String shard = message.getStr("shard");
        String routeKey = message.getStr("routeKey");
        String range = message.getStr("range");
        String targetCollection = message.getStr("targetCollection");
        String targetShard = message.getStr("targetShard");
        String expireAt = message.getStr("expireAt");
        Slice slice = clusterState.getSlice(collection, shard);
        if (slice == null) {
            throw new RuntimeException("Overseer.addRoutingRule unknown collection: " + collection + " slice:" + shard);
        }
        HashMap<String, RoutingRule> routingRules = slice.getRoutingRules();
        if (routingRules == null) {
            routingRules = new HashMap<String, RoutingRule>();
        }
        if ((r = (RoutingRule)routingRules.get(routeKey)) == null) {
            map = new HashMap<String, String>();
            map.put("routeRanges", range);
            map.put("targetCollection", targetCollection);
            map.put("expireAt", expireAt);
            RoutingRule rule = new RoutingRule(routeKey, map);
            routingRules.put(routeKey, rule);
        } else {
            map = r.shallowCopy();
            map.put("routeRanges", map.get("routeRanges") + "," + range);
            map.put("expireAt", expireAt);
            routingRules.put(routeKey, new RoutingRule(routeKey, map));
        }
        Map props = slice.shallowCopy();
        props.put("routingRules", routingRules);
        Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
        return new ZkWriteCommand(collection, CollectionMutator.updateSlice(collection, clusterState.getCollection(collection), newSlice));
    }

    public ZkWriteCommand removeRoutingRule(ClusterState clusterState, ZkNodeProps message) {
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkCollectionKeyExistence(message)) {
            return ZkStateWriter.NO_OP;
        }
        String shard = message.getStr("shard");
        String routeKeyStr = message.getStr("routeKey");
        log.info("Overseer.removeRoutingRule invoked for collection: " + collection + " shard: " + shard + " routeKey: " + routeKeyStr);
        Slice slice = clusterState.getSlice(collection, shard);
        if (slice == null) {
            log.warn("Unknown collection: " + collection + " shard: " + shard);
            return ZkStateWriter.NO_OP;
        }
        Map routingRules = slice.getRoutingRules();
        if (routingRules != null) {
            routingRules.remove(routeKeyStr);
            Map props = slice.shallowCopy();
            props.put("routingRules", routingRules);
            Slice newSlice = new Slice(slice.getName(), slice.getReplicasCopy(), props);
            return new ZkWriteCommand(collection, CollectionMutator.updateSlice(collection, clusterState.getCollection(collection), newSlice));
        }
        return ZkStateWriter.NO_OP;
    }

    public static DocCollection updateReplica(DocCollection collection, Slice slice, String coreNodeName, Replica replica) {
        Map copy = slice.getReplicasCopy();
        if (replica == null) {
            copy.remove(coreNodeName);
        } else {
            copy.put(replica.getName(), replica);
        }
        Slice newSlice = new Slice(slice.getName(), copy, slice.getProperties());
        return CollectionMutator.updateSlice(collection.getName(), collection, newSlice);
    }
}

