/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.util.stats.TimerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateWriter {
    private static Logger log = LoggerFactory.getLogger(ZkStateWriter.class);
    public static ZkWriteCommand NO_OP = ZkWriteCommand.noop();
    protected final ZkStateReader reader;
    protected final Overseer.Stats stats;
    protected Map<String, DocCollection> updates = new HashMap<String, DocCollection>();
    protected ClusterState clusterState = null;
    protected boolean isClusterStateModified = false;
    protected long lastUpdatedTime = 0L;
    protected int lastStateFormat = -1;
    protected String lastCollectionName = null;

    public ZkStateWriter(ZkStateReader zkStateReader, Overseer.Stats stats) {
        assert (zkStateReader != null);
        this.reader = zkStateReader;
        this.stats = stats;
    }

    public ClusterState enqueueUpdate(ClusterState prevState, ZkWriteCommand cmd, ZkWriteCallback callback) throws Exception {
        if (cmd == NO_OP) {
            return prevState;
        }
        if (this.maybeFlushBefore(cmd)) {
            prevState = this.clusterState = this.writePendingUpdates();
            if (callback != null) {
                callback.onWrite();
            }
        }
        if (callback != null) {
            callback.onEnqueue();
        }
        if (cmd.collection == null) {
            this.isClusterStateModified = true;
            this.clusterState = prevState.copyWith(cmd.name, null);
            this.updates.put(cmd.name, null);
        } else {
            if (cmd.collection.getStateFormat() > 1) {
                this.updates.put(cmd.name, cmd.collection);
            } else {
                this.isClusterStateModified = true;
            }
            this.clusterState = prevState.copyWith(cmd.name, cmd.collection);
        }
        if (this.maybeFlushAfter(cmd)) {
            ClusterState state = this.writePendingUpdates();
            if (callback != null) {
                callback.onWrite();
            }
            return state;
        }
        return this.clusterState;
    }

    protected boolean maybeFlushBefore(ZkWriteCommand cmd) {
        if (this.lastUpdatedTime == 0L) {
            return false;
        }
        if (cmd.collection == null) {
            return false;
        }
        if (cmd.collection.getStateFormat() != this.lastStateFormat) {
            return true;
        }
        return cmd.collection.getStateFormat() > 1 && !cmd.name.equals(this.lastCollectionName);
    }

    protected boolean maybeFlushAfter(ZkWriteCommand cmd) {
        if (cmd.collection == null) {
            return false;
        }
        this.lastCollectionName = cmd.name;
        this.lastStateFormat = cmd.collection.getStateFormat();
        return System.nanoTime() - this.lastUpdatedTime > TimeUnit.NANOSECONDS.convert(1500L, TimeUnit.MILLISECONDS);
    }

    public boolean hasPendingUpdates() {
        return !this.updates.isEmpty() || this.isClusterStateModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState writePendingUpdates() throws KeeperException, InterruptedException {
        if (!this.hasPendingUpdates()) {
            return this.clusterState;
        }
        TimerContext timerContext = this.stats.time("update_state");
        boolean success = false;
        try {
            if (!this.updates.isEmpty()) {
                for (Map.Entry<String, DocCollection> entry : this.updates.entrySet()) {
                    String name = entry.getKey();
                    String path = ZkStateReader.getCollectionPath((String)name);
                    DocCollection c = entry.getValue();
                    if (c == null) {
                        this.reader.getZkClient().clean("/collections/" + name);
                        continue;
                    }
                    if (c.getStateFormat() > 1) {
                        byte[] data = ZkStateReader.toJSON(Collections.singletonMap(c.getName(), c));
                        if (this.reader.getZkClient().exists(path, true).booleanValue()) {
                            assert (c.getZNodeVersion() >= 0);
                            log.info("going to update_collection {} version: {}", (Object)path, (Object)c.getZNodeVersion());
                            Stat stat = this.reader.getZkClient().setData(path, data, c.getZNodeVersion(), true);
                            DocCollection newCollection = new DocCollection(name, c.getSlicesMap(), c.getProperties(), c.getRouter(), stat.getVersion(), path);
                            this.clusterState = this.clusterState.copyWith(name, newCollection);
                            continue;
                        }
                        log.info("going to create_collection {}", (Object)path);
                        this.reader.getZkClient().create(path, data, CreateMode.PERSISTENT, true);
                        DocCollection newCollection = new DocCollection(name, c.getSlicesMap(), c.getProperties(), c.getRouter(), 0, path);
                        this.clusterState = this.clusterState.copyWith(name, newCollection);
                        this.isClusterStateModified = true;
                        continue;
                    }
                    if (c.getStateFormat() != 1) continue;
                    this.isClusterStateModified = true;
                }
                this.updates.clear();
            }
            if (this.isClusterStateModified) {
                assert (this.clusterState.getZkClusterStateVersion() >= 0);
                this.lastUpdatedTime = System.nanoTime();
                byte[] data = ZkStateReader.toJSON((Object)this.clusterState);
                Stat stat = this.reader.getZkClient().setData("/clusterstate.json", data, this.clusterState.getZkClusterStateVersion().intValue(), true);
                Set collectionNames = this.clusterState.getCollections();
                HashMap<String, DocCollection> collectionStates = new HashMap<String, DocCollection>(collectionNames.size());
                for (String c : collectionNames) {
                    collectionStates.put(c, this.clusterState.getCollection(c));
                }
                this.clusterState = new ClusterState(Integer.valueOf(stat.getVersion()), this.reader.getClusterState().getLiveNodes(), collectionStates);
                this.isClusterStateModified = false;
            }
            success = true;
        }
        finally {
            timerContext.stop();
            if (success) {
                this.stats.success("update_state");
            } else {
                this.stats.error("update_state");
            }
        }
        return this.clusterState;
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public static interface ZkWriteCallback {
        public void onEnqueue() throws Exception;

        public void onWrite() throws Exception;
    }
}

