/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.store.blockcache.BlockCacheKey;
import org.apache.solr.store.blockcache.BlockCacheLocation;
import org.apache.solr.store.blockcache.BlockLocks;
import org.apache.solr.store.blockcache.Metrics;

public class BlockCache {
    public static final int _128M = 0x8000000;
    public static final int _32K = 32768;
    private final ConcurrentMap<BlockCacheKey, BlockCacheLocation> cache;
    private final ByteBuffer[] banks;
    private final BlockLocks[] locks;
    private final AtomicInteger[] lockCounters;
    private final int blockSize;
    private final int numberOfBlocksPerBank;
    private final int maxEntries;
    private final Metrics metrics;

    public BlockCache(Metrics metrics, boolean directAllocation, long totalMemory) {
        this(metrics, directAllocation, totalMemory, 0x8000000);
    }

    public BlockCache(Metrics metrics, boolean directAllocation, long totalMemory, int slabSize) {
        this(metrics, directAllocation, totalMemory, slabSize, 32768);
    }

    public BlockCache(Metrics metrics, boolean directAllocation, long totalMemory, int slabSize, int blockSize) {
        this.metrics = metrics;
        this.numberOfBlocksPerBank = slabSize / blockSize;
        int numberOfBanks = (int)(totalMemory / (long)slabSize);
        this.banks = new ByteBuffer[numberOfBanks];
        this.locks = new BlockLocks[numberOfBanks];
        this.lockCounters = new AtomicInteger[numberOfBanks];
        this.maxEntries = this.numberOfBlocksPerBank * numberOfBanks - 1;
        for (int i = 0; i < numberOfBanks; ++i) {
            this.banks[i] = directAllocation ? ByteBuffer.allocateDirect(this.numberOfBlocksPerBank * blockSize) : ByteBuffer.allocate(this.numberOfBlocksPerBank * blockSize);
            this.locks[i] = new BlockLocks(this.numberOfBlocksPerBank);
            this.lockCounters[i] = new AtomicInteger();
        }
        EvictionListener<BlockCacheKey, BlockCacheLocation> listener = new EvictionListener<BlockCacheKey, BlockCacheLocation>(){

            public void onEviction(BlockCacheKey key, BlockCacheLocation location) {
                BlockCache.this.releaseLocation(location);
            }
        };
        this.cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(this.maxEntries).listener((EvictionListener)listener).build();
        this.blockSize = blockSize;
    }

    public void release(BlockCacheKey key) {
        this.releaseLocation((BlockCacheLocation)this.cache.remove(key));
    }

    private void releaseLocation(BlockCacheLocation location) {
        if (location == null) {
            return;
        }
        int bankId = location.getBankId();
        int block = location.getBlock();
        location.setRemoved(true);
        this.locks[bankId].clear(block);
        this.lockCounters[bankId].decrementAndGet();
        this.metrics.blockCacheEviction.incrementAndGet();
        this.metrics.blockCacheSize.decrementAndGet();
    }

    public boolean store(BlockCacheKey blockCacheKey, int blockOffset, byte[] data, int offset, int length) {
        if (length + blockOffset > this.blockSize) {
            throw new RuntimeException("Buffer size exceeded, expecting max [" + this.blockSize + "] got length [" + length + "] with blockOffset [" + blockOffset + "]");
        }
        BlockCacheLocation location = (BlockCacheLocation)this.cache.get(blockCacheKey);
        boolean newLocation = false;
        if (location == null) {
            newLocation = true;
            location = new BlockCacheLocation();
            if (!this.findEmptyLocation(location)) {
                return false;
            }
        }
        if (location.isRemoved()) {
            return false;
        }
        int bankId = location.getBankId();
        int bankOffset = location.getBlock() * this.blockSize;
        ByteBuffer bank = this.getBank(bankId);
        bank.position(bankOffset + blockOffset);
        bank.put(data, offset, length);
        if (newLocation) {
            this.releaseLocation(this.cache.put(blockCacheKey.clone(), location));
            this.metrics.blockCacheSize.incrementAndGet();
        }
        return true;
    }

    public boolean fetch(BlockCacheKey blockCacheKey, byte[] buffer, int blockOffset, int off, int length) {
        BlockCacheLocation location = (BlockCacheLocation)this.cache.get(blockCacheKey);
        if (location == null) {
            return false;
        }
        if (location.isRemoved()) {
            return false;
        }
        int bankId = location.getBankId();
        int offset = location.getBlock() * this.blockSize;
        location.touch();
        ByteBuffer bank = this.getBank(bankId);
        bank.position(offset + blockOffset);
        bank.get(buffer, off, length);
        return true;
    }

    public boolean fetch(BlockCacheKey blockCacheKey, byte[] buffer) {
        this.checkLength(buffer);
        return this.fetch(blockCacheKey, buffer, 0, 0, this.blockSize);
    }

    private boolean findEmptyLocation(BlockCacheLocation location) {
        for (int j = 0; j < 10; ++j) {
            for (int bankId = 0; bankId < this.banks.length; ++bankId) {
                AtomicInteger bitSetCounter = this.lockCounters[bankId];
                BlockLocks bitSet = this.locks[bankId];
                if (bitSetCounter.get() == this.numberOfBlocksPerBank) continue;
                int bit = bitSet.nextClearBit(0);
                while (bit != -1 && bit < this.numberOfBlocksPerBank) {
                    if (!bitSet.set(bit)) {
                        bit = bitSet.nextClearBit(0);
                        continue;
                    }
                    location.setBankId(bankId);
                    location.setBlock(bit);
                    bitSetCounter.incrementAndGet();
                    return true;
                }
            }
        }
        return false;
    }

    private void checkLength(byte[] buffer) {
        if (buffer.length != this.blockSize) {
            throw new RuntimeException("Buffer wrong size, expecting [" + this.blockSize + "] got [" + buffer.length + "]");
        }
    }

    private ByteBuffer getBank(int bankId) {
        return this.banks[bankId].duplicate();
    }

    public int getSize() {
        return this.cache.size();
    }
}

