/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.PingRequestHandler;
import org.apache.solr.handler.RealTimeGetHandler;
import org.apache.solr.handler.ReplicationHandler;
import org.apache.solr.handler.SchemaHandler;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.handler.admin.LoggingHandler;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.handler.admin.PluginInfoHandler;
import org.apache.solr.handler.admin.PropertiesRequestHandler;
import org.apache.solr.handler.admin.SegmentsInfoRequestHandler;
import org.apache.solr.handler.admin.ShowFileRequestHandler;
import org.apache.solr.handler.admin.SolrInfoMBeanHandler;
import org.apache.solr.handler.admin.SystemInfoHandler;
import org.apache.solr.handler.admin.ThreadDumpHandler;

public class ImplicitPlugins {
    public static List<PluginInfo> getHandlers(SolrCore solrCore) {
        ArrayList<PluginInfo> implicits = new ArrayList<PluginInfo>();
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/update", UpdateRequestHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/update/json", UpdateRequestHandler.class, Collections.singletonMap("update.contentType", "application/json")));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/update/csv", UpdateRequestHandler.class, Collections.singletonMap("update.contentType", "application/csv")));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/update/json/docs", UpdateRequestHandler.class, ZkNodeProps.makeMap((Object[])new Object[]{"update.contentType", "application/json", "json.command", "false"})));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/config", SolrConfigHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/schema", SchemaHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/replication", ReplicationHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/get", RealTimeGetHandler.class, ZkNodeProps.makeMap((Object[])new Object[]{"omitHeader", "true", "wt", "json", "indent", "true"})));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/luke", LukeRequestHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/system", SystemInfoHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/mbeans", SolrInfoMBeanHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/plugins", PluginInfoHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/threads", ThreadDumpHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/properties", PropertiesRequestHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/logging", LoggingHandler.class, null));
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/file", ShowFileRequestHandler.class, null));
        PluginInfo ping = ImplicitPlugins.getReqHandlerInfo("/admin/ping", PingRequestHandler.class, null);
        ping.initArgs.add("invariants", (Object)new NamedList(ZkNodeProps.makeMap((Object[])new Object[]{"echoParams", "all", "q", "solrpingquery"})));
        implicits.add(ping);
        implicits.add(ImplicitPlugins.getReqHandlerInfo("/admin/segments", SegmentsInfoRequestHandler.class, null));
        return implicits;
    }

    public static PluginInfo getReqHandlerInfo(String name, Class clz, Map defaults) {
        if (defaults == null) {
            defaults = Collections.emptyMap();
        }
        Map m = ZkNodeProps.makeMap((Object[])new Object[]{"name", name, "class", clz.getName()});
        return new PluginInfo("requestHandler", m, new NamedList(Collections.singletonMap("defaults", new NamedList(defaults))), null);
    }
}

