/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentsInfoRequestHandler
extends RequestHandlerBase {
    private static Logger log = LoggerFactory.getLogger(SegmentsInfoRequestHandler.class);

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        log.info("Handling data for segmets info query searcher");
        rsp.add("segments", this.getSegmentsInfo(req, rsp));
        rsp.setHttpCaching(false);
    }

    private SimpleOrderedMap<Object> getSegmentsInfo(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrIndexSearcher searcher = req.getSearcher();
        SegmentInfos infos = SegmentInfos.readLatestCommit((Directory)searcher.getIndexReader().directory());
        List<String> mergeCandidates = this.getMergeCandidatesNames(req, infos);
        SimpleOrderedMap segmentInfos = new SimpleOrderedMap();
        SimpleOrderedMap<Object> segmentInfo = null;
        for (SegmentCommitInfo segmentCommitInfo : infos) {
            segmentInfo = this.getSegmentInfo(segmentCommitInfo);
            if (mergeCandidates.contains(segmentCommitInfo.info.name)) {
                segmentInfo.add("mergeCandidate", (Object)true);
            }
            segmentInfos.add((String)segmentInfo.get("name"), segmentInfo);
        }
        return segmentInfos;
    }

    private SimpleOrderedMap<Object> getSegmentInfo(SegmentCommitInfo segmentCommitInfo) throws IOException {
        SimpleOrderedMap segmentInfoMap = new SimpleOrderedMap();
        segmentInfoMap.add("name", (Object)segmentCommitInfo.info.name);
        segmentInfoMap.add("delCount", (Object)segmentCommitInfo.getDelCount());
        segmentInfoMap.add("sizeInBytes", (Object)segmentCommitInfo.sizeInBytes());
        segmentInfoMap.add("size", (Object)segmentCommitInfo.info.maxDoc());
        Long timestamp = Long.parseLong((String)segmentCommitInfo.info.getDiagnostics().get("timestamp"));
        segmentInfoMap.add("age", (Object)new Date(timestamp));
        segmentInfoMap.add("source", segmentCommitInfo.info.getDiagnostics().get("source"));
        return segmentInfoMap;
    }

    private List<String> getMergeCandidatesNames(SolrQueryRequest req, SegmentInfos infos) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        IndexWriter indexWriter = this.getIndexWriter(req);
        MergePolicy mp = indexWriter.getConfig().getMergePolicy();
        MergePolicy.MergeSpecification findMerges = mp.findMerges(MergeTrigger.EXPLICIT, infos, indexWriter);
        if (findMerges != null && findMerges.merges != null && findMerges.merges.size() > 0) {
            for (MergePolicy.OneMerge merge : findMerges.merges) {
                for (SegmentCommitInfo mergeSegmentInfo : merge.segments) {
                    result.add(mergeSegmentInfo.info.name);
                }
            }
        }
        return result;
    }

    private IndexWriter getIndexWriter(SolrQueryRequest req) throws IOException {
        return req.getCore().getSolrCoreState().getIndexWriter(req.getCore()).get();
    }

    @Override
    public String getDescription() {
        return "Lucene segments info.";
    }
}

