/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.rest.RestManager;
import org.apache.solr.rest.schema.CopyFieldCollectionResource;
import org.apache.solr.rest.schema.DynamicFieldCollectionResource;
import org.apache.solr.rest.schema.DynamicFieldResource;
import org.apache.solr.rest.schema.FieldCollectionResource;
import org.apache.solr.rest.schema.FieldResource;
import org.apache.solr.rest.schema.FieldTypeCollectionResource;
import org.apache.solr.rest.schema.FieldTypeResource;
import org.restlet.Application;
import org.restlet.Restlet;
import org.restlet.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrSchemaRestApi
extends Application {
    public static final Logger log = LoggerFactory.getLogger(SolrSchemaRestApi.class);
    public static final String FIELDS_PATH = "/fields";
    public static final String DYNAMIC_FIELDS = "dynamicFields".toLowerCase(Locale.ROOT);
    public static final String DYNAMIC_FIELDS_PATH = "/" + DYNAMIC_FIELDS;
    public static final String FIELDTYPES = "fieldTypes".toLowerCase(Locale.ROOT);
    public static final String FIELDTYPES_PATH = "/" + FIELDTYPES;
    public static final String NAME_SEGMENT = "/{" + "name".toLowerCase(Locale.ROOT) + "}";
    public static final String COPY_FIELDS = "copyFields".toLowerCase(Locale.ROOT);
    public static final String COPY_FIELDS_PATH = "/" + COPY_FIELDS;
    private Router router = new Router(this.getContext());

    public static Set<String> getReservedEndpoints() {
        HashSet<String> reservedEndpoints = new HashSet<String>();
        reservedEndpoints.add("/schema/fields");
        reservedEndpoints.add("/schema" + DYNAMIC_FIELDS_PATH);
        reservedEndpoints.add("/schema" + FIELDTYPES_PATH);
        reservedEndpoints.add("/schema" + COPY_FIELDS_PATH);
        return Collections.unmodifiableSet(reservedEndpoints);
    }

    public void stop() throws Exception {
        if (null != this.router) {
            this.router.stop();
        }
    }

    public synchronized Restlet createInboundRoot() {
        log.info("createInboundRoot started for /schema");
        this.router.attach(FIELDS_PATH, FieldCollectionResource.class);
        this.router.attach("/fields/", FieldCollectionResource.class);
        this.router.attach(FIELDS_PATH + NAME_SEGMENT, FieldResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH, DynamicFieldCollectionResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH + "/", DynamicFieldCollectionResource.class);
        this.router.attach(DYNAMIC_FIELDS_PATH + NAME_SEGMENT, DynamicFieldResource.class);
        this.router.attach(FIELDTYPES_PATH, FieldTypeCollectionResource.class);
        this.router.attach(FIELDTYPES_PATH + "/", FieldTypeCollectionResource.class);
        this.router.attach(FIELDTYPES_PATH + NAME_SEGMENT, FieldTypeResource.class);
        this.router.attach(COPY_FIELDS_PATH, CopyFieldCollectionResource.class);
        this.router.attach(COPY_FIELDS_PATH + "/", CopyFieldCollectionResource.class);
        this.router.attachDefault(RestManager.ManagedEndpoint.class);
        RestManager.getRestManager(SolrRequestInfo.getRequestInfo()).attachManagedResources("/schema", this.router);
        log.info("createInboundRoot complete for /schema");
        return this.router;
    }
}

