/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.spatial4j.core.shape.Shape;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.prefix.NumberRangePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.DateRangePrefixTree;
import org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.schema.AbstractSpatialPrefixTreeFieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SyntaxError;

public class DateRangeField
extends AbstractSpatialPrefixTreeFieldType<NumberRangePrefixTreeStrategy> {
    private static final String OP_PARAM = "op";
    private static final DateRangePrefixTree tree = DateRangePrefixTree.INSTANCE;
    private static final TrieDateField trieDateField = new TrieDateField();

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
    }

    @Override
    protected NumberRangePrefixTreeStrategy newPrefixTreeStrategy(String fieldName) {
        return new NumberRangePrefixTreeStrategy((NumberRangePrefixTree)tree, fieldName);
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object val, float boost) {
        if (val instanceof Date || val instanceof Calendar) {
            val = tree.toUnitShape(val);
        }
        return super.createFields(field, val, boost);
    }

    @Override
    protected String getStoredValue(Shape shape, String shapeStr) {
        NumberRangePrefixTree.UnitNRShape unitShape;
        if (shape instanceof NumberRangePrefixTree.UnitNRShape && (unitShape = (NumberRangePrefixTree.UnitNRShape)shape).getLevel() == tree.getMaxLevels()) {
            Date date = tree.toCalendar(unitShape).getTime();
            return TrieDateField.formatExternal(date);
        }
        return shapeStr == null ? shape.toString() : shapeStr;
    }

    protected NumberRangePrefixTree.NRShape parseShape(String str) {
        if (str.contains(" TO ")) {
            try {
                return tree.parseShape(str);
            }
            catch (ParseException e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Couldn't parse date because: " + e.getMessage(), (Throwable)e);
            }
        }
        return tree.toShape(this.parseCalendar(str));
    }

    private Calendar parseCalendar(String str) {
        if (str.startsWith("NOW") || str.lastIndexOf(90) >= 0) {
            Date date = trieDateField.parseMath(null, str);
            Calendar cal = tree.newCal();
            cal.setTime(date);
            return cal;
        }
        try {
            return tree.parseCalendar(str);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Couldn't parse date because: " + e.getMessage(), (Throwable)e);
        }
    }

    public Date parseMath(Date now, String rawval) {
        return trieDateField.parseMath(now, rawval);
    }

    @Override
    protected String shapeToString(Shape shape) {
        NumberRangePrefixTree.UnitNRShape unitShape;
        if (shape instanceof NumberRangePrefixTree.UnitNRShape && (unitShape = (NumberRangePrefixTree.UnitNRShape)shape).getLevel() == tree.getMaxLevels()) {
            Date date = tree.toCalendar(unitShape).getTime();
            return TrieDateField.formatExternal(date);
        }
        return shape.toString();
    }

    @Override
    protected SpatialArgs parseSpatialArgs(QParser parser, String externalVal) {
        String opStr;
        NumberRangePrefixTree.NRShape shape = this.parseShape(externalVal);
        SolrParams localParams = parser.getLocalParams();
        SpatialOperation op = SpatialOperation.Intersects;
        if (localParams != null && (opStr = localParams.get(OP_PARAM)) != null) {
            op = SpatialOperation.get((String)opStr);
        }
        return new SpatialArgs(op, (Shape)shape);
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String startStr, String endStr, boolean minInclusive, boolean maxInclusive) {
        Calendar endCal;
        Calendar startCal;
        if (parser == null) {
            SolrRequestInfo requestInfo = SolrRequestInfo.getRequestInfo();
            parser = new QParser("", null, requestInfo.getReq().getParams(), requestInfo.getReq()){

                @Override
                public Query parse() throws SyntaxError {
                    throw new IllegalStateException();
                }
            };
        }
        if (startStr == null) {
            startCal = tree.newCal();
        } else {
            startCal = this.parseCalendar(startStr);
            if (!minInclusive) {
                startCal.add(14, 1);
            }
        }
        if (endStr == null) {
            endCal = tree.newCal();
        } else {
            endCal = this.parseCalendar(endStr);
            if (!maxInclusive) {
                endCal.add(14, -1);
            }
        }
        NumberRangePrefixTree.NRShape shape = tree.toRangeShape(tree.toShape(startCal), tree.toShape(endCal));
        SpatialArgs spatialArgs = new SpatialArgs(SpatialOperation.Intersects, (Shape)shape);
        return this.getQueryFromSpatialArgs(parser, field, spatialArgs);
    }
}

