/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.slave;

import com.carrotsearch.ant.tasks.junit4.events.Serializer;
import com.carrotsearch.ant.tasks.junit4.events.SuiteCompletedEvent;
import com.carrotsearch.ant.tasks.junit4.events.SuiteFailureEvent;
import com.carrotsearch.ant.tasks.junit4.events.SuiteStartedEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestFailureEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestFinishedEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestIgnoredAssumptionEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestIgnoredEvent;
import com.carrotsearch.ant.tasks.junit4.events.TestStartedEvent;
import java.io.IOException;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class RunListenerEmitter
extends RunListener {
    private final Serializer serializer;
    private Description suiteDescription;
    private long start;
    private long suiteStart;
    private Failure suiteAssumption;

    public RunListenerEmitter(Serializer serializer) {
        this.serializer = serializer;
    }

    public void testRunStarted(Description description) {
        this.suiteDescription = description;
        this.suiteStart = System.currentTimeMillis();
        this.suiteAssumption = null;
        this.serializer.serialize(new SuiteStartedEvent(description, this.suiteStart));
    }

    public void testStarted(Description description) {
        this.serializer.serialize(new TestStartedEvent(description));
        this.start = System.currentTimeMillis();
    }

    public void testFailure(Failure failure) {
        if (this.suiteDescription.equals((Object)failure.getDescription())) {
            this.serializer.serialize(new SuiteFailureEvent(failure));
        } else {
            this.serializer.serialize(new TestFailureEvent(failure));
        }
    }

    public void testAssumptionFailure(Failure failure) {
        try {
            if (this.suiteDescription != null && this.suiteDescription.equals((Object)failure.getDescription())) {
                this.suiteAssumption = failure;
            }
            this.serializer.serialize(new TestIgnoredAssumptionEvent(failure));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void testIgnored(Description description) {
        if (!this.suiteDescription.equals((Object)description)) {
            String string;
            String string2 = "Unknown reason for ignore status.";
            if (this.suiteAssumption != null) {
                string = this.suiteAssumption.getMessage();
                string2 = string != null ? string : "Class assumption-ignored.";
            }
            try {
                string = (Ignore)description.getAnnotation(Ignore.class);
                string = (Ignore)description.getAnnotation(Ignore.class);
                if (string != null) {
                    string2 = "Annotated @Ignore(" + string.value() + ")";
                } else {
                    string = description.getTestClass().getAnnotation(Ignore.class);
                    if (string != null) {
                        string2 = "Class annotated @Ignore(" + string.value() + ")";
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.serializer.serialize(new TestIgnoredEvent(description, string2));
        }
    }

    public void testFinished(Description description) {
        long l = System.currentTimeMillis() - this.start;
        this.serializer.serialize(new TestFinishedEvent(description, (int)l, this.start));
    }

    public void testRunFinished(Result result) {
        this.suiteAssumption = null;
        long l = System.currentTimeMillis() - this.suiteStart;
        this.serializer.serialize(new SuiteCompletedEvent(this.suiteDescription, this.suiteStart, l));
    }
}

