/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableBiMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableCollection;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableEnumMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap$Builder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry$TerminalEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapKeySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapValues;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ImmutableMap
implements Serializable,
Map {
    private static final Map.Entry[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet entrySet;
    private transient ImmutableSet keySet;
    private transient ImmutableCollection values;

    public static ImmutableMap of() {
        return ImmutableBiMap.of();
    }

    public static ImmutableMap of(Object object, Object object2) {
        return ImmutableBiMap.of(object, object2);
    }

    static ImmutableMapEntry$TerminalEntry entryOf(Object object, Object object2) {
        CollectPreconditions.checkEntryNotNull(object, object2);
        return new ImmutableMapEntry$TerminalEntry(object, object2);
    }

    public static ImmutableMap$Builder builder() {
        return new ImmutableMap$Builder();
    }

    static void checkNoConflict(boolean bl, String string, Map.Entry entry, Map.Entry entry2) {
        if (!bl) {
            throw new IllegalArgumentException("Multiple entries with same " + string + ": " + entry + " and " + entry2);
        }
    }

    public static ImmutableMap copyOf(Map map) {
        Map.Entry[] entryArray;
        if (map instanceof ImmutableMap && !(map instanceof ImmutableSortedMap)) {
            entryArray = (Map.Entry[])map;
            if (!entryArray.isPartialView()) {
                return entryArray;
            }
        } else if (map instanceof EnumMap) {
            return ImmutableMap.copyOfEnumMapUnsafe(map);
        }
        entryArray = map.entrySet().toArray(EMPTY_ENTRY_ARRAY);
        switch (entryArray.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                Map.Entry entry = entryArray[0];
                return ImmutableMap.of(entry.getKey(), entry.getValue());
            }
        }
        return new RegularImmutableMap(entryArray);
    }

    private static ImmutableMap copyOfEnumMapUnsafe(Map map) {
        return ImmutableMap.copyOfEnumMap((EnumMap)map);
    }

    private static ImmutableMap copyOfEnumMap(Map map) {
        EnumMap enumMap = new EnumMap(map);
        for (Map.Entry entry : enumMap.entrySet()) {
            CollectPreconditions.checkEntryNotNull(entry.getKey(), entry.getValue());
        }
        return ImmutableEnumMap.asImmutable(enumMap);
    }

    ImmutableMap() {
    }

    @Deprecated
    public final Object put(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Object remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.get(object) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return this.values().contains(object);
    }

    public abstract Object get(@Nullable Object var1);

    public ImmutableSet entrySet() {
        ImmutableSet immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = this.createEntrySet()) : immutableSet;
    }

    abstract ImmutableSet createEntrySet();

    public ImmutableSet keySet() {
        ImmutableSet immutableSet = this.keySet;
        return immutableSet == null ? (this.keySet = this.createKeySet()) : immutableSet;
    }

    ImmutableSet createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    public ImmutableCollection values() {
        ImmutableCollection immutableCollection = this.values;
        return immutableCollection == null ? (this.values = new ImmutableMapValues(this)) : immutableCollection;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Maps.equalsImpl(this, object);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }
}

