/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Default;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Namespace;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.NamespaceList;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Order;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Root;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Commit;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Complete;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.ConstructorScanner;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Creator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Decorator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.NamespaceDecorator;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Persist;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Replace;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Resolve;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Validate;
import java.lang.reflect.Method;
import java.util.Map;

class ClassScanner {
    private NamespaceDecorator decorator;
    private ConstructorScanner scanner;
    private Namespace namespace;
    private Function commit;
    private Function validate;
    private Function persist;
    private Function complete;
    private Function replace;
    private Function resolve;
    private Default access;
    private Order order;
    private Root root;

    public ClassScanner(Class clazz) {
        this.scanner = new ConstructorScanner(clazz);
        this.decorator = new NamespaceDecorator();
        this.scan(clazz);
    }

    public Creator getCreator() {
        return this.scanner.getCreator();
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public Default getDefault() {
        return this.access;
    }

    public Order getOrder() {
        return this.order;
    }

    public Root getRoot() {
        return this.root;
    }

    public Function getCommit() {
        return this.commit;
    }

    public Function getValidate() {
        return this.validate;
    }

    public Function getPersist() {
        return this.persist;
    }

    public Function getComplete() {
        return this.complete;
    }

    public Function getReplace() {
        return this.replace;
    }

    public Function getResolve() {
        return this.resolve;
    }

    public boolean isStrict() {
        if (this.root != null) {
            return this.root.strict();
        }
        return true;
    }

    private void scan(Class clazz) {
        Class clazz2 = clazz;
        while (clazz != null) {
            this.global(clazz);
            this.scope(clazz);
            this.scan(clazz2, clazz);
            clazz = clazz.getSuperclass();
        }
        this.process(clazz2);
    }

    private void global(Class clazz) {
        if (this.namespace == null) {
            this.namespace(clazz);
        }
        if (this.root == null) {
            this.root(clazz);
        }
        if (this.order == null) {
            this.order(clazz);
        }
        if (this.access == null) {
            this.access(clazz);
        }
    }

    private void scan(Class clazz, Class clazz2) {
        Method[] methodArray = clazz2.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            this.scan(methodArray[i]);
        }
    }

    private void root(Class clazz) {
        if (clazz.isAnnotationPresent(Root.class)) {
            this.root = clazz.getAnnotation(Root.class);
        }
    }

    private void order(Class clazz) {
        if (clazz.isAnnotationPresent(Order.class)) {
            this.order = clazz.getAnnotation(Order.class);
        }
    }

    private void access(Class clazz) {
        if (clazz.isAnnotationPresent(Default.class)) {
            this.access = clazz.getAnnotation(Default.class);
        }
    }

    private void namespace(Class clazz) {
        if (clazz.isAnnotationPresent(Namespace.class)) {
            this.namespace = clazz.getAnnotation(Namespace.class);
            if (this.namespace != null) {
                this.decorator.add(this.namespace);
            }
        }
    }

    private void scope(Class clazz) {
        if (clazz.isAnnotationPresent(NamespaceList.class)) {
            Namespace[] namespaceArray;
            NamespaceList namespaceList = clazz.getAnnotation(NamespaceList.class);
            for (Namespace namespace : namespaceArray = namespaceList.value()) {
                this.decorator.add(namespace);
            }
        }
    }

    private void process(Class clazz) {
        if (this.namespace != null) {
            this.decorator.set(this.namespace);
        }
    }

    private void scan(Method method) {
        if (this.commit == null) {
            this.commit(method);
        }
        if (this.validate == null) {
            this.validate(method);
        }
        if (this.persist == null) {
            this.persist(method);
        }
        if (this.complete == null) {
            this.complete(method);
        }
        if (this.replace == null) {
            this.replace(method);
        }
        if (this.resolve == null) {
            this.resolve(method);
        }
    }

    private void replace(Method method) {
        Replace replace = method.getAnnotation(Replace.class);
        if (replace != null) {
            this.replace = this.getFunction(method);
        }
    }

    private void resolve(Method method) {
        Resolve resolve = method.getAnnotation(Resolve.class);
        if (resolve != null) {
            this.resolve = this.getFunction(method);
        }
    }

    private void commit(Method method) {
        Commit commit = method.getAnnotation(Commit.class);
        if (commit != null) {
            this.commit = this.getFunction(method);
        }
    }

    private void validate(Method method) {
        Validate validate = method.getAnnotation(Validate.class);
        if (validate != null) {
            this.validate = this.getFunction(method);
        }
    }

    private void persist(Method method) {
        Persist persist = method.getAnnotation(Persist.class);
        if (persist != null) {
            this.persist = this.getFunction(method);
        }
    }

    private void complete(Method method) {
        Complete complete = method.getAnnotation(Complete.class);
        if (complete != null) {
            this.complete = this.getFunction(method);
        }
    }

    private Function getFunction(Method method) {
        boolean bl = this.isContextual(method);
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return new Function(method, bl);
    }

    private boolean isContextual(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1) {
            return Map.class.equals(classArray[0]);
        }
        return false;
    }
}

