/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Path;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.Root;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Contact;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Expression;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Label;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.PathParser;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.core.Reflector;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.strategy.Type;
import java.lang.annotation.Annotation;

class Introspector {
    private Annotation marker;
    private Contact contact;
    private Label label;

    public Introspector(Contact contact, Label label) {
        this.marker = contact.getAnnotation();
        this.contact = contact;
        this.label = label;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Type getDependent() {
        return this.label.getDependent();
    }

    public String getEntry() {
        String string;
        Type type = this.getDependent();
        Class<?> clazz = type.getType();
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if ((string = this.getName(clazz)) == null) {
            return null;
        }
        return string.intern();
    }

    private String getName(Class clazz) {
        String string = this.getRoot(clazz);
        if (string != null) {
            return string;
        }
        string = clazz.getSimpleName();
        return Reflector.getName(string);
    }

    private String getRoot(Class clazz) {
        Class clazz2 = clazz;
        while (clazz != null) {
            String string = this.getRoot(clazz2, clazz);
            if (string != null) {
                return string;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    private String getRoot(Class clazz, Class clazz2) {
        String string = clazz2.getSimpleName();
        if (clazz2.isAnnotationPresent(Root.class)) {
            Root root = clazz2.getAnnotation(Root.class);
            String string2 = root.name();
            if (!this.isEmpty(string2)) {
                return string2;
            }
            return Reflector.getName(string);
        }
        return null;
    }

    public String getName() {
        String string = this.label.getEntry();
        if (!this.label.isInline()) {
            string = this.getDefault();
        }
        return string.intern();
    }

    private String getDefault() {
        String string = this.label.getOverride();
        if (!this.isEmpty(string)) {
            return string;
        }
        return this.contact.getName();
    }

    public Expression getExpression() {
        String string = this.getPath();
        if (string != null) {
            return new PathParser(this.contact, string);
        }
        return new PathParser(this.contact, ".");
    }

    public String getPath() {
        Path path = (Path)this.contact.getAnnotation(Path.class);
        if (path == null) {
            return null;
        }
        return path.value();
    }

    public boolean isEmpty(String string) {
        if (string != null) {
            return string.length() == 0;
        }
        return true;
    }

    public String toString() {
        return String.format("%s on %s", this.marker, this.contact);
    }
}

