/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.tools;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.io.Closer;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.Gson;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.events.EventType;
import com.carrotsearch.ant.tasks.junit4.events.IStreamEvent;
import com.carrotsearch.ant.tasks.junit4.events.Serializer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;

public class DumpStreamsFromEventStream {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: [input.events]");
            System.exit(1);
            return;
        }
        File file = new File(stringArray[0]);
        Gson gson = Serializer.createGSon(DumpStreamsFromEventStream.class.getClassLoader());
        Closer closer = Closer.create();
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(file.getAbsolutePath() + ".sysout")));
            closer.register(bufferedOutputStream);
            BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(new FileOutputStream(new File(file.getAbsolutePath() + ".syserr")));
            closer.register(bufferedOutputStream2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            closer.register(bufferedInputStream);
            JsonReader jsonReader = new JsonReader(new InputStreamReader((InputStream)bufferedInputStream, Charsets.UTF_8));
            jsonReader.setLenient(true);
            while (true) {
                JsonToken jsonToken;
                if ((jsonToken = jsonReader.peek()) == JsonToken.END_DOCUMENT) {
                    return;
                }
                jsonReader.beginArray();
                EventType eventType = EventType.valueOf(jsonReader.nextString());
                switch (eventType) {
                    case APPEND_STDERR: {
                        ((IStreamEvent)gson.fromJson(jsonReader, (Type)eventType.eventClass)).copyTo(bufferedOutputStream2);
                        break;
                    }
                    case APPEND_STDOUT: {
                        ((IStreamEvent)gson.fromJson(jsonReader, (Type)eventType.eventClass)).copyTo(bufferedOutputStream);
                        break;
                    }
                    default: {
                        jsonReader.skipValue();
                    }
                }
                jsonReader.endArray();
                continue;
                break;
            }
        }
        catch (Throwable throwable) {
            throw closer.rethrow(throwable);
        }
        finally {
            closer.close();
        }
    }
}

