/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Charsets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.Gson;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.GsonBuilder;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.LongSerializationPolicy;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonWriter;
import com.carrotsearch.ant.tasks.junit4.events.IEvent;
import com.carrotsearch.ant.tasks.junit4.events.QuitEvent;
import com.carrotsearch.ant.tasks.junit4.events.Serializer$1;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonAnnotationAdapter;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonByteArrayAdapter;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonClassAdapter;
import com.carrotsearch.ant.tasks.junit4.events.json.JsonDescriptionAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import org.junit.runner.Description;

public class Serializer
implements Closeable {
    private final Object lock = new Object();
    private Writer writer;
    private Gson gson;
    private final ArrayDeque events = new ArrayDeque();
    private volatile Throwable doForcedShutdown;
    private Thread forceCloseDaemon;

    public Serializer(OutputStream outputStream) {
        this.writer = new OutputStreamWriter(outputStream, Charsets.UTF_8);
        this.gson = Serializer.createGSon(Thread.currentThread().getContextClassLoader());
        this.forceCloseDaemon = new Serializer$1(this, "JUnit4-serializer-daemon");
        this.forceCloseDaemon.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer serialize(IEvent iEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer == null) {
                throw new IOException("Serializer already closed.");
            }
            do {
                this.events.addLast(iEvent);
                if (this.events.size() > 1) {
                    return this;
                }
                iEvent = (IEvent)this.events.peekFirst();
                try {
                    JsonWriter jsonWriter = new JsonWriter(this.writer);
                    jsonWriter.setIndent("  ");
                    jsonWriter.beginArray();
                    jsonWriter.value(iEvent.getType().name());
                    this.gson.toJson(iEvent, iEvent.getClass(), jsonWriter);
                    jsonWriter.endArray();
                    this.writer.write("\n\n");
                }
                catch (Throwable throwable) {
                    while (true) {
                        this.doForcedShutdown = throwable;
                        try {
                            this.forceCloseDaemon.join();
                        }
                        catch (Throwable throwable2) {}
                    }
                }
                this.events.removeFirst();
            } while (this.writer != null && !this.events.isEmpty());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializer flush() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                this.writer.flush();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.writer != null) {
                if (this.events.isEmpty()) {
                    this.serialize(new QuitEvent());
                }
                this.writer.close();
                this.writer = null;
            }
            try {
                this.forceCloseDaemon.interrupt();
                this.forceCloseDaemon.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static Gson createGSon(ClassLoader classLoader) {
        return new GsonBuilder().registerTypeAdapter((Type)((Object)byte[].class), new JsonByteArrayAdapter()).registerTypeHierarchyAdapter(Annotation.class, new JsonAnnotationAdapter(classLoader)).registerTypeHierarchyAdapter(Class.class, new JsonClassAdapter(classLoader)).registerTypeAdapter((Type)((Object)Description.class), new JsonDescriptionAdapter()).setLongSerializationPolicy(LongSerializationPolicy.DEFAULT).disableHtmlEscaping().create();
    }

    static /* synthetic */ Throwable access$000(Serializer serializer) {
        return serializer.doForcedShutdown;
    }
}

