/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.JsonSyntaxException;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind.DateTypeAdapter$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind.TypeAdapter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.internal.bind.TypeAdapter$Factory;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonReader;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonToken;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.gson.stream.JsonWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTypeAdapter
extends TypeAdapter {
    public static final TypeAdapter$Factory FACTORY = new DateTypeAdapter$1();
    private final DateFormat enUsFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
    private final DateFormat localFormat = DateFormat.getDateTimeInstance(2, 2);
    private final DateFormat iso8601Format = DateTypeAdapter.buildIso8601Format();

    private static DateFormat buildIso8601Format() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat;
    }

    public Date read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        return this.deserializeToDate(jsonReader.nextString());
    }

    private synchronized Date deserializeToDate(String string) {
        try {
            return this.localFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                return this.enUsFormat.parse(string);
            }
            catch (ParseException parseException2) {
                try {
                    return this.iso8601Format.parse(string);
                }
                catch (ParseException parseException3) {
                    throw new JsonSyntaxException(string, parseException3);
                }
            }
        }
    }

    public synchronized void write(JsonWriter jsonWriter, Date date) {
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        String string = this.enUsFormat.format(date);
        jsonWriter.value(string);
    }
}

