/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform;

import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.DefaultMatcher;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.Matcher;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.Transform;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.TransformCache;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.transform.TransformException;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.util.Cache;
import com.carrotsearch.ant.tasks.junit4.dependencies.org.simpleframework.xml.util.WeakCache;

public class Transformer {
    private final TransformCache cache;
    private final Matcher matcher;
    private final Cache error;

    public Transformer(Matcher matcher) {
        this.matcher = new DefaultMatcher(matcher);
        this.cache = new TransformCache();
        this.error = new WeakCache();
    }

    public Object read(String string, Class clazz) {
        Transform transform = this.lookup(clazz);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", clazz);
        }
        return transform.read(string);
    }

    public String write(Object object, Class clazz) {
        Transform transform = this.lookup(clazz);
        if (transform == null) {
            throw new TransformException("Transform of %s not supported", clazz);
        }
        return transform.write(object);
    }

    public boolean valid(Class clazz) {
        return this.lookup(clazz) != null;
    }

    private Transform lookup(Class clazz) {
        Transform transform = (Transform)this.cache.fetch(clazz);
        if (transform != null) {
            return transform;
        }
        if (this.error.contains(clazz)) {
            return null;
        }
        return this.match(clazz);
    }

    private Transform match(Class clazz) {
        Transform transform = this.matcher.match(clazz);
        if (transform != null) {
            this.cache.cache(clazz, transform);
        } else {
            this.error.cache(clazz, this);
        }
        return transform;
    }
}

