/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FilterExpressionParser {
    static final Node[] EMPTY = new Node[0];
    private Iterator<Node> nodes;
    private Node current;

    Node expression(int rbp) {
        Node n = this.current;
        this.current = this.nodes.next();
        Node left = n.nud();
        while (rbp < this.current.lbp) {
            n = this.current;
            this.current = this.nodes.next();
            left = n.led(left);
        }
        return left;
    }

    public Node parse(String rule) {
        this.nodes = this.tokenize(rule);
        this.current = this.nodes.next();
        if (this.current instanceof EosNode) {
            return new DefaultNode();
        }
        return this.expression(-1);
    }

    private Iterator<Node> tokenize(String rule) {
        Matcher m = Pattern.compile("(?:\\s*)(([^\\s\\(\\)]+)|([\\(\\)]))").matcher(rule);
        ArrayList<Node> tokens = new ArrayList<Node>();
        while (m.find()) {
            Node t;
            int s = m.start(1);
            int len = m.end(1) - s;
            String value = m.group(1);
            if (value.equalsIgnoreCase("DEFAULT")) {
                t = new DefaultNode();
            } else if (value.equals("(")) {
                t = new OpeningBracketNode();
            } else if (value.equals(")")) {
                t = new ClosingBracketNode();
            } else if (value.equalsIgnoreCase("and")) {
                t = new AndNode();
            } else if (value.equalsIgnoreCase("or")) {
                t = new OrNode();
            } else if (value.equalsIgnoreCase("not")) {
                t = new NotNode();
            } else if (value.startsWith("@")) {
                t = new TestGroupNode();
            } else {
                throw new SyntaxException(null, String.format(Locale.ENGLISH, "Unrecognized token '%s'. At: \"%s\"", value == null ? "<null>" : value, new InputRange(rule, s, len)));
            }
            t.range = new InputRange(rule, s, len);
            tokens.add(t);
        }
        EosNode eos = new EosNode();
        eos.range = new InputRange(rule, rule.length(), 0);
        tokens.add(eos);
        return tokens.iterator();
    }

    class TestGroupNode
    extends Node {
        TestGroupNode() {
        }

        @Override
        Node nud() {
            return this;
        }

        @Override
        protected StringBuilder toExpression(StringBuilder b) {
            b.append(this.range.value());
            return b;
        }

        @Override
        public boolean evaluate(IContext context) {
            return context.hasGroup(this.range.value());
        }
    }

    class ClosingBracketNode
    extends Node {
        ClosingBracketNode() {
        }

        @Override
        Node led(Node left) {
            throw new SyntaxException(this, "Unbalanced parenthesis.");
        }
    }

    class OpeningBracketNode
    extends Node {
        OpeningBracketNode() {
        }

        @Override
        Node nud() {
            Node expr = FilterExpressionParser.this.expression(0);
            if (FilterExpressionParser.this.current.getClass() != ClosingBracketNode.class) {
                throw new SyntaxException(FilterExpressionParser.this.current, "Expected closing bracket.");
            }
            FilterExpressionParser.this.current = (Node)FilterExpressionParser.this.nodes.next();
            return expr;
        }
    }

    class NotNode
    extends Node {
        public NotNode() {
            this.lbp = 40;
        }

        @Override
        Node nud() {
            this.args = new Node[]{FilterExpressionParser.this.expression(this.lbp)};
            return this;
        }

        @Override
        protected StringBuilder toExpression(StringBuilder b) {
            assert (this.args.length == 1);
            b.append("(NOT ");
            b.append(this.args[0].toExpression());
            b.append(")");
            return b;
        }

        @Override
        public boolean evaluate(IContext context) {
            assert (this.args.length == 1);
            return !this.args[0].evaluate(context);
        }
    }

    class OrNode
    extends InfixNode {
        public OrNode() {
            this.lbp = 20;
        }

        @Override
        protected StringBuilder toExpression(StringBuilder b) {
            assert (this.args.length == 2);
            b.append("(");
            b.append(this.args[0].toExpression());
            b.append(" OR ");
            b.append(this.args[1].toExpression());
            b.append(")");
            return b;
        }

        @Override
        public boolean evaluate(IContext context) {
            assert (this.args.length == 2);
            return this.args[0].evaluate(context) || this.args[1].evaluate(context);
        }
    }

    class AndNode
    extends InfixNode {
        public AndNode() {
            this.lbp = 30;
        }

        @Override
        protected StringBuilder toExpression(StringBuilder b) {
            assert (this.args.length == 2);
            b.append("(");
            b.append(this.args[0].toExpression());
            b.append(" AND ");
            b.append(this.args[1].toExpression());
            b.append(")");
            return b;
        }

        @Override
        public boolean evaluate(IContext context) {
            assert (this.args.length == 2);
            return this.args[0].evaluate(context) && this.args[1].evaluate(context);
        }
    }

    abstract class InfixNode
    extends Node {
        InfixNode() {
        }

        @Override
        Node led(Node left) {
            if (!FilterExpressionParser.this.nodes.hasNext()) {
                throw new SyntaxException(this, "Missing argument for " + this.toString().toUpperCase(Locale.ENGLISH) + ".");
            }
            this.args = new Node[]{left, FilterExpressionParser.this.expression(this.lbp)};
            return this;
        }
    }

    class DefaultNode
    extends Node {
        DefaultNode() {
        }

        @Override
        Node nud() {
            return this;
        }

        @Override
        protected StringBuilder toExpression(StringBuilder b) {
            b.append("default");
            return b;
        }

        @Override
        public boolean evaluate(IContext context) {
            return context.defaultValue();
        }
    }

    class EosNode
    extends Node {
        public EosNode() {
            this.lbp = -1;
        }
    }

    public abstract class Node {
        int lbp;
        Node[] args = EMPTY;
        public InputRange range;

        Node nud() {
            throw new SyntaxException(this, "Syntax error.");
        }

        Node led(Node left) {
            throw new SyntaxException(this, "Not an operator.");
        }

        public String toString() {
            return this.getClass().getSimpleName().replace("Node", "");
        }

        public final String toExpression() {
            return this.toExpression(new StringBuilder()).toString();
        }

        protected StringBuilder toExpression(StringBuilder b) {
            throw new UnsupportedOperationException("Not an expression node: " + this.toString());
        }

        public boolean evaluate(IContext context) {
            throw new UnsupportedOperationException("Not an evaluation node: " + this.toString());
        }
    }

    static class InputRange {
        final String s;
        final int start;
        final int len;

        InputRange(String value, int start, int length) {
            this.s = value;
            this.start = start;
            this.len = length;
        }

        public String value() {
            return this.s.substring(this.start, this.start + this.len);
        }

        public String toString() {
            return this.s.substring(0, this.start) + ">" + this.value() + "<" + this.s.substring(this.start + this.len);
        }
    }

    static interface IContext {
        public boolean defaultValue();

        public boolean hasGroup(String var1);
    }

    final class SyntaxException
    extends RuntimeException {
        final Node node;

        SyntaxException(Node node, String msg) {
            super(msg);
            this.node = node;
        }

        @Override
        public String getMessage() {
            if (this.node != null && this.node.range != null) {
                return super.getMessage() + " At: \"" + this.node.range + "\"";
            }
            return super.getMessage();
        }
    }
}

