/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class OldBackupDirectory
implements Comparable<OldBackupDirectory> {
    File dir;
    Date timestamp;
    private final Pattern dirNamePattern = Pattern.compile("^snapshot[.](.*)$");

    OldBackupDirectory(File dir) {
        Matcher m;
        if (dir.isDirectory() && (m = this.dirNamePattern.matcher(dir.getName())).find()) {
            try {
                this.dir = dir;
                this.timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).parse(m.group(1));
            }
            catch (Exception e) {
                this.dir = null;
                this.timestamp = null;
            }
        }
    }

    @Override
    public int compareTo(OldBackupDirectory that) {
        return that.timestamp.compareTo(this.timestamp);
    }
}

