/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessorChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContentStreamHandlerBase
extends RequestHandlerBase {
    public static Logger log = LoggerFactory.getLogger(ContentStreamHandlerBase.class);

    @Override
    public void init(NamedList args) {
        Object caching;
        super.init(args);
        this.httpCaching = false;
        if (args != null && (caching = args.get("httpCaching")) != null) {
            this.httpCaching = Boolean.parseBoolean(caching.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrParams params = req.getParams();
        UpdateRequestProcessorChain processorChain = req.getCore().getUpdateProcessorChain(params);
        UpdateRequestProcessor processor = processorChain.createProcessor(req, rsp);
        try {
            ContentStreamLoader documentLoader = this.newLoader(req, processor);
            Iterable<ContentStream> streams = req.getContentStreams();
            if (streams == null) {
                if (!RequestHandlerUtils.handleCommit(req, processor, params, false) && !RequestHandlerUtils.handleRollback(req, processor, params, false)) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing content stream");
                }
            } else {
                for (ContentStream stream : streams) {
                    documentLoader.load(req, rsp, stream, processor);
                }
                RequestHandlerUtils.handleCommit(req, processor, params, false);
                RequestHandlerUtils.handleRollback(req, processor, params, false);
            }
        }
        finally {
            processor.finish();
        }
    }

    protected abstract ContentStreamLoader newLoader(SolrQueryRequest var1, UpdateRequestProcessor var2);
}

