/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.PivotFacet;
import org.apache.solr.handler.component.PivotFacetFieldValueCollection;
import org.apache.solr.handler.component.PivotFacetHelper;
import org.apache.solr.handler.component.PivotFacetValue;
import org.apache.solr.handler.component.ResponseBuilder;

public class PivotFacetField {
    public final String field;
    public final PivotFacetValue parentValue;
    public final PivotFacetFieldValueCollection valueCollection;
    private final int facetFieldLimit;
    private final int facetFieldMinimumCount;
    private final int facetFieldOffset;
    private final String facetFieldSort;
    private final Map<Integer, Integer> numberOfValuesContributedByShard = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> shardLowestCount = new HashMap<Integer, Integer>();
    private boolean needRefinementAtThisLevel = true;

    private PivotFacetField(ResponseBuilder rb, PivotFacetValue parent, String fieldName) {
        this.field = fieldName;
        this.parentValue = parent;
        SolrParams parameters = rb.req.getParams();
        this.facetFieldMinimumCount = parameters.getFieldInt(this.field, "facet.pivot.mincount", 1);
        this.facetFieldOffset = parameters.getFieldInt(this.field, "facet.offset", 0);
        this.facetFieldLimit = parameters.getFieldInt(this.field, "facet.limit", 100);
        String defaultSort = this.facetFieldLimit > 0 ? "count" : "index";
        this.facetFieldSort = parameters.getFieldParam(this.field, "facet.sort", defaultSort);
        this.valueCollection = new PivotFacetFieldValueCollection(this.facetFieldMinimumCount, this.facetFieldOffset, this.facetFieldLimit, this.facetFieldSort);
        if (this.facetFieldLimit < 0 || this.facetFieldLimit <= 0 && this.facetFieldMinimumCount == 0 || this.facetFieldSort.equals("index") && this.facetFieldMinimumCount <= 0) {
            this.needRefinementAtThisLevel = false;
        }
    }

    public List<String> getValuePath() {
        if (null != this.parentValue) {
            return this.parentValue.getValuePath();
        }
        return new ArrayList<String>(3);
    }

    public static PivotFacetField createFromListOfNamedLists(int shardNumber, ResponseBuilder rb, PivotFacetValue owner, List<NamedList<Object>> pivotValues) {
        if (null == pivotValues || pivotValues.size() <= 0) {
            return null;
        }
        NamedList<Object> firstValue = pivotValues.get(0);
        PivotFacetField createdPivotFacetField = new PivotFacetField(rb, owner, PivotFacetHelper.getField(firstValue));
        int lowestCount = Integer.MAX_VALUE;
        for (NamedList<Object> pivotValue : pivotValues) {
            lowestCount = Math.min(lowestCount, PivotFacetHelper.getCount(pivotValue));
            PivotFacetValue newValue = PivotFacetValue.createFromNamedList(shardNumber, rb, createdPivotFacetField, pivotValue);
            createdPivotFacetField.valueCollection.add(newValue);
        }
        createdPivotFacetField.shardLowestCount.put(shardNumber, lowestCount);
        createdPivotFacetField.numberOfValuesContributedByShard.put(shardNumber, pivotValues.size());
        return createdPivotFacetField;
    }

    public void trim() {
        this.valueCollection.trim();
    }

    public void sort() {
        this.valueCollection.sort();
    }

    public List<NamedList<Object>> convertToListOfNamedLists() {
        LinkedList<NamedList<Object>> convertedPivotList = null;
        if (this.valueCollection.size() > 0) {
            convertedPivotList = new LinkedList<NamedList<Object>>();
            for (PivotFacetValue pivot : this.valueCollection) {
                convertedPivotList.add(pivot.convertToNamedList());
            }
        }
        return convertedPivotList;
    }

    public void queuePivotRefinementRequests(PivotFacet pf) {
        if (this.needRefinementAtThisLevel && !this.valueCollection.getExplicitValuesList().isEmpty()) {
            if ("count".equals(this.facetFieldSort)) {
                int indexOfCountThreshold = Math.min(this.valueCollection.getExplicitValuesListSize(), this.facetFieldOffset + this.facetFieldLimit) - 1;
                int countThreshold = this.valueCollection.getAt(indexOfCountThreshold).getCount();
                int positionInResults = 0;
                for (PivotFacetValue value : this.valueCollection.getExplicitValuesList()) {
                    if (positionInResults <= indexOfCountThreshold) {
                        this.processDefiniteCandidateElement(pf, value);
                    } else {
                        this.processPossibleCandidateElement(pf, value, countThreshold);
                    }
                    ++positionInResults;
                }
            } else {
                for (PivotFacetValue value : this.valueCollection.getExplicitValuesList()) {
                    this.processDefiniteCandidateElement(pf, value);
                }
            }
            this.needRefinementAtThisLevel = false;
        }
        if (pf.isRefinementsRequired()) {
            return;
        }
        this.refineNextLevelOfFacets(pf);
    }

    private void processDefiniteCandidateElement(PivotFacet pf, PivotFacetValue value) {
        int shard = pf.knownShards.nextSetBit(0);
        while (0 <= shard) {
            if (!value.shardHasContributed(shard) && ("index".equals(this.facetFieldSort) || this.numberOfValuesContributedByShardWasLimitedByFacetFieldLimit(shard))) {
                pf.addRefinement(shard, value);
            }
            shard = pf.knownShards.nextSetBit(shard + 1);
        }
    }

    private boolean numberOfValuesContributedByShardWasLimitedByFacetFieldLimit(int shardNumber) {
        return this.facetFieldLimit <= this.numberOfValuesContributedByShard(shardNumber);
    }

    private int numberOfValuesContributedByShard(int shardNumber) {
        return this.numberOfValuesContributedByShard.containsKey(shardNumber) ? this.numberOfValuesContributedByShard.get(shardNumber) : 0;
    }

    private void processPossibleCandidateElement(PivotFacet pf, PivotFacetValue value, int refinementThreshold) {
        assert ("count".equals(this.facetFieldSort)) : "Method only makes sense when sorting by count";
        int maxPossibleCountAfterRefinement = value.getCount();
        int shard = pf.knownShards.nextSetBit(0);
        while (0 <= shard) {
            if (!value.shardHasContributed(shard)) {
                maxPossibleCountAfterRefinement += this.lowestCountContributedbyShard(shard);
            }
            shard = pf.knownShards.nextSetBit(shard + 1);
        }
        if (refinementThreshold <= maxPossibleCountAfterRefinement) {
            this.processDefiniteCandidateElement(pf, value);
        }
    }

    private int lowestCountContributedbyShard(int shardNumber) {
        return this.shardLowestCount.containsKey(shardNumber) ? this.shardLowestCount.get(shardNumber) : 0;
    }

    private void refineNextLevelOfFacets(PivotFacet pf) {
        List<PivotFacetValue> explicitValsToRefine = this.valueCollection.getNextLevelValuesToRefine();
        for (PivotFacetValue value : explicitValsToRefine) {
            if (null == value.getChildPivot()) continue;
            value.getChildPivot().queuePivotRefinementRequests(pf);
        }
        PivotFacetValue missing = this.valueCollection.getMissingValue();
        if (null != missing && null != missing.getChildPivot()) {
            missing.getChildPivot().queuePivotRefinementRequests(pf);
        }
    }

    private void incrementShardValueCount(int shardNumber) {
        if (!this.numberOfValuesContributedByShard.containsKey(shardNumber)) {
            this.numberOfValuesContributedByShard.put(shardNumber, 1);
        } else {
            this.numberOfValuesContributedByShard.put(shardNumber, this.numberOfValuesContributedByShard.get(shardNumber) + 1);
        }
    }

    private void contributeValueFromShard(int shardNumber, ResponseBuilder rb, NamedList<Object> shardValue) {
        PivotFacetValue facetValue;
        this.incrementShardValueCount(shardNumber);
        Comparable value = PivotFacetHelper.getValue(shardValue);
        int count = PivotFacetHelper.getCount(shardValue);
        this.valueCollection.markDirty();
        if (!this.shardLowestCount.containsKey(shardNumber) || this.shardLowestCount.get(shardNumber) > count) {
            this.shardLowestCount.put(shardNumber, count);
        }
        if (null == (facetValue = this.valueCollection.get(value))) {
            facetValue = PivotFacetValue.createFromNamedList(shardNumber, rb, this, shardValue);
            this.valueCollection.add(facetValue);
        } else {
            facetValue.mergeContributionFromShard(shardNumber, rb, shardValue);
        }
    }

    public void contributeFromShard(int shardNumber, ResponseBuilder rb, List<NamedList<Object>> response) {
        if (null == response) {
            return;
        }
        for (NamedList<Object> responseValue : response) {
            this.contributeValueFromShard(shardNumber, rb, responseValue);
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "P:%s F:%s V:%s", this.parentValue, this.field, this.valueCollection);
    }
}

