/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.rest.BaseSolrResource;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.PUTable;
import org.apache.solr.rest.schema.BaseFieldTypeResource;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;
import org.noggit.ObjectBuilder;
import org.restlet.data.MediaType;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeResource
extends BaseFieldTypeResource
implements GETable,
PUTable {
    private static final Logger log = LoggerFactory.getLogger(FieldTypeResource.class);
    private String typeName;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.typeName = (String)this.getRequestAttributes().get("name");
            try {
                this.typeName = null == this.typeName ? "" : FieldTypeResource.urlDecode(this.typeName.trim()).trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException((Throwable)e);
            }
        }
    }

    @Override
    public Representation get() {
        try {
            if (this.typeName.isEmpty()) {
                String message = "Field type name is missing";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field type name is missing");
            }
            FieldType fieldType = this.getSchema().getFieldTypes().get(this.typeName);
            if (null == fieldType) {
                String message = "Field type '" + this.typeName + "' not found.";
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, message);
            }
            this.getSolrResponse().add("fieldType", this.getFieldTypeProperties(fieldType));
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    @Override
    protected List<String> getFieldsWithFieldType(FieldType fieldType) {
        ArrayList<String> fields = new ArrayList<String>();
        for (SchemaField schemaField : this.getSchema().getFields().values()) {
            if (!schemaField.getType().getTypeName().equals(fieldType.getTypeName())) continue;
            fields.add(schemaField.getName());
        }
        Collections.sort(fields);
        return fields;
    }

    @Override
    protected List<String> getDynamicFieldsWithFieldType(FieldType fieldType) {
        ArrayList<String> dynamicFields = new ArrayList<String>();
        for (SchemaField prototype : this.getSchema().getDynamicFieldPrototypes()) {
            if (!prototype.getType().getTypeName().equals(fieldType.getTypeName())) continue;
            dynamicFields.add(prototype.getName());
        }
        return dynamicFields;
    }

    @Override
    public Representation put(Representation entity) {
        try {
            if (!this.getSchema().isMutable()) {
                String message = "This IndexSchema is not mutable.";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "This IndexSchema is not mutable.");
            }
            if (null == entity.getMediaType()) {
                entity.setMediaType(MediaType.APPLICATION_JSON);
            }
            if (!entity.getMediaType().equals((Object)MediaType.APPLICATION_JSON, true)) {
                String message = "Only media type " + MediaType.APPLICATION_JSON.toString() + " is accepted." + "  Request has media type " + entity.getMediaType().toString() + ".";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            Object object = ObjectBuilder.fromJSON((String)entity.getText());
            if (!(object instanceof Map)) {
                String message = "Invalid JSON type " + object.getClass().getName() + ", expected Map of the form" + " (ignore the backslashes): {\"name\":\"text_general\", \"class\":\"solr.TextField\" ...}," + " either with or without a \"name\" mapping.  If the \"name\" is specified, it must match the" + " name given in the request URL: /schema/fieldtypes/(name)";
                log.error(message);
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
            }
            this.addOrUpdateFieldType((Map)object);
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSolrResource.SolrOutputRepresentation();
    }

    protected void addOrUpdateFieldType(Map<String, Object> fieldTypeJson) {
        ManagedIndexSchema oldSchema = (ManagedIndexSchema)this.getSchema();
        FieldType newFieldType = FieldTypeResource.buildFieldTypeFromJson(oldSchema, this.typeName, fieldTypeJson);
        this.addNewFieldTypes(Collections.singletonList(newFieldType), oldSchema);
    }

    static FieldType buildFieldTypeFromJson(ManagedIndexSchema oldSchema, String fieldTypeName, Map<String, Object> fieldTypeJson) {
        String bodyTypeName;
        if (1 == fieldTypeJson.size() && fieldTypeJson.containsKey("fieldType")) {
            fieldTypeJson = (Map)fieldTypeJson.get("fieldType");
        }
        if ((bodyTypeName = (String)fieldTypeJson.get("name")) == null) {
            fieldTypeJson.put("name", fieldTypeName);
        } else if (!fieldTypeName.equals(bodyTypeName)) {
            String message = "Field type name in the request body '" + bodyTypeName + "' doesn't match field type name in the request URL '" + fieldTypeName + "'";
            log.error(message);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
        }
        String className = (String)fieldTypeJson.get("class");
        if (className == null) {
            String message = "Missing required 'class' property!";
            log.error(message);
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, message);
        }
        return oldSchema.newFieldType(fieldTypeName, className, fieldTypeJson);
    }
}

