/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DateUtil;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieField;
import org.apache.solr.search.QParser;
import org.apache.solr.util.DateMathParser;

public class TrieDateField
extends TrieField
implements DateValueFieldType {
    public static final TimeZone UTC;
    protected static final TimeZone CANONICAL_TZ;
    protected static final Locale CANONICAL_LOCALE;
    protected static final String NOW = "NOW";
    protected static final char Z = 'Z';
    private static final ThreadLocalDateFormat fmtThreadLocal;

    public TrieDateField() {
        this.type = TrieField.TrieTypes.DATE;
    }

    public Date parseMath(Date now, String val) {
        String math = null;
        DateMathParser p = new DateMathParser();
        if (null != now) {
            p.setNow(now);
        }
        if (val.startsWith(NOW)) {
            math = val.substring(NOW.length());
        } else {
            int zz = val.indexOf(90);
            if (0 < zz) {
                math = val.substring(zz + 1);
                try {
                    p.setNow(TrieDateField.parseDate(val.substring(0, zz + 1)));
                }
                catch (ParseException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date in Date Math String:'" + val + '\'', (Throwable)e);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date String:'" + val + '\'');
            }
        }
        if (null == math || math.equals("")) {
            return p.getNow();
        }
        try {
            return p.parseMath(math);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date Math String:'" + val + '\'', (Throwable)e);
        }
    }

    protected String formatDate(Date d) {
        return ((DateFormat)fmtThreadLocal.get()).format(d);
    }

    public static String formatExternal(Date d) {
        return ((DateFormat)fmtThreadLocal.get()).format(d) + 'Z';
    }

    public String toExternal(Date d) {
        return TrieDateField.formatExternal(d);
    }

    public static Date parseDate(String s) throws ParseException {
        return ((DateFormat)fmtThreadLocal.get()).parse(s);
    }

    public Date parseDateLenient(String s, SolrQueryRequest req) throws ParseException {
        try {
            return ((DateFormat)fmtThreadLocal.get()).parse(s);
        }
        catch (Exception e) {
            return DateUtil.parseDate((String)s);
        }
    }

    public Date parseMathLenient(Date now, String val, SolrQueryRequest req) {
        String math = null;
        DateMathParser p = new DateMathParser();
        if (null != now) {
            p.setNow(now);
        }
        if (val.startsWith(NOW)) {
            math = val.substring(NOW.length());
        } else {
            int zz = val.indexOf(90);
            if (0 < zz) {
                math = val.substring(zz + 1);
                try {
                    p.setNow(this.parseDateLenient(val.substring(0, zz + 1), req));
                }
                catch (ParseException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date in Date Math String: '" + val + '\'', (Throwable)e);
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date String: '" + val + '\'');
            }
        }
        if (null == math || math.equals("")) {
            return p.getNow();
        }
        try {
            return p.parseMath(math);
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid Date Math String: '" + val + '\'', (Throwable)e);
        }
    }

    @Override
    public Date toObject(IndexableField f) {
        return (Date)super.toObject(f);
    }

    public Query getRangeQuery(QParser parser, SchemaField sf, Date min, Date max, boolean minInclusive, boolean maxInclusive) {
        return NumericRangeQuery.newLongRange((String)sf.getName(), (int)this.precisionStep, (Long)(min == null ? null : Long.valueOf(min.getTime())), (Long)(max == null ? null : Long.valueOf(max.getTime())), (boolean)minInclusive, (boolean)maxInclusive);
    }

    @Override
    public Object toNativeType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return val;
        }
        if (val instanceof String) {
            return this.parseMath(null, (String)val);
        }
        return super.toNativeType(val);
    }

    static {
        CANONICAL_TZ = UTC = TimeZone.getTimeZone("UTC");
        CANONICAL_LOCALE = Locale.ROOT;
        fmtThreadLocal = new ThreadLocalDateFormat(new ISO8601CanonicalDateFormat());
    }

    private static class ThreadLocalDateFormat
    extends ThreadLocal<DateFormat> {
        DateFormat proto;

        public ThreadLocalDateFormat(DateFormat d) {
            this.proto = d;
        }

        @Override
        protected DateFormat initialValue() {
            return (DateFormat)this.proto.clone();
        }
    }

    private static class ISO8601CanonicalDateFormat
    extends SimpleDateFormat {
        protected NumberFormat millisParser = NumberFormat.getIntegerInstance(CANONICAL_LOCALE);
        protected NumberFormat millisFormat = new DecimalFormat(".###", new DecimalFormatSymbols(CANONICAL_LOCALE));

        public ISO8601CanonicalDateFormat() {
            super("yyyy-MM-dd'T'HH:mm:ss", CANONICAL_LOCALE);
            this.setTimeZone(CANONICAL_TZ);
        }

        @Override
        public Date parse(String i, ParsePosition p) {
            Date d = super.parse(i, p);
            int milliIndex = p.getIndex();
            if (null != d && -1 == p.getErrorIndex() && milliIndex + 1 < i.length() && '.' == i.charAt(milliIndex)) {
                p.setIndex(++milliIndex);
                Number millis = this.millisParser.parse(i, p);
                if (-1 == p.getErrorIndex()) {
                    int endIndex = p.getIndex();
                    d = new Date(d.getTime() + (long)(millis.doubleValue() * Math.pow(10.0, 3 - endIndex + milliIndex)));
                }
            }
            return d;
        }

        @Override
        public StringBuffer format(Date d, StringBuffer toAppendTo, FieldPosition pos) {
            super.format(d, toAppendTo, pos);
            long millis = d.getTime() % 1000L;
            if (0L == millis) {
                return toAppendTo;
            }
            if (millis < 0L) {
                millis += 1000L;
            }
            int posBegin = toAppendTo.length();
            toAppendTo.append(this.millisFormat.format((double)millis / 1000.0));
            if (8 == pos.getField()) {
                pos.setBeginIndex(posBegin);
                pos.setEndIndex(toAppendTo.length());
            }
            return toAppendTo;
        }

        @Override
        public DateFormat clone() {
            ISO8601CanonicalDateFormat c = (ISO8601CanonicalDateFormat)super.clone();
            c.millisParser = NumberFormat.getIntegerInstance(CANONICAL_LOCALE);
            c.millisFormat = new DecimalFormat(".###", new DecimalFormatSymbols(CANONICAL_LOCALE));
            return c;
        }
    }
}

