/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.search.facet.FacetContext;

public abstract class SlotAcc
implements Closeable {
    String key;
    protected final FacetContext fcontext;

    public SlotAcc(FacetContext fcontext) {
        this.fcontext = fcontext;
    }

    public void setNextReader(LeafReaderContext readerContext) throws IOException {
    }

    public abstract void collect(int var1, int var2) throws IOException;

    public abstract int compare(int var1, int var2);

    public abstract Object getValue(int var1) throws IOException;

    public void setValues(SimpleOrderedMap<Object> bucket, int slotNum) throws IOException {
        if (this.key == null) {
            return;
        }
        bucket.add(this.key, this.getValue(slotNum));
    }

    public abstract void reset();

    public abstract void resize(Resizer var1);

    @Override
    public void close() throws IOException {
    }

    public static abstract class Resizer {
        public abstract int getNewSize();

        public abstract int getNewSlot(int var1);

        public double[] resize(double[] old, double defaultValue) {
            double[] values = new double[this.getNewSize()];
            if (defaultValue != 0.0) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                double val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public int[] resize(int[] old, int defaultValue) {
            int[] values = new int[this.getNewSize()];
            if (defaultValue != 0) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                int val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }

        public <T> T[] resize(T[] old, T defaultValue) {
            Object[] values = (Object[])Array.newInstance(old.getClass().getComponentType(), this.getNewSize());
            if (defaultValue != null) {
                Arrays.fill(values, 0, values.length, defaultValue);
            }
            for (int i = 0; i < old.length; ++i) {
                int newSlot;
                T val = old[i];
                if (val == defaultValue || (newSlot = this.getNewSlot(i)) < 0) continue;
                values[newSlot] = val;
            }
            return values;
        }
    }
}

