/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.shardresultserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.QueryCommand;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.distributed.command.TopGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopGroupsResultTransformer
implements ShardResultTransformer<List<Command>, Map<String, ?>> {
    private final ResponseBuilder rb;
    private static final Logger log = LoggerFactory.getLogger(TopGroupsResultTransformer.class);

    public TopGroupsResultTransformer(ResponseBuilder rb) {
        this.rb = rb;
    }

    @Override
    public NamedList transform(List<Command> data) throws IOException {
        NamedList result = new NamedList();
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        for (Command command : data) {
            NamedList commandResult;
            if (TopGroupsFieldCommand.class.isInstance(command)) {
                TopGroupsFieldCommand fieldCommand = (TopGroupsFieldCommand)command;
                SchemaField groupField = schema.getField(fieldCommand.getKey());
                commandResult = this.serializeTopGroups(fieldCommand.result(), groupField);
            } else if (QueryCommand.class.isInstance(command)) {
                QueryCommand queryCommand = (QueryCommand)command;
                commandResult = this.serializeTopDocs(queryCommand.result());
            } else {
                commandResult = null;
            }
            result.add(command.getKey(), commandResult);
        }
        return result;
    }

    @Override
    public Map<String, ?> transformToNative(NamedList<NamedList> shardResponse, Sort groupSort, Sort sortWithinGroup, String shard) {
        HashMap<String, QueryCommandResult> result = new HashMap<String, QueryCommandResult>();
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        for (Map.Entry entry : shardResponse) {
            String key = (String)entry.getKey();
            NamedList commandResult = (NamedList)entry.getValue();
            Integer totalGroupedHitCount = (Integer)commandResult.get("totalGroupedHitCount");
            Integer totalHits = (Integer)commandResult.get("totalHits");
            if (totalHits != null) {
                Integer matches = (Integer)commandResult.get("matches");
                Float maxScore = (Float)commandResult.get("maxScore");
                if (maxScore == null) {
                    maxScore = Float.valueOf(Float.NaN);
                }
                List documents = (List)commandResult.get("documents");
                ScoreDoc[] scoreDocs = new ScoreDoc[documents.size()];
                int j = 0;
                for (NamedList document : documents) {
                    Object docId = document.get("id");
                    String uniqueId = null;
                    if (docId != null) {
                        uniqueId = docId.toString();
                    } else {
                        log.warn("doc {} has null 'id'", (Object)document);
                    }
                    Float score = (Float)document.get("score");
                    if (score == null) {
                        score = Float.valueOf(Float.NaN);
                    }
                    Object[] sortValues = null;
                    Object sortValuesVal = document.get("sortValues");
                    if (sortValuesVal != null) {
                        sortValues = ((List)sortValuesVal).toArray();
                        for (int k = 0; k < sortValues.length; ++k) {
                            SchemaField field;
                            SchemaField schemaField = field = groupSort.getSort()[k].getField() != null ? schema.getFieldOrNull(groupSort.getSort()[k].getField()) : null;
                            if (field == null) continue;
                            FieldType fieldType = field.getType();
                            if (sortValues[k] == null) continue;
                            sortValues[k] = fieldType.unmarshalSortValue(sortValues[k]);
                        }
                    } else {
                        log.warn("doc {} has null 'sortValues'", (Object)document);
                    }
                    scoreDocs[j++] = new ShardDoc(score.floatValue(), sortValues, uniqueId, shard);
                }
                Object topDocs = sortWithinGroup == null ? new TopDocs(totalHits.intValue(), scoreDocs, maxScore.floatValue()) : new TopFieldDocs(totalHits.intValue(), scoreDocs, sortWithinGroup.getSort(), maxScore.floatValue());
                result.put(key, new QueryCommandResult((TopDocs)topDocs, matches));
                continue;
            }
            Integer totalHitCount = (Integer)commandResult.get("totalHitCount");
            ArrayList<GroupDocs> groupDocs = new ArrayList<GroupDocs>();
            for (int i = 2; i < commandResult.size(); ++i) {
                String groupValue = commandResult.getName(i);
                NamedList groupResult = (NamedList)commandResult.getVal(i);
                Integer totalGroupHits = (Integer)groupResult.get("totalHits");
                Float maxScore = (Float)groupResult.get("maxScore");
                if (maxScore == null) {
                    maxScore = Float.valueOf(Float.NaN);
                }
                List documents = (List)groupResult.get("documents");
                ScoreDoc[] scoreDocs = new ScoreDoc[documents.size()];
                int j = 0;
                for (NamedList document : documents) {
                    String uniqueId = document.get("id").toString();
                    Float score = (Float)document.get("score");
                    if (score == null) {
                        score = Float.valueOf(Float.NaN);
                    }
                    Object[] sortValues = ((List)document.get("sortValues")).toArray();
                    for (int k = 0; k < sortValues.length; ++k) {
                        SchemaField field;
                        SchemaField schemaField = field = sortWithinGroup.getSort()[k].getField() != null ? schema.getFieldOrNull(sortWithinGroup.getSort()[k].getField()) : null;
                        if (field == null) continue;
                        FieldType fieldType = field.getType();
                        if (sortValues[k] == null) continue;
                        sortValues[k] = fieldType.unmarshalSortValue(sortValues[k]);
                    }
                    scoreDocs[j++] = new ShardDoc(score.floatValue(), sortValues, uniqueId, shard);
                }
                BytesRef groupValueRef = groupValue != null ? new BytesRef((CharSequence)groupValue) : null;
                groupDocs.add(new GroupDocs(Float.NaN, maxScore.floatValue(), totalGroupHits.intValue(), scoreDocs, (Object)groupValueRef, null));
            }
            GroupDocs[] groupDocsArr = groupDocs.toArray(new GroupDocs[groupDocs.size()]);
            TopGroups topGroups = new TopGroups(groupSort.getSort(), sortWithinGroup.getSort(), totalHitCount.intValue(), totalGroupedHitCount.intValue(), groupDocsArr, Float.NaN);
            result.put(key, (QueryCommandResult)topGroups);
        }
        return result;
    }

    protected NamedList serializeTopGroups(TopGroups<BytesRef> data, SchemaField groupField) throws IOException {
        NamedList result = new NamedList();
        result.add("totalGroupedHitCount", (Object)data.totalGroupedHitCount);
        result.add("totalHitCount", (Object)data.totalHitCount);
        if (data.totalGroupCount != null) {
            result.add("totalGroupCount", (Object)data.totalGroupCount);
        }
        CharsRef spare = new CharsRef();
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        SchemaField uniqueField = schema.getUniqueKeyField();
        for (GroupDocs searchGroup : data.groups) {
            NamedList groupResult = new NamedList();
            groupResult.add("totalHits", (Object)searchGroup.totalHits);
            if (!Float.isNaN(searchGroup.maxScore)) {
                groupResult.add("maxScore", (Object)Float.valueOf(searchGroup.maxScore));
            }
            ArrayList<NamedList> documents = new ArrayList<NamedList>();
            for (int i = 0; i < searchGroup.scoreDocs.length; ++i) {
                NamedList document = new NamedList();
                documents.add(document);
                Document doc = this.retrieveDocument(uniqueField, searchGroup.scoreDocs[i].doc);
                document.add("id", (Object)uniqueField.getType().toExternal(doc.getField(uniqueField.getName())));
                if (!Float.isNaN(searchGroup.scoreDocs[i].score)) {
                    document.add("score", (Object)Float.valueOf(searchGroup.scoreDocs[i].score));
                }
                if (!(searchGroup.scoreDocs[i] instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)searchGroup.scoreDocs[i];
                Object[] convertedSortValues = new Object[fieldDoc.fields.length];
                for (int j = 0; j < fieldDoc.fields.length; ++j) {
                    SchemaField field;
                    Object sortValue = fieldDoc.fields[j];
                    Sort sortWithinGroup = this.rb.getGroupingSpec().getSortWithinGroup();
                    SchemaField schemaField = field = sortWithinGroup.getSort()[j].getField() != null ? schema.getFieldOrNull(sortWithinGroup.getSort()[j].getField()) : null;
                    if (field != null) {
                        FieldType fieldType = field.getType();
                        if (sortValue != null) {
                            sortValue = fieldType.marshalSortValue(sortValue);
                        }
                    }
                    convertedSortValues[j] = sortValue;
                }
                document.add("sortValues", (Object)convertedSortValues);
            }
            groupResult.add("documents", documents);
            String groupValue = searchGroup.groupValue != null ? groupField.getType().indexedToReadable(((BytesRef)searchGroup.groupValue).utf8ToString()) : null;
            result.add(groupValue, (Object)groupResult);
        }
        return result;
    }

    protected NamedList serializeTopDocs(QueryCommandResult result) throws IOException {
        NamedList queryResult = new NamedList();
        queryResult.add("matches", (Object)result.getMatches());
        queryResult.add("totalHits", (Object)result.getTopDocs().totalHits);
        if (this.rb.getGroupingSpec().isNeedScore()) {
            queryResult.add("maxScore", (Object)Float.valueOf(result.getTopDocs().getMaxScore()));
        }
        ArrayList<NamedList> documents = new ArrayList<NamedList>();
        queryResult.add("documents", documents);
        IndexSchema schema = this.rb.req.getSearcher().getSchema();
        SchemaField uniqueField = schema.getUniqueKeyField();
        CharsRef spare = new CharsRef();
        for (ScoreDoc scoreDoc : result.getTopDocs().scoreDocs) {
            NamedList document = new NamedList();
            documents.add(document);
            Document doc = this.retrieveDocument(uniqueField, scoreDoc.doc);
            document.add("id", (Object)uniqueField.getType().toExternal(doc.getField(uniqueField.getName())));
            if (this.rb.getGroupingSpec().isNeedScore()) {
                document.add("score", (Object)Float.valueOf(scoreDoc.score));
            }
            if (!FieldDoc.class.isInstance(scoreDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)scoreDoc;
            Object[] convertedSortValues = new Object[fieldDoc.fields.length];
            for (int j = 0; j < fieldDoc.fields.length; ++j) {
                SchemaField field;
                Object sortValue = fieldDoc.fields[j];
                Sort groupSort = this.rb.getGroupingSpec().getGroupSort();
                SchemaField schemaField = field = groupSort.getSort()[j].getField() != null ? schema.getFieldOrNull(groupSort.getSort()[j].getField()) : null;
                if (field != null) {
                    FieldType fieldType = field.getType();
                    if (sortValue != null) {
                        sortValue = fieldType.marshalSortValue(sortValue);
                    }
                }
                convertedSortValues[j] = sortValue;
            }
            document.add("sortValues", (Object)convertedSortValues);
        }
        return queryResult;
    }

    private Document retrieveDocument(SchemaField uniqueField, int doc) throws IOException {
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor(new String[]{uniqueField.getName()});
        this.rb.req.getSearcher().doc(doc, (StoredFieldVisitor)visitor);
        return visitor.getDocument();
    }
}

