/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.blockcache;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.store.blockcache.BlockCache;
import org.apache.solr.store.blockcache.BlockCacheKey;
import org.apache.solr.store.blockcache.Cache;
import org.apache.solr.store.blockcache.Metrics;

public class BlockDirectoryCache
implements Cache {
    private final BlockCache blockCache;
    private final AtomicInteger counter = new AtomicInteger();
    private final Map<String, Integer> names = new ConcurrentHashMap<String, Integer>();
    private Set<BlockCacheKey> keysToRelease;
    private final String path;
    private final Metrics metrics;

    public BlockDirectoryCache(BlockCache blockCache, String path, Metrics metrics) {
        this(blockCache, path, metrics, false);
    }

    public BlockDirectoryCache(BlockCache blockCache, String path, Metrics metrics, boolean releaseBlocks) {
        this.blockCache = blockCache;
        this.path = path;
        this.metrics = metrics;
        if (releaseBlocks) {
            this.keysToRelease = Collections.synchronizedSet(new HashSet());
        }
    }

    public BlockCache getBlockCache() {
        return this.blockCache;
    }

    @Override
    public void delete(String name) {
        this.names.remove(name);
    }

    @Override
    public void update(String name, long blockId, int blockOffset, byte[] buffer, int offset, int length) {
        Integer file = this.names.get(name);
        if (file == null) {
            file = this.counter.incrementAndGet();
            this.names.put(name, file);
        }
        BlockCacheKey blockCacheKey = new BlockCacheKey();
        blockCacheKey.setPath(this.path);
        blockCacheKey.setBlock(blockId);
        blockCacheKey.setFile(file);
        if (this.blockCache.store(blockCacheKey, blockOffset, buffer, offset, length) && this.keysToRelease != null) {
            this.keysToRelease.add(blockCacheKey);
        }
    }

    @Override
    public boolean fetch(String name, long blockId, int blockOffset, byte[] b, int off, int lengthToReadInBlock) {
        Integer file = this.names.get(name);
        if (file == null) {
            return false;
        }
        BlockCacheKey blockCacheKey = new BlockCacheKey();
        blockCacheKey.setPath(this.path);
        blockCacheKey.setBlock(blockId);
        blockCacheKey.setFile(file);
        boolean fetch = this.blockCache.fetch(blockCacheKey, b, blockOffset, off, lengthToReadInBlock);
        if (fetch) {
            this.metrics.blockCacheHit.incrementAndGet();
        } else {
            this.metrics.blockCacheMiss.incrementAndGet();
        }
        return fetch;
    }

    @Override
    public long size() {
        return this.blockCache.getSize();
    }

    @Override
    public void renameCacheFile(String source, String dest) {
        Integer file = this.names.remove(source);
        if (file != null) {
            this.names.put(dest, file);
        }
    }

    @Override
    public void releaseResources() {
        if (this.keysToRelease != null) {
            for (BlockCacheKey key : this.keysToRelease) {
                this.blockCache.release(key);
            }
        }
    }
}

