/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateShardHandler {
    private static Logger log = LoggerFactory.getLogger(UpdateShardHandler.class);
    private ExecutorService updateExecutor = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("updateExecutor"));
    private PoolingClientConnectionManager clientConnectionManager;
    private final CloseableHttpClient client;
    private final UpdateShardHandlerConfig cfg;

    @Deprecated
    public UpdateShardHandler(NodeConfig cfg) {
        this(cfg.getUpdateShardHandlerConfig());
    }

    public UpdateShardHandler(UpdateShardHandlerConfig cfg) {
        this.cfg = cfg;
        this.clientConnectionManager = new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
        if (cfg != null) {
            this.clientConnectionManager.setMaxTotal(cfg.getMaxUpdateConnections());
            this.clientConnectionManager.setDefaultMaxPerRoute(cfg.getMaxUpdateConnectionsPerHost());
        }
        ModifiableSolrParams clientParams = this.getClientParams();
        log.info("Creating UpdateShardHandler HTTP client with params: {}", (Object)clientParams);
        this.client = HttpClientUtil.createClient((SolrParams)clientParams, (ClientConnectionManager)this.clientConnectionManager);
    }

    protected ModifiableSolrParams getClientParams() {
        ModifiableSolrParams clientParams = new ModifiableSolrParams();
        if (this.cfg != null) {
            clientParams.set("socketTimeout", this.cfg.getDistributedSocketTimeout());
            clientParams.set("connTimeout", this.cfg.getDistributedConnectionTimeout());
        }
        clientParams.set("retry", true);
        return clientParams;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public void reconfigureHttpClient(HttpClientConfigurer configurer) {
        log.info("Reconfiguring the default client with: " + configurer);
        configurer.configure((DefaultHttpClient)this.client, (SolrParams)this.getClientParams());
    }

    public ClientConnectionManager getConnectionManager() {
        return this.clientConnectionManager;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)this.updateExecutor);
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.client);
            this.clientConnectionManager.shutdown();
        }
    }
}

