/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.TDigest;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.handler.component.StatsField;

class NumericStatsValues
extends AbstractStatsValues<Number> {
    double sum;
    double sumOfSquares;
    AVLTreeDigest tdigest;
    double minD;
    double maxD;
    protected final boolean computeSum;
    protected final boolean computeSumOfSquares;
    protected final boolean computePercentiles;

    public NumericStatsValues(StatsField statsField) {
        super(statsField);
        this.computeSum = statsField.calculateStats(StatsField.Stat.sum);
        this.computeSumOfSquares = statsField.calculateStats(StatsField.Stat.sumOfSquares);
        this.computePercentiles = statsField.calculateStats(StatsField.Stat.percentiles);
        if (this.computePercentiles) {
            this.tdigest = new AVLTreeDigest(statsField.getTdigestCompression());
        }
    }

    @Override
    public long hash(Number v) {
        if (v instanceof Long) {
            return this.hasher.hashLong(v.longValue()).asLong();
        }
        if (v instanceof Integer) {
            return this.hasher.hashInt(v.intValue()).asLong();
        }
        if (v instanceof Double) {
            return this.hasher.hashLong(Double.doubleToRawLongBits(v.doubleValue())).asLong();
        }
        if (v instanceof Float) {
            return this.hasher.hashInt(Float.floatToRawIntBits(v.floatValue())).asLong();
        }
        if (v instanceof Byte) {
            return this.hasher.newHasher().putByte(v.byteValue()).hash().asLong();
        }
        if (v instanceof Short) {
            return this.hasher.newHasher().putShort(v.shortValue()).hash().asLong();
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unsupported Numeric Type (" + v.getClass() + ") for hashing: " + this.statsField);
    }

    @Override
    public void accumulate(int docID) {
        if (this.values.exists(docID)) {
            Number value = (Number)this.values.objectVal(docID);
            this.accumulate(value, 1);
        } else {
            this.missing();
        }
    }

    @Override
    public void updateTypeSpecificStats(NamedList stv) {
        if (this.computeSum) {
            this.sum += ((Number)stv.get("sum")).doubleValue();
        }
        if (this.computeSumOfSquares) {
            this.sumOfSquares += ((Number)stv.get("sumOfSquares")).doubleValue();
        }
        if (this.computePercentiles) {
            byte[] data = (byte[])stv.get("percentiles");
            ByteBuffer buf = ByteBuffer.wrap(data);
            this.tdigest.add((TDigest)AVLTreeDigest.fromBytes((ByteBuffer)buf));
        }
    }

    @Override
    public void updateTypeSpecificStats(Number v, int count) {
        double value = v.doubleValue();
        if (this.computeSumOfSquares) {
            this.sumOfSquares += value * value * (double)count;
        }
        if (this.computeSum) {
            this.sum += value * (double)count;
        }
        if (this.computePercentiles) {
            this.tdigest.add(value, count);
        }
    }

    @Override
    protected void updateMinMax(Number min, Number max) {
        if (this.computeMin && null != min) {
            double minD = min.doubleValue();
            if (null == this.min || minD < this.minD) {
                this.minD = minD;
                this.min = this.minD;
            }
        }
        if (this.computeMax && null != max) {
            double maxD = max.doubleValue();
            if (null == this.max || this.maxD < maxD) {
                this.maxD = maxD;
                this.max = this.maxD;
            }
        }
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
        if (this.statsField.includeInResponse(StatsField.Stat.sum)) {
            res.add("sum", (Object)this.sum);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.sumOfSquares)) {
            res.add("sumOfSquares", (Object)this.sumOfSquares);
        }
        if (this.statsField.includeInResponse(StatsField.Stat.mean)) {
            res.add("mean", (Object)(this.sum / (double)this.count));
        }
        if (this.statsField.includeInResponse(StatsField.Stat.stddev)) {
            res.add("stddev", (Object)this.getStandardDeviation());
        }
        if (this.statsField.includeInResponse(StatsField.Stat.percentiles)) {
            if (this.statsField.getIsShard()) {
                ByteBuffer buf = ByteBuffer.allocate(this.tdigest.byteSize());
                this.tdigest.asSmallBytes(buf);
                res.add("percentiles", (Object)Arrays.copyOf(buf.array(), buf.position()));
            } else {
                NamedList percentileNameList = new NamedList();
                for (Double percentile : this.statsField.getPercentilesList()) {
                    if (this.tdigest.size() == 0L) {
                        percentileNameList.add(percentile.toString(), null);
                        continue;
                    }
                    Double cutoff = this.tdigest.quantile(percentile / 100.0);
                    percentileNameList.add(percentile.toString(), (Object)cutoff);
                }
                res.add("percentiles", (Object)percentileNameList);
            }
        }
    }

    private double getStandardDeviation() {
        if ((double)this.count <= 1.0) {
            return 0.0;
        }
        return Math.sqrt(((double)this.count * this.sumOfSquares - this.sum * this.sum) / ((double)this.count * ((double)this.count - 1.0)));
    }
}

