/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrReturnFields;

class JSONWriter
extends TextResponseWriter {
    private String namedListStyle;
    private String wrapperFunction;
    private static final String JSON_NL_STYLE = "json.nl";
    private static final String JSON_NL_MAP = "map";
    private static final String JSON_NL_FLAT = "flat";
    private static final String JSON_NL_ARROFARR = "arrarr";
    private static final String JSON_NL_ARROFMAP = "arrmap";
    private static final String JSON_WRAPPER_FUNCTION = "json.wrf";
    private static char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public JSONWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
        this.namedListStyle = req.getParams().get(JSON_NL_STYLE, JSON_NL_FLAT).intern();
        this.wrapperFunction = req.getParams().get(JSON_WRAPPER_FUNCTION);
    }

    public void writeResponse() throws IOException {
        Boolean omitHeader;
        if (this.wrapperFunction != null) {
            this.writer.write(this.wrapperFunction + "(");
        }
        if ((omitHeader = this.req.getParams().getBool("omitHeader")) != null && omitHeader.booleanValue()) {
            this.rsp.getValues().remove("responseHeader");
        }
        this.writeNamedList(null, this.rsp.getValues());
        if (this.wrapperFunction != null) {
            this.writer.write(')');
        }
        this.writer.write('\n');
    }

    protected void writeKey(String fname, boolean needsEscaping) throws IOException {
        this.writeStr(null, fname, needsEscaping);
        this.writer.write(':');
    }

    protected void writeNamedListAsMapMangled(String name, NamedList val) throws IOException {
        int sz = val.size();
        this.writeMapOpener(sz);
        this.incLevel();
        HashMap<String, Integer> repeats = new HashMap<String, Integer>(4);
        boolean first = true;
        for (int i = 0; i < sz; ++i) {
            String key = val.getName(i);
            if (key == null) {
                key = "";
            }
            if (first) {
                first = false;
                repeats.put(key, 0);
            } else {
                this.writeMapSeparator();
                Integer repeatCount = (Integer)repeats.get(key);
                if (repeatCount == null) {
                    repeats.put(key, 0);
                } else {
                    String newKey = key;
                    int newCount = repeatCount;
                    while ((repeatCount = (Integer)repeats.get(newKey = key + ' ' + ++newCount)) != null) {
                    }
                    repeats.put(key, newCount);
                    key = newKey;
                }
            }
            this.indent();
            this.writeKey(key, true);
            this.writeVal(key, val.getVal(i));
        }
        this.decLevel();
        this.writeMapCloser();
    }

    protected void writeNamedListAsMapWithDups(String name, NamedList val) throws IOException {
        int sz = val.size();
        this.writeMapOpener(sz);
        this.incLevel();
        for (int i = 0; i < sz; ++i) {
            String key;
            if (i != 0) {
                this.writeMapSeparator();
            }
            if ((key = val.getName(i)) == null) {
                key = "";
            }
            this.indent();
            this.writeKey(key, true);
            this.writeVal(key, val.getVal(i));
        }
        this.decLevel();
        this.writeMapCloser();
    }

    protected void writeNamedListAsArrMap(String name, NamedList val) throws IOException {
        int sz = val.size();
        this.indent();
        this.writeArrayOpener(sz);
        this.incLevel();
        boolean first = true;
        for (int i = 0; i < sz; ++i) {
            String key = val.getName(i);
            if (first) {
                first = false;
            } else {
                this.writeArraySeparator();
            }
            this.indent();
            if (key == null) {
                this.writeVal(null, val.getVal(i));
                continue;
            }
            this.writeMapOpener(1);
            this.writeKey(key, true);
            this.writeVal(key, val.getVal(i));
            this.writeMapCloser();
        }
        this.decLevel();
        this.writeArrayCloser();
    }

    protected void writeNamedListAsArrArr(String name, NamedList val) throws IOException {
        int sz = val.size();
        this.indent();
        this.writeArrayOpener(sz);
        this.incLevel();
        boolean first = true;
        for (int i = 0; i < sz; ++i) {
            String key = val.getName(i);
            if (first) {
                first = false;
            } else {
                this.writeArraySeparator();
            }
            this.indent();
            this.writeArrayOpener(1);
            this.incLevel();
            if (key == null) {
                this.writeNull(null);
            } else {
                this.writeStr(null, key, true);
            }
            this.writeArraySeparator();
            this.writeVal(key, val.getVal(i));
            this.decLevel();
            this.writeArrayCloser();
        }
        this.decLevel();
        this.writeArrayCloser();
    }

    protected void writeNamedListAsFlat(String name, NamedList val) throws IOException {
        int sz = val.size();
        this.writeArrayOpener(sz);
        this.incLevel();
        for (int i = 0; i < sz; ++i) {
            if (i != 0) {
                this.writeArraySeparator();
            }
            String key = val.getName(i);
            this.indent();
            if (key == null) {
                this.writeNull(null);
            } else {
                this.writeStr(null, key, true);
            }
            this.writeArraySeparator();
            this.writeVal(key, val.getVal(i));
        }
        this.decLevel();
        this.writeArrayCloser();
    }

    @Override
    public void writeNamedList(String name, NamedList val) throws IOException {
        if (val instanceof SimpleOrderedMap) {
            this.writeNamedListAsMapWithDups(name, val);
        } else if (this.namedListStyle == JSON_NL_FLAT) {
            this.writeNamedListAsFlat(name, val);
        } else if (this.namedListStyle == JSON_NL_MAP) {
            this.writeNamedListAsMapWithDups(name, val);
        } else if (this.namedListStyle == JSON_NL_ARROFARR) {
            this.writeNamedListAsArrArr(name, val);
        } else if (this.namedListStyle == JSON_NL_ARROFMAP) {
            this.writeNamedListAsArrMap(name, val);
        }
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, ReturnFields returnFields, int idx) throws IOException {
        if (idx > 0) {
            this.writeArraySeparator();
        }
        this.indent();
        this.writeMapOpener(doc.size());
        this.incLevel();
        boolean first = true;
        for (String fname : doc.getFieldNames()) {
            if (!returnFields.wantsField(fname)) continue;
            if (first) {
                first = false;
            } else {
                this.writeMapSeparator();
            }
            this.indent();
            this.writeKey(fname, true);
            Object val = doc.getFieldValue(fname);
            if (val instanceof List) {
                this.writeArray(name, ((Iterable)val).iterator());
                continue;
            }
            this.writeVal(fname, val);
        }
        if (doc.hasChildDocuments()) {
            if (!first) {
                this.writeMapSeparator();
                this.indent();
            }
            this.writeKey("_childDocuments_", true);
            this.writeArrayOpener(doc.getChildDocumentCount());
            List childDocs = doc.getChildDocuments();
            SolrReturnFields rf = new SolrReturnFields();
            for (int i = 0; i < childDocs.size(); ++i) {
                this.writeSolrDocument(null, (SolrDocument)childDocs.get(i), rf, i);
            }
            this.writeArrayCloser();
        }
        this.decLevel();
        this.writeMapCloser();
    }

    @Override
    public void writeStartDocumentList(String name, long start, int size, long numFound, Float maxScore) throws IOException {
        this.writeMapOpener(maxScore == null ? 3 : 4);
        this.incLevel();
        this.writeKey("numFound", false);
        this.writeLong(null, numFound);
        this.writeMapSeparator();
        this.writeKey("start", false);
        this.writeLong(null, start);
        if (maxScore != null) {
            this.writeMapSeparator();
            this.writeKey("maxScore", false);
            this.writeFloat(null, maxScore.floatValue());
        }
        this.writeMapSeparator();
        this.writeKey("docs", false);
        this.writeArrayOpener(size);
        this.incLevel();
    }

    @Override
    public void writeEndDocumentList() throws IOException {
        this.decLevel();
        this.writeArrayCloser();
        this.decLevel();
        this.indent();
        this.writeMapCloser();
    }

    public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
        this.writer.write('{');
    }

    public void writeMapSeparator() throws IOException {
        this.writer.write(',');
    }

    public void writeMapCloser() throws IOException {
        this.writer.write('}');
    }

    public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
        this.writer.write('[');
    }

    public void writeArraySeparator() throws IOException {
        this.writer.write(',');
    }

    public void writeArrayCloser() throws IOException {
        this.writer.write(']');
    }

    @Override
    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        if (needsEscaping) {
            this.writer.write('\"');
            block9: for (int i = 0; i < val.length(); ++i) {
                char ch = val.charAt(i);
                if (ch > '#' && ch != '\\' && ch < '\u2028' || ch == ' ') {
                    this.writer.write(ch);
                    continue;
                }
                switch (ch) {
                    case '\"': 
                    case '\\': {
                        this.writer.write('\\');
                        this.writer.write(ch);
                        continue block9;
                    }
                    case '\r': {
                        this.writer.write('\\');
                        this.writer.write('r');
                        continue block9;
                    }
                    case '\n': {
                        this.writer.write('\\');
                        this.writer.write('n');
                        continue block9;
                    }
                    case '\t': {
                        this.writer.write('\\');
                        this.writer.write('t');
                        continue block9;
                    }
                    case '\b': {
                        this.writer.write('\\');
                        this.writer.write('b');
                        continue block9;
                    }
                    case '\f': {
                        this.writer.write('\\');
                        this.writer.write('f');
                        continue block9;
                    }
                    case '\u2028': 
                    case '\u2029': {
                        JSONWriter.unicodeEscape(this.writer, ch);
                        continue block9;
                    }
                    default: {
                        if (ch <= '\u001f') {
                            JSONWriter.unicodeEscape(this.writer, ch);
                            continue block9;
                        }
                        this.writer.write(ch);
                    }
                }
            }
            this.writer.write('\"');
        } else {
            this.writer.write('\"');
            this.writer.write(val);
            this.writer.write('\"');
        }
    }

    @Override
    public void writeMap(String name, Map val, boolean excludeOuter, boolean isFirstVal) throws IOException {
        if (!excludeOuter) {
            this.writeMapOpener(val.size());
            this.incLevel();
            isFirstVal = true;
        }
        boolean doIndent = excludeOuter || val.size() > 1;
        for (Map.Entry entry : val.entrySet()) {
            Object e = entry.getKey();
            String k = e == null ? "" : e.toString();
            Object v = entry.getValue();
            if (isFirstVal) {
                isFirstVal = false;
            } else {
                this.writeMapSeparator();
            }
            if (doIndent) {
                this.indent();
            }
            this.writeKey(k, true);
            this.writeVal(k, v);
        }
        if (!excludeOuter) {
            this.decLevel();
            this.writeMapCloser();
        }
    }

    @Override
    public void writeArray(String name, Iterator val) throws IOException {
        this.writeArrayOpener(-1);
        this.incLevel();
        boolean first = true;
        while (val.hasNext()) {
            if (!first) {
                this.indent();
            }
            this.writeVal(null, val.next());
            if (val.hasNext()) {
                this.writeArraySeparator();
            }
            first = false;
        }
        this.decLevel();
        this.writeArrayCloser();
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.writer.write("null");
    }

    @Override
    public void writeInt(String name, String val) throws IOException {
        this.writer.write(val);
    }

    @Override
    public void writeLong(String name, String val) throws IOException {
        this.writer.write(val);
    }

    @Override
    public void writeBool(String name, String val) throws IOException {
        this.writer.write(val);
    }

    @Override
    public void writeFloat(String name, String val) throws IOException {
        this.writer.write(val);
    }

    @Override
    public void writeDouble(String name, String val) throws IOException {
        this.writer.write(val);
    }

    @Override
    public void writeDate(String name, String val) throws IOException {
        this.writeStr(name, val, false);
    }

    protected static void unicodeEscape(Appendable out, int ch) throws IOException {
        out.append('\\');
        out.append('u');
        out.append(hexdigits[ch >>> 12]);
        out.append(hexdigits[ch >>> 8 & 0xF]);
        out.append(hexdigits[ch >>> 4 & 0xF]);
        out.append(hexdigits[ch & 0xF]);
    }

    protected static class MultiValueField {
        final SchemaField sfield;
        final ArrayList<IndexableField> fields;

        MultiValueField(SchemaField sfield, IndexableField firstVal) {
            this.sfield = sfield;
            this.fields = new ArrayList(4);
            this.fields.add(firstVal);
        }
    }
}

