/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.uninverting.UninvertingReader;
import org.apache.solr.common.SolrException;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieFloatField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.FileFloatSource;

public class ExternalFileField
extends FieldType
implements SchemaAware {
    private FieldType ftype;
    private String keyFieldName;
    private IndexSchema schema;
    private float defVal;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        this.restrictProps(3072);
        String ftypeS = args.remove("valType");
        if (ftypeS != null) {
            this.ftype = schema.getFieldTypes().get(ftypeS);
            if (this.ftype != null && !(this.ftype instanceof TrieFloatField)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Only float (TrieFloatField) is currently supported as external field type.  Got " + ftypeS);
            }
        }
        this.keyFieldName = args.remove("keyField");
        String defValS = args.remove("defVal");
        this.defVal = defValS == null ? 0.0f : Float.parseFloat(defValS);
        this.schema = schema;
    }

    @Override
    public void write(TextResponseWriter writer, String name, IndexableField f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        FileFloatSource source = this.getFileFloatSource(field);
        return source.getSortField(reverse);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return this.getFileFloatSource(field, parser.getReq().getCore().getDataDir());
    }

    public FileFloatSource getFileFloatSource(SchemaField field) {
        return this.getFileFloatSource(field, this.schema.getResourceLoader().getDataDir());
    }

    public FileFloatSource getFileFloatSource(SchemaField field, String datadir) {
        return new FileFloatSource(field, this.getKeyField(), this.defVal, datadir);
    }

    private SchemaField getKeyField() {
        return this.keyFieldName == null ? this.schema.getUniqueKeyField() : this.schema.getField(this.keyFieldName);
    }

    @Override
    public void inform(IndexSchema schema) {
        this.schema = schema;
    }
}

