/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.aggregated;

import com.carrotsearch.ant.tasks.junit4.ForkedJvmInfo;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import com.carrotsearch.ant.tasks.junit4.events.TestFinishedEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.AggregatedResultEvent;
import com.carrotsearch.ant.tasks.junit4.events.aggregated.TestStatus;
import com.carrotsearch.ant.tasks.junit4.events.mirrors.FailureMirror;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Description;

public class AggregatedTestResultEvent
implements AggregatedResultEvent {
    private final Description suite;
    private final Description description;
    private final ForkedJvmInfo slave;
    private TestStatus status = TestStatus.OK;
    private List failures = Lists.newArrayList();
    private List eventStream;
    private boolean hasFailures;
    private boolean hasErrors;
    private boolean hasIgnoredAssumptions;
    private String ignoreCause;
    private TestFinishedEvent testFinishedEvent;

    public AggregatedTestResultEvent(ForkedJvmInfo forkedJvmInfo, Description description, Description description2) {
        this.description = description2;
        this.suite = description;
        this.slave = forkedJvmInfo;
    }

    @Override
    public Description getDescription() {
        return this.description;
    }

    @Override
    public boolean isSuccessful() {
        return this.status == TestStatus.OK || this.status == TestStatus.IGNORED || this.status == TestStatus.IGNORED_ASSUMPTION;
    }

    public Description getSuiteDescription() {
        return this.suite;
    }

    @Override
    public ForkedJvmInfo getSlave() {
        return this.slave;
    }

    @Override
    public List getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    @Override
    public long getExecutionTime() {
        return this.testFinishedEvent.getExecutionTime();
    }

    @Override
    public long getStartTimestamp() {
        return this.testFinishedEvent.getStartTimestamp();
    }

    @Override
    public List getEventStream() {
        if (this.eventStream == null) {
            throw new RuntimeException("Unfinished test?" + this.suite + ", " + this.description);
        }
        return Collections.unmodifiableList(this.eventStream);
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public String getCauseForIgnored() {
        return this.ignoreCause;
    }

    void setIgnored(String string) {
        assert (this.status == TestStatus.OK);
        this.status = TestStatus.IGNORED;
        this.ignoreCause = string;
    }

    void addFailure(FailureMirror failureMirror) {
        this.failures.add(failureMirror);
        this.hasFailures |= failureMirror.isAssertionViolation();
        this.hasIgnoredAssumptions |= failureMirror.isAssumptionViolation();
        this.hasErrors |= failureMirror.isErrorViolation();
    }

    void complete(TestFinishedEvent testFinishedEvent, List list) {
        this.eventStream = list;
        this.testFinishedEvent = testFinishedEvent;
        if (this.hasErrors) {
            this.status = TestStatus.ERROR;
        } else if (this.hasFailures) {
            this.status = TestStatus.FAILURE;
        } else if (this.hasIgnoredAssumptions) {
            this.status = TestStatus.IGNORED_ASSUMPTION;
        }
    }

    public TestFinishedEvent getTestFinishedEvent() {
        return this.testFinishedEvent;
    }
}

