/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.events.mirrors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class SerializableMirror {
    private byte[] bytes;

    private SerializableMirror() {
    }

    private SerializableMirror(Serializable serializable) {
        this.bytes = SerializableMirror.tryToSerialize(serializable);
    }

    protected byte[] getBytes() {
        return this.bytes;
    }

    protected Serializable getDeserialized() {
        if (this.bytes == null) {
            return null;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.bytes));
        return (Serializable)objectInputStream.readObject();
    }

    private static byte[] tryToSerialize(Serializable serializable) {
        if (serializable != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(serializable);
                objectOutputStream.close();
                return byteArrayOutputStream.toByteArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static SerializableMirror of(Serializable serializable) {
        return new SerializableMirror(serializable);
    }
}

