/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Hashing;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMap;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableMapEntry$TerminalEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap$EntrySet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableMap$NonTerminalMapEntry;
import java.util.Map;
import javax.annotation.Nullable;

final class RegularImmutableMap
extends ImmutableMap {
    private final transient ImmutableMapEntry[] entries;
    private final transient ImmutableMapEntry[] table;
    private final transient int mask;

    RegularImmutableMap(int n, ImmutableMapEntry$TerminalEntry[] immutableMapEntry$TerminalEntryArray) {
        this.entries = this.createEntryArray(n);
        int n2 = Hashing.closedTableSize(n, 1.2);
        this.table = this.createEntryArray(n2);
        this.mask = n2 - 1;
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry$TerminalEntry immutableMapEntry$TerminalEntry = immutableMapEntry$TerminalEntryArray[i];
            Object object = immutableMapEntry$TerminalEntry.getKey();
            int n3 = Hashing.smear(object.hashCode()) & this.mask;
            ImmutableMapEntry immutableMapEntry = this.table[n3];
            ImmutableMapEntry immutableMapEntry2 = immutableMapEntry == null ? immutableMapEntry$TerminalEntry : new RegularImmutableMap$NonTerminalMapEntry(immutableMapEntry$TerminalEntry, immutableMapEntry);
            this.table[n3] = immutableMapEntry2;
            this.entries[i] = immutableMapEntry2;
            this.checkNoConflictInBucket(object, immutableMapEntry2, immutableMapEntry);
        }
    }

    RegularImmutableMap(Map.Entry[] entryArray) {
        int n = entryArray.length;
        this.entries = this.createEntryArray(n);
        int n2 = Hashing.closedTableSize(n, 1.2);
        this.table = this.createEntryArray(n2);
        this.mask = n2 - 1;
        for (int i = 0; i < n; ++i) {
            Map.Entry entry = entryArray[i];
            Object k = entry.getKey();
            Object v = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k, v);
            int n3 = Hashing.smear(k.hashCode()) & this.mask;
            ImmutableMapEntry immutableMapEntry = this.table[n3];
            ImmutableMapEntry immutableMapEntry2 = immutableMapEntry == null ? new ImmutableMapEntry$TerminalEntry(k, v) : new RegularImmutableMap$NonTerminalMapEntry(k, v, immutableMapEntry);
            this.table[n3] = immutableMapEntry2;
            this.entries[i] = immutableMapEntry2;
            this.checkNoConflictInBucket(k, immutableMapEntry2, immutableMapEntry);
        }
    }

    private void checkNoConflictInBucket(Object object, ImmutableMapEntry immutableMapEntry, ImmutableMapEntry immutableMapEntry2) {
        while (immutableMapEntry2 != null) {
            RegularImmutableMap.checkNoConflict(!object.equals(immutableMapEntry2.getKey()), "key", immutableMapEntry, immutableMapEntry2);
            immutableMapEntry2 = immutableMapEntry2.getNextInKeyBucket();
        }
    }

    private ImmutableMapEntry[] createEntryArray(int n) {
        return new ImmutableMapEntry[n];
    }

    @Override
    public Object get(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        int n = Hashing.smear(object.hashCode()) & this.mask;
        for (ImmutableMapEntry immutableMapEntry = this.table[n]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInKeyBucket()) {
            Object object2 = immutableMapEntry.getKey();
            if (!object.equals(object2)) continue;
            return immutableMapEntry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet createEntrySet() {
        return new RegularImmutableMap$EntrySet(this, null);
    }

    static /* synthetic */ ImmutableMapEntry[] access$100(RegularImmutableMap regularImmutableMap) {
        return regularImmutableMap.entries;
    }
}

